/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.validator;

import dev.utils.JCLogUtils;
import dev.utils.common.StringUtils;
import java.util.regex.Pattern;

public final class ValidatorUtils {
    private static final String TAG = ValidatorUtils.class.getSimpleName();
    public static final String REGEX_SPACE = "\\s";
    public static final String REGEX_NUMBER = "^[0-9]*$";
    public static final String REGEX_NUMBER_OR_DECIMAL = "^[0-9]*[.]?[0-9]*$";
    public static final String REGEX_CONTAIN_NUMBER = ".*\\d+.*";
    public static final String REGEX_NUMBER_OR_LETTER = "^[A-Za-z0-9]+$";
    public static final String REGEX_LETTER = "^[A-Za-z]+$";
    public static final String REGEX_SPECIAL = "^[\\u4E00-\\u9FA5A-Za-z0-9]+$";
    public static final String REGEX_WX = "^[a-zA-Z]{1}[-_a-zA-Z0-9]{5,19}+$";
    public static final String REGEX_REALNAME = "^[\\u4e00-\\u9fa5]+(\u2022[\\u4e00-\\u9fa5]*)*$|^[\\u4e00-\\u9fa5]+(\u00b7[\\u4e00-\\u9fa5]*)*$";
    public static final String REGEX_NICKNAME = "^[\\u4E00-\\u9FA5A-Za-z0-9_]+$";
    public static final String REGEX_USERNAME = "^[a-zA-Z]\\w{5,17}$";
    public static final String REGEX_PASSWORD = "^[a-zA-Z0-9]{6,18}$";
    public static final String REGEX_EMAIL = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    public static final String REGEX_URL = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w-./?%&=]*)?";
    public static final String REGEX_IP_ADDRESS = "(2[5][0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})";
    public static final String REGEX_CHINESE = "^[\u4e00-\u9fa5]+$";
    public static final String REGEX_CHINESE_ALL = "^[\u0391-\uffe5]+$";
    public static final String REGEX_CHINESE_ALL2 = "[\u0391-\uffe5]";

    private ValidatorUtils() {
    }

    public static boolean match(String regex, String input) {
        if (!StringUtils.isEmpty(input)) {
            try {
                return Pattern.matches(regex, input);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "match", new Object[0]);
            }
        }
        return false;
    }

    public static boolean isNumber(String str) {
        return ValidatorUtils.match(REGEX_NUMBER, str);
    }

    public static boolean isNumberDecimal(String str) {
        return ValidatorUtils.match(REGEX_NUMBER_OR_DECIMAL, str);
    }

    public static boolean isLetter(String str) {
        return ValidatorUtils.match(REGEX_LETTER, str);
    }

    public static boolean isContainNumber(String str) {
        return ValidatorUtils.match(REGEX_CONTAIN_NUMBER, str);
    }

    public static boolean isNumberLetter(String str) {
        return ValidatorUtils.match(REGEX_NUMBER_OR_LETTER, str);
    }

    public static boolean isSpec(String str) {
        return ValidatorUtils.match(REGEX_SPECIAL, str);
    }

    public static boolean isWx(String str) {
        return ValidatorUtils.match(REGEX_WX, str);
    }

    public static boolean isRealName(String str) {
        return ValidatorUtils.match(REGEX_REALNAME, str);
    }

    public static boolean isNickName(String str) {
        return ValidatorUtils.match(REGEX_NICKNAME, str);
    }

    public static boolean isUserName(String str) {
        return ValidatorUtils.match(REGEX_USERNAME, str);
    }

    public static boolean isPassword(String str) {
        return ValidatorUtils.match(REGEX_PASSWORD, str);
    }

    public static boolean isEmail(String str) {
        return ValidatorUtils.match(REGEX_EMAIL, str);
    }

    public static boolean isUrl(String str) {
        if (!StringUtils.isEmpty(str)) {
            return ValidatorUtils.match(REGEX_URL, str.toLowerCase());
        }
        return false;
    }

    public static boolean isIPAddress(String str) {
        return ValidatorUtils.match(REGEX_IP_ADDRESS, str);
    }

    public static boolean isChinese(String str) {
        return ValidatorUtils.match(REGEX_CHINESE, str);
    }

    public static boolean isChineseAll(String str) {
        return ValidatorUtils.match(REGEX_CHINESE_ALL, str);
    }

    public static boolean isContainChinese(String str) {
        if (!StringUtils.isEmpty(str)) {
            try {
                int length = str.length();
                if (length != 0) {
                    char[] dChar = str.toCharArray();
                    for (int i = 0; i < length; ++i) {
                        boolean flag = String.valueOf(dChar[i]).matches(REGEX_CHINESE_ALL2);
                        if (!flag) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "isContainChinese", new Object[0]);
            }
        }
        return false;
    }
}

