/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ScaleUtils {
    private static final String TAG = ScaleUtils.class.getSimpleName();
    public static final List<XY> XY_LIST;

    private ScaleUtils() {
    }

    public static double calcScale(double dividend, double divisor) {
        try {
            return dividend / divisor;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScale", new Object[0]);
            return -1.0;
        }
    }

    public static double calcScaleToMath(double value1, double value2) {
        try {
            return Math.max(value1, value2) / Math.min(value1, value2);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScaleToMath", new Object[0]);
            return -1.0;
        }
    }

    public static double[] calcScaleToWidth(double targetWidth, double currentWidth, double currentHeight) {
        try {
            if (currentWidth == 0.0) {
                return new double[]{0.0, 0.0};
            }
            double scale = targetWidth / currentWidth;
            double scaleHeight = scale * currentHeight;
            return new double[]{targetWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScaleToWidth", new Object[0]);
            return null;
        }
    }

    public static double[] calcScaleToHeight(double targetHeight, double currentWidth, double currentHeight) {
        try {
            if (currentHeight == 0.0) {
                return new double[]{0.0, 0.0};
            }
            double scale = targetHeight / currentHeight;
            double scaleWidth = scale * currentWidth;
            return new double[]{scaleWidth, targetHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScaleToHeight", new Object[0]);
            return null;
        }
    }

    public static double[] calcWidthHeightToScale(double width, double height, double widthScale, double heightScale) {
        try {
            if (widthScale >= heightScale) {
                double scaleWidth = width;
                double scaleHeight = scaleWidth * (heightScale / widthScale);
                return new double[]{scaleWidth, scaleHeight};
            }
            double scaleHeight = height;
            double scaleWidth = scaleHeight * (widthScale / heightScale);
            return new double[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcWidthHeightToScale", new Object[0]);
            return null;
        }
    }

    public static double[] calcWidthToScale(double width, double widthScale, double heightScale) {
        try {
            double scaleWidth = width;
            double scaleHeight = scaleWidth * (heightScale / widthScale);
            return new double[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcWidthToScale", new Object[0]);
            return null;
        }
    }

    public static double[] calcHeightToScale(double height, double widthScale, double heightScale) {
        try {
            double scaleHeight = height;
            double scaleWidth = scaleHeight * (widthScale / heightScale);
            return new double[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcHeightToScale", new Object[0]);
            return null;
        }
    }

    public static int[] calcScaleToWidthI(double targetWidth, double currentWidth, double currentHeight) {
        double[] result = ScaleUtils.calcScaleToWidth(targetWidth, currentWidth, currentHeight);
        if (result != null) {
            return new int[]{Double.valueOf(result[0]).intValue(), Double.valueOf(result[1]).intValue()};
        }
        return null;
    }

    public static int[] calcScaleToHeightI(double targetHeight, double currentWidth, double currentHeight) {
        double[] result = ScaleUtils.calcScaleToHeight(targetHeight, currentWidth, currentHeight);
        if (result != null) {
            return new int[]{Double.valueOf(result[0]).intValue(), Double.valueOf(result[1]).intValue()};
        }
        return null;
    }

    public static int[] calcWidthHeightToScaleI(double width, double height, double widthScale, double heightScale) {
        double[] result = ScaleUtils.calcWidthHeightToScale(width, height, widthScale, heightScale);
        if (result != null) {
            return new int[]{Double.valueOf(result[0]).intValue(), Double.valueOf(result[1]).intValue()};
        }
        return null;
    }

    public static int[] calcWidthToScaleI(double width, double widthScale, double heightScale) {
        double[] result = ScaleUtils.calcWidthToScale(width, widthScale, heightScale);
        if (result != null) {
            return new int[]{Double.valueOf(result[0]).intValue(), Double.valueOf(result[1]).intValue()};
        }
        return null;
    }

    public static int[] calcHeightToScaleI(double height, double widthScale, double heightScale) {
        double[] result = ScaleUtils.calcHeightToScale(height, widthScale, heightScale);
        if (result != null) {
            return new int[]{Double.valueOf(result[0]).intValue(), Double.valueOf(result[1]).intValue()};
        }
        return null;
    }

    public static long[] calcScaleToWidthL(double targetWidth, double currentWidth, double currentHeight) {
        double[] result = ScaleUtils.calcScaleToWidth(targetWidth, currentWidth, currentHeight);
        if (result != null) {
            return new long[]{Double.valueOf(result[0]).longValue(), Double.valueOf(result[1]).longValue()};
        }
        return null;
    }

    public static long[] calcScaleToHeightL(double targetHeight, double currentWidth, double currentHeight) {
        double[] result = ScaleUtils.calcScaleToHeight(targetHeight, currentWidth, currentHeight);
        if (result != null) {
            return new long[]{Double.valueOf(result[0]).longValue(), Double.valueOf(result[1]).longValue()};
        }
        return null;
    }

    public static long[] calcWidthHeightToScaleL(double width, double height, double widthScale, double heightScale) {
        double[] result = ScaleUtils.calcWidthHeightToScale(width, height, widthScale, heightScale);
        if (result != null) {
            return new long[]{Double.valueOf(result[0]).longValue(), Double.valueOf(result[1]).longValue()};
        }
        return null;
    }

    public static long[] calcWidthToScaleL(double width, double widthScale, double heightScale) {
        double[] result = ScaleUtils.calcWidthToScale(width, widthScale, heightScale);
        if (result != null) {
            return new long[]{Double.valueOf(result[0]).longValue(), Double.valueOf(result[1]).longValue()};
        }
        return null;
    }

    public static long[] calcHeightToScaleL(double height, double widthScale, double heightScale) {
        double[] result = ScaleUtils.calcHeightToScale(height, widthScale, heightScale);
        if (result != null) {
            return new long[]{Double.valueOf(result[0]).longValue(), Double.valueOf(result[1]).longValue()};
        }
        return null;
    }

    public static float[] calcScaleToWidthF(double targetWidth, double currentWidth, double currentHeight) {
        double[] result = ScaleUtils.calcScaleToWidth(targetWidth, currentWidth, currentHeight);
        if (result != null) {
            return new float[]{Double.valueOf(result[0]).floatValue(), Double.valueOf(result[1]).floatValue()};
        }
        return null;
    }

    public static float[] calcScaleToHeightF(double targetHeight, double currentWidth, double currentHeight) {
        double[] result = ScaleUtils.calcScaleToHeight(targetHeight, currentWidth, currentHeight);
        if (result != null) {
            return new float[]{Double.valueOf(result[0]).floatValue(), Double.valueOf(result[1]).floatValue()};
        }
        return null;
    }

    public static float[] calcWidthHeightToScaleF(double width, double height, double widthScale, double heightScale) {
        double[] result = ScaleUtils.calcWidthHeightToScale(width, height, widthScale, heightScale);
        if (result != null) {
            return new float[]{Double.valueOf(result[0]).floatValue(), Double.valueOf(result[1]).floatValue()};
        }
        return null;
    }

    public static float[] calcWidthToScaleF(double width, double widthScale, double heightScale) {
        double[] result = ScaleUtils.calcWidthToScale(width, widthScale, heightScale);
        if (result != null) {
            return new float[]{Double.valueOf(result[0]).floatValue(), Double.valueOf(result[1]).floatValue()};
        }
        return null;
    }

    public static float[] calcHeightToScaleF(double height, double widthScale, double heightScale) {
        double[] result = ScaleUtils.calcHeightToScale(height, widthScale, heightScale);
        if (result != null) {
            return new float[]{Double.valueOf(result[0]).floatValue(), Double.valueOf(result[1]).floatValue()};
        }
        return null;
    }

    public static XY calcXY(int x, int y) {
        return ScaleUtils.calcXY(XY_LIST, x, y);
    }

    public static XY calcXY(List<XY> xyLists, int x, int y) {
        if (xyLists != null && xyLists.size() != 0) {
            ArrayList<XY> lists = new ArrayList<XY>(xyLists);
            Collections.sort(lists);
            double scale = ScaleUtils.calcScale(x, y);
            int len = lists.size();
            for (int i = 0; i < len; ++i) {
                XY xy = (XY)lists.get(i);
                if (!(scale >= xy.scale)) continue;
                return xy;
            }
        }
        return null;
    }

    static {
        ArrayList<XY> xys = new ArrayList<XY>();
        xys.add(new XY(16, 9));
        xys.add(new XY(17, 10));
        xys.add(new XY(15, 9));
        xys.add(new XY(16, 10));
        xys.add(new XY(3, 2));
        xys.add(new XY(4, 3));
        xys.add(new XY(5, 4));
        xys.add(new XY(1, 1));
        XY_LIST = Collections.unmodifiableList(xys);
    }

    public static class XY
    implements Comparable<XY> {
        public final int x;
        public final int y;
        public final double scale;
        public final int type;

        public XY(int x, int y) {
            this(x, y, 0);
        }

        public XY(int x, int y, int type) {
            this.x = x;
            this.y = y;
            this.scale = ScaleUtils.calcScale(x, y);
            this.type = type;
        }

        public String getXYx() {
            return this.getXY("x");
        }

        public String getXY() {
            return this.getXY(":");
        }

        public String getXY(String joint) {
            return this.x + joint + this.y;
        }

        @Override
        public int compareTo(XY xy) {
            return Double.compare(xy.scale, this.scale);
        }
    }
}

