/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.assist.search;

import dev.utils.JCLogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class FileDepthFirstSearchUtils {
    private static final String TAG = FileDepthFirstSearchUtils.class.getSimpleName();
    private SearchHandler mSearchHandler;
    private final SearchHandler mInnerHandler = new SearchHandler(){

        @Override
        public boolean isHandlerFile(File file) {
            if (FileDepthFirstSearchUtils.this.mSearchHandler != null) {
                return FileDepthFirstSearchUtils.this.mSearchHandler.isHandlerFile(file);
            }
            return true;
        }

        @Override
        public boolean isAddToList(File file) {
            if (FileDepthFirstSearchUtils.this.mSearchHandler != null) {
                return FileDepthFirstSearchUtils.this.mSearchHandler.isAddToList(file);
            }
            return true;
        }

        @Override
        public void onEndListener(List<FileItem> lists, long startTime, long endTime) {
            FileDepthFirstSearchUtils.this.mIsRunning = false;
            if (FileDepthFirstSearchUtils.this.mSearchHandler != null) {
                FileDepthFirstSearchUtils.this.mSearchHandler.onEndListener(lists, startTime, endTime);
            }
        }
    };
    private boolean mIsRunning = false;
    private boolean mIsStop = false;
    private long mStartTime = 0L;
    private long mEndTime = 0L;

    public FileDepthFirstSearchUtils() {
    }

    public FileDepthFirstSearchUtils(SearchHandler searchHandler) {
        this.mSearchHandler = searchHandler;
    }

    public FileDepthFirstSearchUtils setSearchHandler(SearchHandler searchHandler) {
        this.mSearchHandler = searchHandler;
        return this;
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public void stop() {
        this.mIsStop = true;
    }

    public boolean isStop() {
        return this.mIsStop;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public synchronized void query(String path, boolean isRelation) {
        if (this.mIsRunning) {
            return;
        }
        if (path == null || path.trim().length() == 0) {
            this.mInnerHandler.onEndListener(null, -1L, -1L);
            return;
        }
        this.mIsRunning = true;
        this.mIsStop = false;
        this.mStartTime = System.currentTimeMillis();
        try {
            File file = new File(path);
            if (file.isFile()) {
                ArrayList<FileItem> lists = new ArrayList<FileItem>();
                lists.add(new FileItem(file));
                this.mEndTime = System.currentTimeMillis();
                this.mInnerHandler.onEndListener(lists, this.mStartTime, this.mEndTime);
                return;
            }
            String[] fileArrays = file.list();
            if (fileArrays != null && fileArrays.length != 0) {
                new Thread(() -> {
                    ArrayList<FileItem> lists = new ArrayList<FileItem>();
                    this.queryFile(file, lists, isRelation);
                    this.mEndTime = System.currentTimeMillis();
                    this.mInnerHandler.onEndListener(lists, this.mStartTime, this.mEndTime);
                }).start();
            } else {
                this.mEndTime = System.currentTimeMillis();
                this.mInnerHandler.onEndListener(null, this.mStartTime, this.mEndTime);
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "query", new Object[0]);
            this.mEndTime = System.currentTimeMillis();
            this.mInnerHandler.onEndListener(null, this.mStartTime, this.mEndTime);
        }
    }

    private void queryFile(File file, List<FileItem> lists, boolean isRelation) {
        try {
            if (this.mIsStop) {
                return;
            }
            if (file != null && file.exists() && this.mInnerHandler.isHandlerFile(file)) {
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files == null) {
                        return;
                    }
                    for (File queryFile : files) {
                        if (isRelation) {
                            if (queryFile.isDirectory()) {
                                ArrayList<FileItem> childs = new ArrayList<FileItem>();
                                this.queryFile(queryFile, childs, isRelation);
                                FileItem fileItem = new FileItem(queryFile);
                                fileItem.listChilds = childs;
                                lists.add(fileItem);
                                continue;
                            }
                            if (!this.mInnerHandler.isAddToList(queryFile)) continue;
                            lists.add(new FileItem(queryFile));
                            continue;
                        }
                        this.queryFile(queryFile, lists, isRelation);
                    }
                } else if (this.mInnerHandler.isAddToList(file)) {
                    lists.add(new FileItem(file));
                }
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "queryFile", new Object[0]);
        }
    }

    public static interface SearchHandler {
        public boolean isHandlerFile(File var1);

        public boolean isAddToList(File var1);

        public void onEndListener(List<FileItem> var1, long var2, long var4);
    }

    public static final class FileItem {
        public File file;
        public List<FileItem> listChilds = null;

        public FileItem(File file) {
            this.file = file;
        }
    }
}

