/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.random;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class AliasMethod {
    private final Random random;
    private final int[] alias;
    private final double[] probability;

    public AliasMethod(List<Double> probabilities) {
        this(probabilities, new Random());
    }

    public AliasMethod(List<Double> probabilities, Random random) {
        if (probabilities == null || random == null) {
            throw new NullPointerException();
        }
        if (probabilities.size() == 0) {
            throw new IllegalArgumentException("Probability vector must be nonempty.");
        }
        this.probability = new double[probabilities.size()];
        this.alias = new int[probabilities.size()];
        this.random = random;
        double average = 1.0 / (double)probabilities.size();
        probabilities = new ArrayList<Double>(probabilities);
        ArrayDeque<Integer> small = new ArrayDeque<Integer>();
        ArrayDeque<Integer> large = new ArrayDeque<Integer>();
        for (int i = 0; i < probabilities.size(); ++i) {
            if (probabilities.get(i) >= average) {
                large.add(i);
                continue;
            }
            small.add(i);
        }
        while (!small.isEmpty() && !large.isEmpty()) {
            int less = (Integer)small.removeLast();
            int more = (Integer)large.removeLast();
            this.probability[less] = probabilities.get(less) * (double)probabilities.size();
            this.alias[less] = more;
            probabilities.set(more, probabilities.get(more) + probabilities.get(less) - average);
            if (probabilities.get(more) >= 1.0 / (double)probabilities.size()) {
                large.add(more);
                continue;
            }
            small.add(more);
        }
        while (!small.isEmpty()) {
            this.probability[((Integer)small.removeLast()).intValue()] = 1.0;
        }
        while (!large.isEmpty()) {
            this.probability[((Integer)large.removeLast()).intValue()] = 1.0;
        }
    }

    public int next() {
        int column = this.random.nextInt(this.probability.length);
        boolean coinToss = this.random.nextDouble() < this.probability[column];
        return coinToss ? column : this.alias[column];
    }
}

