/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.assist;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class WeakReferenceAssist<T> {
    private final String TAG = WeakReferenceAssist.class.getSimpleName();
    private final Map<String, WeakReference<T>> mWeakMaps = new HashMap<String, WeakReference<T>>();

    public WeakReference<T> getSingleWeak() {
        return this.getWeak(this.TAG);
    }

    public T getSingleWeakValue() {
        return this.getWeakValue(this.TAG);
    }

    public T getSingleWeakValue(T defaultValue) {
        return this.getWeakValue(this.TAG, defaultValue);
    }

    public boolean setSingleWeakValue(T value) {
        return this.setWeakValue(this.TAG, value);
    }

    public boolean removeSingleWeak() {
        return this.removeWeak(this.TAG);
    }

    public WeakReference<T> getWeak(String key) {
        return this.mWeakMaps.get(key);
    }

    public T getWeakValue(String key) {
        return this.getWeakValue(key, null);
    }

    public T getWeakValue(String key, T defaultValue) {
        WeakReference<T> weak = this.mWeakMaps.get(key);
        if (weak == null) {
            return defaultValue;
        }
        Object value = weak.get();
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean setWeakValue(String key, T value) {
        if (key == null || value == null) {
            return false;
        }
        this.mWeakMaps.put(key, new WeakReference<T>(value));
        return true;
    }

    public boolean removeWeak(String key) {
        if (key == null) {
            return false;
        }
        WeakReference<T> weak = this.mWeakMaps.remove(key);
        if (weak == null) {
            return false;
        }
        weak.clear();
        return true;
    }

    public void clear() {
        ArrayList<WeakReference<T>> lists = new ArrayList<WeakReference<T>>(this.mWeakMaps.values());
        this.mWeakMaps.clear();
        for (WeakReference weakReference : lists) {
            if (weakReference == null) continue;
            weakReference.clear();
        }
        lists.clear();
    }
}

