/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.common.StringUtils;

public final class HtmlUtils {
    public static final String REMOVE_PADDING_MARGIN_STYLE = "<style>*{ margin:0; padding:0; }</style>";

    private HtmlUtils() {
    }

    public static String addRemovePaddingMargin(String html) {
        return REMOVE_PADDING_MARGIN_STYLE + html;
    }

    public static String addHtmlColor(String content, String color) {
        return "<font color=\"" + color + "\">" + content + "</font>";
    }

    public static String addHtmlColor(String format, String content, String color) {
        return StringUtils.format(format, HtmlUtils.addHtmlColor(content, color));
    }

    public static String addHtmlBold(String content) {
        return "<b>" + content + "</b>";
    }

    public static String addHtmlColorAndBold(String content, String color) {
        return HtmlUtils.addHtmlBold(HtmlUtils.addHtmlColor(content, color));
    }

    public static String addHtmlUnderline(String content) {
        return "<u>" + content + "</u>";
    }

    public static String addHtmlStrikeThruLine(String content) {
        return "<s>" + content + "</s>";
    }

    public static String addHtmlOverLine(String content) {
        return "<span style=\"text-decoration: overline\">" + content + "</span>";
    }

    public static String addHtmlIncline(String content) {
        return "<i>" + content + "</i>";
    }

    public static String addHtmlSPAN(String content) {
        return "<span>" + content + "</span>";
    }

    public static String addHtmlP(String content) {
        return "<p>" + content + "</p>";
    }

    public static String addHtmlIMG(String url) {
        return "<img src=\"" + url + "\"/>";
    }

    public static String addHtmlIMG(String url, String width, String height) {
        return "<img src=\"" + url + "\" width=\"" + width + "\" height=\"" + height + "\"/>";
    }

    public static String addHtmlIMGByWidth(String url, String width) {
        return "<img src=\"" + url + "\" width=\"" + width + "\"/>";
    }

    public static String addHtmlIMGByHeight(String url, String height) {
        return "<img src=\"" + url + "\" height=\"" + height + "\"/>";
    }

    public static String addHtmlDIV(String content) {
        return "<div>" + content + "</div>";
    }

    public static String addHtmlDIVByMargin(String content, String margin) {
        return "<div style=\"margin: " + margin + "\">" + content + "</div>";
    }

    public static String addHtmlDIVByPadding(String content, String padding) {
        return "<div style=\"padding: " + padding + "\">" + content + "</div>";
    }

    public static String addHtmlDIVByMarginPadding(String content, String margin, String padding) {
        return "<div style=\"margin: " + margin + "; padding: " + padding + ";\">" + content + "</div>";
    }

    public static String keywordReplaceHtmlColor(String content, String keyword, String color) {
        return StringUtils.replaceAll(content, keyword, HtmlUtils.addHtmlColor(keyword, color));
    }
}

