/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.ObjectUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ArrayUtils {
    private static final String TAG = ArrayUtils.class.getSimpleName();

    private ArrayUtils() {
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static boolean isEmpty(int[] ints) {
        return ints == null || ints.length == 0;
    }

    public static boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static boolean isEmpty(char[] chars) {
        return chars == null || chars.length == 0;
    }

    public static boolean isEmpty(short[] shorts) {
        return shorts == null || shorts.length == 0;
    }

    public static boolean isEmpty(long[] longs) {
        return longs == null || longs.length == 0;
    }

    public static boolean isEmpty(float[] floats) {
        return floats == null || floats.length == 0;
    }

    public static boolean isEmpty(double[] doubles) {
        return doubles == null || doubles.length == 0;
    }

    public static boolean isEmpty(boolean[] booleans) {
        return booleans == null || booleans.length == 0;
    }

    public static boolean isEmpty(Object object) {
        return object == null || ArrayUtils.length(object) == 0;
    }

    public static boolean isNotEmpty(Object[] objects) {
        return objects != null && objects.length != 0;
    }

    public static boolean isNotEmpty(int[] ints) {
        return ints != null && ints.length != 0;
    }

    public static boolean isNotEmpty(byte[] bytes) {
        return bytes != null && bytes.length != 0;
    }

    public static boolean isNotEmpty(char[] chars) {
        return chars != null && chars.length != 0;
    }

    public static boolean isNotEmpty(short[] shorts) {
        return shorts != null && shorts.length != 0;
    }

    public static boolean isNotEmpty(long[] longs) {
        return longs != null && longs.length != 0;
    }

    public static boolean isNotEmpty(float[] floats) {
        return floats != null && floats.length != 0;
    }

    public static boolean isNotEmpty(double[] doubles) {
        return doubles != null && doubles.length != 0;
    }

    public static boolean isNotEmpty(boolean[] booleans) {
        return booleans != null && booleans.length != 0;
    }

    public static boolean isNotEmpty(Object object) {
        return object != null && ArrayUtils.length(object) != 0;
    }

    public static int length(Object[] objects) {
        return ArrayUtils.length(objects, 0);
    }

    public static int length(int[] ints) {
        return ArrayUtils.length(ints, 0);
    }

    public static int length(byte[] bytes) {
        return ArrayUtils.length(bytes, 0);
    }

    public static int length(char[] chars) {
        return ArrayUtils.length(chars, 0);
    }

    public static int length(short[] shorts) {
        return ArrayUtils.length(shorts, 0);
    }

    public static int length(long[] longs) {
        return ArrayUtils.length(longs, 0);
    }

    public static int length(float[] floats) {
        return ArrayUtils.length(floats, 0);
    }

    public static int length(double[] doubles) {
        return ArrayUtils.length(doubles, 0);
    }

    public static int length(boolean[] booleans) {
        return ArrayUtils.length(booleans, 0);
    }

    public static int length(Object object) {
        return ArrayUtils.length(object, 0);
    }

    public static int length(Object[] objects, int defaultLength) {
        return objects != null ? objects.length : defaultLength;
    }

    public static int length(int[] ints, int defaultLength) {
        return ints != null ? ints.length : defaultLength;
    }

    public static int length(byte[] bytes, int defaultLength) {
        return bytes != null ? bytes.length : defaultLength;
    }

    public static int length(char[] chars, int defaultLength) {
        return chars != null ? chars.length : defaultLength;
    }

    public static int length(short[] shorts, int defaultLength) {
        return shorts != null ? shorts.length : defaultLength;
    }

    public static int length(long[] longs, int defaultLength) {
        return longs != null ? longs.length : defaultLength;
    }

    public static int length(float[] floats, int defaultLength) {
        return floats != null ? floats.length : defaultLength;
    }

    public static int length(double[] doubles, int defaultLength) {
        return doubles != null ? doubles.length : defaultLength;
    }

    public static int length(boolean[] booleans, int defaultLength) {
        return booleans != null ? booleans.length : defaultLength;
    }

    public static int length(Object object, int defaultLength) {
        Class<Object[]> clazz;
        if (object != null && (clazz = object.getClass()).isArray()) {
            try {
                if (clazz.isAssignableFrom(int[].class)) {
                    return ((int[])object).length;
                }
                if (clazz.isAssignableFrom(boolean[].class)) {
                    return ((boolean[])object).length;
                }
                if (clazz.isAssignableFrom(long[].class)) {
                    return ((long[])object).length;
                }
                if (clazz.isAssignableFrom(double[].class)) {
                    return ((double[])object).length;
                }
                if (clazz.isAssignableFrom(float[].class)) {
                    return ((float[])object).length;
                }
                if (clazz.isAssignableFrom(byte[].class)) {
                    return ((byte[])object).length;
                }
                if (clazz.isAssignableFrom(char[].class)) {
                    return ((char[])object).length;
                }
                if (clazz.isAssignableFrom(short[].class)) {
                    return ((short[])object).length;
                }
                return ((Object[])object).length;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "length", new Object[0]);
            }
        }
        return defaultLength;
    }

    public static boolean isLength(Object[] objects, int length) {
        return objects != null && objects.length == length;
    }

    public static boolean isLength(int[] ints, int length) {
        return ints != null && ints.length == length;
    }

    public static boolean isLength(byte[] bytes, int length) {
        return bytes != null && bytes.length == length;
    }

    public static boolean isLength(char[] chars, int length) {
        return chars != null && chars.length == length;
    }

    public static boolean isLength(short[] shorts, int length) {
        return shorts != null && shorts.length == length;
    }

    public static boolean isLength(long[] longs, int length) {
        return longs != null && longs.length == length;
    }

    public static boolean isLength(float[] floats, int length) {
        return floats != null && floats.length == length;
    }

    public static boolean isLength(double[] doubles, int length) {
        return doubles != null && doubles.length == length;
    }

    public static boolean isLength(boolean[] booleans, int length) {
        return booleans != null && booleans.length == length;
    }

    public static boolean isLength(Object object, int length) {
        return object != null && ArrayUtils.length(object) == length;
    }

    public static int getCount(Object ... objects) {
        if (objects == null) {
            return 0;
        }
        int count = 0;
        for (Object object : objects) {
            count += ArrayUtils.length(object);
        }
        return count;
    }

    public static <T> T getByArray(Object array, int pos) {
        return ArrayUtils.getByArray(array, pos, null);
    }

    public static <T> T getByArray(Object array, int pos, T defaultValue) {
        if (array == null || pos < 0) {
            return defaultValue;
        }
        try {
            return (T)Array.get(array, pos);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getByArray", new Object[0]);
            return defaultValue;
        }
    }

    public static <T> T get(T[] array, int pos) {
        return ArrayUtils.get(array, pos, null);
    }

    public static int get(int[] ints, int pos) {
        return ArrayUtils.get(ints, pos, -1);
    }

    public static byte get(byte[] bytes, int pos) {
        return ArrayUtils.get(bytes, pos, (byte)-1);
    }

    public static char get(char[] chars, int pos) {
        return ArrayUtils.get(chars, pos, '\uffff');
    }

    public static short get(short[] shorts, int pos) {
        return ArrayUtils.get(shorts, pos, (short)-1);
    }

    public static long get(long[] longs, int pos) {
        return ArrayUtils.get(longs, pos, -1L);
    }

    public static float get(float[] floats, int pos) {
        return ArrayUtils.get(floats, pos, -1.0f);
    }

    public static double get(double[] doubles, int pos) {
        return ArrayUtils.get(doubles, pos, -1.0);
    }

    public static boolean get(boolean[] booleans, int pos) {
        return ArrayUtils.get(booleans, pos, false);
    }

    public static <T> T get(T[] array, int pos, T defaultValue) {
        if (array == null || pos < 0) {
            return defaultValue;
        }
        try {
            return array[pos];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "get %s", pos);
            return defaultValue;
        }
    }

    public static int get(int[] ints, int pos, int defaultValue) {
        if (ints == null || pos < 0) {
            return defaultValue;
        }
        try {
            return ints[pos];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "get %s", pos);
            return defaultValue;
        }
    }

    public static byte get(byte[] bytes, int pos, byte defaultValue) {
        if (bytes == null || pos < 0) {
            return defaultValue;
        }
        try {
            return bytes[pos];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "get %s", pos);
            return defaultValue;
        }
    }

    public static char get(char[] chars, int pos, char defaultValue) {
        if (chars == null || pos < 0) {
            return defaultValue;
        }
        try {
            return chars[pos];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "get %s", pos);
            return defaultValue;
        }
    }

    public static short get(short[] shorts, int pos, short defaultValue) {
        if (shorts == null || pos < 0) {
            return defaultValue;
        }
        try {
            return shorts[pos];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "get %s", pos);
            return defaultValue;
        }
    }

    public static long get(long[] longs, int pos, long defaultValue) {
        if (longs == null || pos < 0) {
            return defaultValue;
        }
        try {
            return longs[pos];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "get %s", pos);
            return defaultValue;
        }
    }

    public static float get(float[] floats, int pos, float defaultValue) {
        if (floats == null || pos < 0) {
            return defaultValue;
        }
        try {
            return floats[pos];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "get %s", pos);
            return defaultValue;
        }
    }

    public static double get(double[] doubles, int pos, double defaultValue) {
        if (doubles == null || pos < 0) {
            return defaultValue;
        }
        try {
            return doubles[pos];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "get %s", pos);
            return defaultValue;
        }
    }

    public static boolean get(boolean[] booleans, int pos, boolean defaultValue) {
        if (booleans == null || pos < 0) {
            return defaultValue;
        }
        try {
            return booleans[pos];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "get %s", pos);
            return defaultValue;
        }
    }

    public static <T> T getFirst(T[] array) {
        return ArrayUtils.get(array, false);
    }

    public static int getFirst(int[] ints) {
        return ArrayUtils.get(ints, 0);
    }

    public static byte getFirst(byte[] bytes) {
        return ArrayUtils.get(bytes, 0);
    }

    public static char getFirst(char[] chars) {
        return ArrayUtils.get(chars, 0);
    }

    public static short getFirst(short[] shorts) {
        return ArrayUtils.get(shorts, 0);
    }

    public static long getFirst(long[] longs) {
        return ArrayUtils.get(longs, 0);
    }

    public static float getFirst(float[] floats) {
        return ArrayUtils.get(floats, 0);
    }

    public static double getFirst(double[] doubles) {
        return ArrayUtils.get(doubles, 0);
    }

    public static boolean getFirst(boolean[] booleans) {
        return ArrayUtils.get(booleans, 0);
    }

    public static <T> T getLast(T[] array) {
        return ArrayUtils.get(array, ArrayUtils.length(array) - 1);
    }

    public static int getLast(int[] ints) {
        return ArrayUtils.get(ints, ArrayUtils.length(ints) - 1);
    }

    public static byte getLast(byte[] bytes) {
        return ArrayUtils.get(bytes, ArrayUtils.length(bytes) - 1);
    }

    public static char getLast(char[] chars) {
        return ArrayUtils.get(chars, ArrayUtils.length(chars) - 1);
    }

    public static short getLast(short[] shorts) {
        return ArrayUtils.get(shorts, ArrayUtils.length(shorts) - 1);
    }

    public static long getLast(long[] longs) {
        return ArrayUtils.get(longs, ArrayUtils.length(longs) - 1);
    }

    public static float getLast(float[] floats) {
        return ArrayUtils.get(floats, ArrayUtils.length(floats) - 1);
    }

    public static double getLast(double[] doubles) {
        return ArrayUtils.get(doubles, ArrayUtils.length(doubles) - 1);
    }

    public static boolean getLast(boolean[] booleans) {
        return ArrayUtils.get(booleans, ArrayUtils.length(booleans) - 1);
    }

    public static <T> T get(T[] array, T value, int number, boolean notNull, int offset) {
        if (array != null) {
            if (notNull && value == null) {
                return null;
            }
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    T t = array[i];
                    if (!ArrayUtils.equals(t, value)) continue;
                    if (temp - 1 < 0) {
                        return array[i + offset];
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            }
        }
        return null;
    }

    public static <T> int getPosition(T[] array, T value, int number, boolean notNull, int offset) {
        if (array != null) {
            if (notNull && value == null) {
                return -1;
            }
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    T t = array[i];
                    if (!ArrayUtils.equals(t, value)) continue;
                    if (temp - 1 < 0) {
                        return i + offset;
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getPosition", new Object[0]);
            }
        }
        return -1;
    }

    public static <T> T get(T[] array, T value) {
        return ArrayUtils.get(array, value, 0, false, 0);
    }

    public static <T> T get(T[] array, T value, int number) {
        return ArrayUtils.get(array, value, number, false, 0);
    }

    public static <T> T get(T[] array, T value, boolean notNull) {
        return ArrayUtils.get(array, value, 0, notNull, 0);
    }

    public static <T> T get(T[] array, T value, int number, boolean notNull) {
        return ArrayUtils.get(array, value, number, notNull, 0);
    }

    public static <T> T getNotNull(T[] array, T value) {
        return ArrayUtils.get(array, value, 0, true, 0);
    }

    public static <T> T getNotNull(T[] array, T value, int number) {
        return ArrayUtils.get(array, value, number, true, 0);
    }

    public static <T> int getPosition(T[] array, T value) {
        return ArrayUtils.getPosition(array, value, 0, false, 0);
    }

    public static <T> int getPosition(T[] array, T value, int number) {
        return ArrayUtils.getPosition(array, value, number, false, 0);
    }

    public static <T> int getPosition(T[] array, T value, boolean notNull) {
        return ArrayUtils.getPosition(array, value, 0, notNull, 0);
    }

    public static <T> int getPosition(T[] array, T value, int number, boolean notNull) {
        return ArrayUtils.getPosition(array, value, number, notNull, 0);
    }

    public static <T> int getPositionNotNull(T[] array, T value) {
        return ArrayUtils.getPosition(array, value, 0, true, 0);
    }

    public static <T> int getPositionNotNull(T[] array, T value, int number) {
        return ArrayUtils.getPosition(array, value, number, true, 0);
    }

    public static int get(int[] array, int value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    int valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return array[i + offset];
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            }
        }
        return -1;
    }

    public static int getPosition(int[] array, int value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    int valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return i + offset;
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getPosition", new Object[0]);
            }
        }
        return -1;
    }

    public static byte get(byte[] array, byte value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    byte valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return array[i + offset];
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            }
        }
        return -1;
    }

    public static int getPosition(byte[] array, byte value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    byte valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return i + offset;
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getPosition", new Object[0]);
            }
        }
        return -1;
    }

    public static char get(char[] array, char value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    char valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return array[i + offset];
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            }
        }
        return '\uffff';
    }

    public static int getPosition(char[] array, char value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    char valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return i + offset;
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getPosition", new Object[0]);
            }
        }
        return -1;
    }

    public static short get(short[] array, short value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    short valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return array[i + offset];
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            }
        }
        return -1;
    }

    public static int getPosition(short[] array, short value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    short valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return i + offset;
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getPosition", new Object[0]);
            }
        }
        return -1;
    }

    public static long get(long[] array, long value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    long valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return array[i + offset];
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            }
        }
        return -1L;
    }

    public static int getPosition(long[] array, long value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    long valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return i + offset;
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getPosition", new Object[0]);
            }
        }
        return -1;
    }

    public static float get(float[] array, float value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    float valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return array[i + offset];
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            }
        }
        return -1.0f;
    }

    public static int getPosition(float[] array, float value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    float valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return i + offset;
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getPosition", new Object[0]);
            }
        }
        return -1;
    }

    public static double get(double[] array, double value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    double valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return array[i + offset];
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            }
        }
        return -1.0;
    }

    public static int getPosition(double[] array, double value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    double valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return i + offset;
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getPosition", new Object[0]);
            }
        }
        return -1;
    }

    public static boolean get(boolean[] array, boolean value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    boolean valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return array[i + offset];
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            }
        }
        return false;
    }

    public static int getPosition(boolean[] array, boolean value, int number, int offset) {
        if (array != null) {
            try {
                int temp = number;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    boolean valueI = array[i];
                    if (valueI != value) continue;
                    if (temp - 1 < 0) {
                        return i + offset;
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getPosition", new Object[0]);
            }
        }
        return -1;
    }

    public static Integer[] intsToIntegers(int[] ints) {
        if (ints != null) {
            int len = ints.length;
            Integer[] array = new Integer[len];
            for (int i = 0; i < len; ++i) {
                array[i] = ints[i];
            }
            return array;
        }
        return null;
    }

    public static Byte[] bytesToBytes(byte[] bytes) {
        if (bytes != null) {
            int len = bytes.length;
            Byte[] array = new Byte[len];
            for (int i = 0; i < len; ++i) {
                array[i] = bytes[i];
            }
            return array;
        }
        return null;
    }

    public static Character[] charsToCharacters(char[] chars) {
        if (chars != null) {
            int len = chars.length;
            Character[] array = new Character[len];
            for (int i = 0; i < len; ++i) {
                array[i] = Character.valueOf(chars[i]);
            }
            return array;
        }
        return null;
    }

    public static Short[] shortsToShorts(short[] shorts) {
        if (shorts != null) {
            int len = shorts.length;
            Short[] array = new Short[len];
            for (int i = 0; i < len; ++i) {
                array[i] = shorts[i];
            }
            return array;
        }
        return null;
    }

    public static Long[] longsToLongs(long[] longs) {
        if (longs != null) {
            int len = longs.length;
            Long[] array = new Long[len];
            for (int i = 0; i < len; ++i) {
                array[i] = longs[i];
            }
            return array;
        }
        return null;
    }

    public static Float[] floatsToFloats(float[] floats) {
        if (floats != null) {
            int len = floats.length;
            Float[] array = new Float[len];
            for (int i = 0; i < len; ++i) {
                array[i] = Float.valueOf(floats[i]);
            }
            return array;
        }
        return null;
    }

    public static Double[] doublesToDoubles(double[] doubles) {
        if (doubles != null) {
            int len = doubles.length;
            Double[] array = new Double[len];
            for (int i = 0; i < len; ++i) {
                array[i] = doubles[i];
            }
            return array;
        }
        return null;
    }

    public static Boolean[] booleansToBooleans(boolean[] booleans) {
        if (booleans != null) {
            int len = booleans.length;
            Boolean[] array = new Boolean[len];
            for (int i = 0; i < len; ++i) {
                array[i] = booleans[i];
            }
            return array;
        }
        return null;
    }

    public static int[] integersToInts(Integer[] integers, int defaultValue) {
        if (integers != null) {
            int len = integers.length;
            int[] array = new int[len];
            for (int i = 0; i < len; ++i) {
                try {
                    array[i] = integers[i];
                    continue;
                }
                catch (Exception e) {
                    array[i] = defaultValue;
                }
            }
            return array;
        }
        return null;
    }

    public static byte[] bytesToBytes(Byte[] bytes, byte defaultValue) {
        if (bytes != null) {
            int len = bytes.length;
            byte[] array = new byte[len];
            for (int i = 0; i < len; ++i) {
                try {
                    array[i] = bytes[i];
                    continue;
                }
                catch (Exception e) {
                    array[i] = defaultValue;
                }
            }
            return array;
        }
        return null;
    }

    public static char[] charactersToChars(Character[] characters, char defaultValue) {
        if (characters != null) {
            int len = characters.length;
            char[] array = new char[len];
            for (int i = 0; i < len; ++i) {
                try {
                    array[i] = characters[i].charValue();
                    continue;
                }
                catch (Exception e) {
                    array[i] = defaultValue;
                }
            }
            return array;
        }
        return null;
    }

    public static short[] shortsToShorts(Short[] shorts, short defaultValue) {
        if (shorts != null) {
            int len = shorts.length;
            short[] array = new short[len];
            for (int i = 0; i < len; ++i) {
                try {
                    array[i] = shorts[i];
                    continue;
                }
                catch (Exception e) {
                    array[i] = defaultValue;
                }
            }
            return array;
        }
        return null;
    }

    public static long[] longsToLongs(Long[] longs, long defaultValue) {
        if (longs != null) {
            int len = longs.length;
            long[] array = new long[len];
            for (int i = 0; i < len; ++i) {
                try {
                    array[i] = longs[i];
                    continue;
                }
                catch (Exception e) {
                    array[i] = defaultValue;
                }
            }
            return array;
        }
        return null;
    }

    public static float[] floatsToFloats(Float[] floats, float defaultValue) {
        if (floats != null) {
            int len = floats.length;
            float[] array = new float[len];
            for (int i = 0; i < len; ++i) {
                try {
                    array[i] = floats[i].floatValue();
                    continue;
                }
                catch (Exception e) {
                    array[i] = defaultValue;
                }
            }
            return array;
        }
        return null;
    }

    public static double[] doublesToDoubles(Double[] doubles, double defaultValue) {
        if (doubles != null) {
            int len = doubles.length;
            double[] array = new double[len];
            for (int i = 0; i < len; ++i) {
                try {
                    array[i] = doubles[i];
                    continue;
                }
                catch (Exception e) {
                    array[i] = defaultValue;
                }
            }
            return array;
        }
        return null;
    }

    public static boolean[] booleansToBooleans(Boolean[] booleans, boolean defaultValue) {
        if (booleans != null) {
            int len = booleans.length;
            boolean[] array = new boolean[len];
            for (int i = 0; i < len; ++i) {
                try {
                    array[i] = booleans[i];
                    continue;
                }
                catch (Exception e) {
                    array[i] = defaultValue;
                }
            }
            return array;
        }
        return null;
    }

    public static <T> List<T> asList(T[] array) {
        if (array != null) {
            try {
                return new ArrayList<T>(Arrays.asList(array));
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "asList", new Object[0]);
            }
        }
        return null;
    }

    public static <T> List<T> asListArgs(T ... array) {
        if (array != null) {
            try {
                return new ArrayList<T>(Arrays.asList(array));
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "asListArgs", new Object[0]);
            }
        }
        return null;
    }

    public static List<Integer> asList(int[] ints) {
        if (ints != null) {
            ArrayList<Integer> lists = new ArrayList<Integer>();
            for (int value : ints) {
                lists.add(value);
            }
            return lists;
        }
        return null;
    }

    public static List<Byte> asList(byte[] bytes) {
        if (bytes != null) {
            ArrayList<Byte> lists = new ArrayList<Byte>();
            for (byte value : bytes) {
                lists.add(value);
            }
            return lists;
        }
        return null;
    }

    public static List<Character> asList(char[] chars) {
        if (chars != null) {
            ArrayList<Character> lists = new ArrayList<Character>();
            for (char value : chars) {
                lists.add(Character.valueOf(value));
            }
            return lists;
        }
        return null;
    }

    public static List<Short> asList(short[] shorts) {
        if (shorts != null) {
            ArrayList<Short> lists = new ArrayList<Short>();
            for (short value : shorts) {
                lists.add(value);
            }
            return lists;
        }
        return null;
    }

    public static List<Long> asList(long[] longs) {
        if (longs != null) {
            ArrayList<Long> lists = new ArrayList<Long>();
            for (long value : longs) {
                lists.add(value);
            }
            return lists;
        }
        return null;
    }

    public static List<Float> asList(float[] floats) {
        if (floats != null) {
            ArrayList<Float> lists = new ArrayList<Float>();
            for (float value : floats) {
                lists.add(Float.valueOf(value));
            }
            return lists;
        }
        return null;
    }

    public static List<Double> asList(double[] doubles) {
        if (doubles != null) {
            ArrayList<Double> lists = new ArrayList<Double>();
            for (double value : doubles) {
                lists.add(value);
            }
            return lists;
        }
        return null;
    }

    public static List<Boolean> asList(boolean[] booleans) {
        if (booleans != null) {
            ArrayList<Boolean> lists = new ArrayList<Boolean>();
            for (boolean value : booleans) {
                lists.add(value);
            }
            return lists;
        }
        return null;
    }

    public static List<Integer> asListArgsInt(int ... ints) {
        if (ints != null) {
            ArrayList<Integer> lists = new ArrayList<Integer>();
            for (int value : ints) {
                lists.add(value);
            }
            return lists;
        }
        return null;
    }

    public static List<Byte> asListArgsByte(byte ... bytes) {
        if (bytes != null) {
            ArrayList<Byte> lists = new ArrayList<Byte>();
            for (byte value : bytes) {
                lists.add(value);
            }
            return lists;
        }
        return null;
    }

    public static List<Character> asListArgsChar(char ... chars) {
        if (chars != null) {
            ArrayList<Character> lists = new ArrayList<Character>();
            for (char value : chars) {
                lists.add(Character.valueOf(value));
            }
            return lists;
        }
        return null;
    }

    public static List<Short> asListArgsShort(short ... shorts) {
        if (shorts != null) {
            ArrayList<Short> lists = new ArrayList<Short>();
            for (short value : shorts) {
                lists.add(value);
            }
            return lists;
        }
        return null;
    }

    public static List<Long> asListArgsLong(long ... longs) {
        if (longs != null) {
            ArrayList<Long> lists = new ArrayList<Long>();
            for (long value : longs) {
                lists.add(value);
            }
            return lists;
        }
        return null;
    }

    public static List<Float> asListArgsFloat(float ... floats) {
        if (floats != null) {
            ArrayList<Float> lists = new ArrayList<Float>();
            for (float value : floats) {
                lists.add(Float.valueOf(value));
            }
            return lists;
        }
        return null;
    }

    public static List<Double> asListArgsDouble(double ... doubles) {
        if (doubles != null) {
            ArrayList<Double> lists = new ArrayList<Double>();
            for (double value : doubles) {
                lists.add(value);
            }
            return lists;
        }
        return null;
    }

    public static List<Boolean> asListArgsBoolean(boolean ... booleans) {
        if (booleans != null) {
            ArrayList<Boolean> lists = new ArrayList<Boolean>();
            for (boolean value : booleans) {
                lists.add(value);
            }
            return lists;
        }
        return null;
    }

    public static <T> boolean equals(T value1, T value2) {
        return ObjectUtils.equals(value1, value2);
    }

    public static <T> T[] arrayCopy(T[] prefix, T[] suffix) {
        int suffixLength;
        int prefixLength = prefix != null ? prefix.length : 0;
        int n = suffixLength = suffix != null ? suffix.length : 0;
        if (prefixLength + suffixLength == 0) {
            return null;
        }
        ArrayList<T> lists = new ArrayList<T>(prefixLength + suffixLength);
        if (prefixLength != 0) {
            lists.addAll(Arrays.asList(prefix).subList(0, prefixLength));
        }
        if (suffixLength != 0) {
            lists.addAll(Arrays.asList(suffix).subList(0, suffixLength));
        }
        if (prefix != null) {
            return Arrays.copyOf(lists.toArray(), lists.size(), prefix.getClass());
        }
        return Arrays.copyOf(lists.toArray(), lists.size(), suffix.getClass());
    }

    public static int[] arrayCopy(int[] prefix, int[] suffix) {
        int suffixLength;
        int prefixLength = prefix != null ? prefix.length : 0;
        int n = suffixLength = suffix != null ? suffix.length : 0;
        if (prefixLength + suffixLength == 0) {
            return null;
        }
        int[] arrays = new int[prefixLength + suffixLength];
        if (prefixLength != 0) {
            System.arraycopy(prefix, 0, arrays, 0, prefixLength);
        }
        if (suffixLength != 0) {
            System.arraycopy(suffix, 0, arrays, prefixLength, suffixLength);
        }
        return arrays;
    }

    public static byte[] arrayCopy(byte[] prefix, byte[] suffix) {
        int suffixLength;
        int prefixLength = prefix != null ? prefix.length : 0;
        int n = suffixLength = suffix != null ? suffix.length : 0;
        if (prefixLength + suffixLength == 0) {
            return null;
        }
        byte[] arrays = new byte[prefixLength + suffixLength];
        if (prefixLength != 0) {
            System.arraycopy(prefix, 0, arrays, 0, prefixLength);
        }
        if (suffixLength != 0) {
            System.arraycopy(suffix, 0, arrays, prefixLength, suffixLength);
        }
        return arrays;
    }

    public static char[] arrayCopy(char[] prefix, char[] suffix) {
        int suffixLength;
        int prefixLength = prefix != null ? prefix.length : 0;
        int n = suffixLength = suffix != null ? suffix.length : 0;
        if (prefixLength + suffixLength == 0) {
            return null;
        }
        char[] arrays = new char[prefixLength + suffixLength];
        if (prefixLength != 0) {
            System.arraycopy(prefix, 0, arrays, 0, prefixLength);
        }
        if (suffixLength != 0) {
            System.arraycopy(suffix, 0, arrays, prefixLength, suffixLength);
        }
        return arrays;
    }

    public static short[] arrayCopy(short[] prefix, short[] suffix) {
        int suffixLength;
        int prefixLength = prefix != null ? prefix.length : 0;
        int n = suffixLength = suffix != null ? suffix.length : 0;
        if (prefixLength + suffixLength == 0) {
            return null;
        }
        short[] arrays = new short[prefixLength + suffixLength];
        if (prefixLength != 0) {
            System.arraycopy(prefix, 0, arrays, 0, prefixLength);
        }
        if (suffixLength != 0) {
            System.arraycopy(suffix, 0, arrays, prefixLength, suffixLength);
        }
        return arrays;
    }

    public static long[] arrayCopy(long[] prefix, long[] suffix) {
        int suffixLength;
        int prefixLength = prefix != null ? prefix.length : 0;
        int n = suffixLength = suffix != null ? suffix.length : 0;
        if (prefixLength + suffixLength == 0) {
            return null;
        }
        long[] arrays = new long[prefixLength + suffixLength];
        if (prefixLength != 0) {
            System.arraycopy(prefix, 0, arrays, 0, prefixLength);
        }
        if (suffixLength != 0) {
            System.arraycopy(suffix, 0, arrays, prefixLength, suffixLength);
        }
        return arrays;
    }

    public static float[] arrayCopy(float[] prefix, float[] suffix) {
        int suffixLength;
        int prefixLength = prefix != null ? prefix.length : 0;
        int n = suffixLength = suffix != null ? suffix.length : 0;
        if (prefixLength + suffixLength == 0) {
            return null;
        }
        float[] arrays = new float[prefixLength + suffixLength];
        if (prefixLength != 0) {
            System.arraycopy(prefix, 0, arrays, 0, prefixLength);
        }
        if (suffixLength != 0) {
            System.arraycopy(suffix, 0, arrays, prefixLength, suffixLength);
        }
        return arrays;
    }

    public static double[] arrayCopy(double[] prefix, double[] suffix) {
        int suffixLength;
        int prefixLength = prefix != null ? prefix.length : 0;
        int n = suffixLength = suffix != null ? suffix.length : 0;
        if (prefixLength + suffixLength == 0) {
            return null;
        }
        double[] arrays = new double[prefixLength + suffixLength];
        if (prefixLength != 0) {
            System.arraycopy(prefix, 0, arrays, 0, prefixLength);
        }
        if (suffixLength != 0) {
            System.arraycopy(suffix, 0, arrays, prefixLength, suffixLength);
        }
        return arrays;
    }

    public static boolean[] arrayCopy(boolean[] prefix, boolean[] suffix) {
        int suffixLength;
        int prefixLength = prefix != null ? prefix.length : 0;
        int n = suffixLength = suffix != null ? suffix.length : 0;
        if (prefixLength + suffixLength == 0) {
            return null;
        }
        boolean[] arrays = new boolean[prefixLength + suffixLength];
        if (prefixLength != 0) {
            System.arraycopy(prefix, 0, arrays, 0, prefixLength);
        }
        if (suffixLength != 0) {
            System.arraycopy(suffix, 0, arrays, prefixLength, suffixLength);
        }
        return arrays;
    }

    public static <T> T[] newArray(T[] data, int length) {
        if (data != null && length >= 0) {
            return Arrays.copyOf(data, length);
        }
        return null;
    }

    public static int[] newArray(int[] data, int length) {
        if (data != null && length >= 0) {
            return Arrays.copyOf(data, length);
        }
        return null;
    }

    public static byte[] newArray(byte[] data, int length) {
        if (data != null && length >= 0) {
            return Arrays.copyOf(data, length);
        }
        return null;
    }

    public static char[] newArray(char[] data, int length) {
        if (data != null && length >= 0) {
            return Arrays.copyOf(data, length);
        }
        return null;
    }

    public static short[] newArray(short[] data, int length) {
        if (data != null && length >= 0) {
            return Arrays.copyOf(data, length);
        }
        return null;
    }

    public static long[] newArray(long[] data, int length) {
        if (data != null && length >= 0) {
            return Arrays.copyOf(data, length);
        }
        return null;
    }

    public static float[] newArray(float[] data, int length) {
        if (data != null && length >= 0) {
            return Arrays.copyOf(data, length);
        }
        return null;
    }

    public static double[] newArray(double[] data, int length) {
        if (data != null && length >= 0) {
            return Arrays.copyOf(data, length);
        }
        return null;
    }

    public static boolean[] newArray(boolean[] data, int length) {
        if (data != null && length >= 0) {
            return Arrays.copyOf(data, length);
        }
        return null;
    }

    public static <T> T[] subArray(T[] data, int off, int length) {
        if (data == null || off < 0 || length < 0) {
            return null;
        }
        try {
            ArrayList<T> lists = new ArrayList<T>(length);
            lists.addAll(Arrays.asList(data).subList(off, off + length));
            return Arrays.copyOf(lists.toArray(), length, data.getClass());
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "subArray", new Object[0]);
            return null;
        }
    }

    public static int[] subArray(int[] data, int off, int length) {
        if (data == null || off < 0 || length < 0) {
            return null;
        }
        try {
            int[] arrays = new int[length];
            System.arraycopy(data, off, arrays, 0, length);
            return arrays;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "subArray", new Object[0]);
            return null;
        }
    }

    public static byte[] subArray(byte[] data, int off, int length) {
        if (data == null || off < 0 || length < 0) {
            return null;
        }
        try {
            byte[] arrays = new byte[length];
            System.arraycopy(data, off, arrays, 0, length);
            return arrays;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "subArray", new Object[0]);
            return null;
        }
    }

    public static char[] subArray(char[] data, int off, int length) {
        if (data == null || off < 0 || length < 0) {
            return null;
        }
        try {
            char[] arrays = new char[length];
            System.arraycopy(data, off, arrays, 0, length);
            return arrays;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "subArray", new Object[0]);
            return null;
        }
    }

    public static short[] subArray(short[] data, int off, int length) {
        if (data == null || off < 0 || length < 0) {
            return null;
        }
        try {
            short[] arrays = new short[length];
            System.arraycopy(data, off, arrays, 0, length);
            return arrays;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "subArray", new Object[0]);
            return null;
        }
    }

    public static long[] subArray(long[] data, int off, int length) {
        if (data == null || off < 0 || length < 0) {
            return null;
        }
        try {
            long[] arrays = new long[length];
            System.arraycopy(data, off, arrays, 0, length);
            return arrays;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "subArray", new Object[0]);
            return null;
        }
    }

    public static float[] subArray(float[] data, int off, int length) {
        if (data == null || off < 0 || length < 0) {
            return null;
        }
        try {
            float[] arrays = new float[length];
            System.arraycopy(data, off, arrays, 0, length);
            return arrays;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "subArray", new Object[0]);
            return null;
        }
    }

    public static double[] subArray(double[] data, int off, int length) {
        if (data == null || off < 0 || length < 0) {
            return null;
        }
        try {
            double[] arrays = new double[length];
            System.arraycopy(data, off, arrays, 0, length);
            return arrays;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "subArray", new Object[0]);
            return null;
        }
    }

    public static boolean[] subArray(boolean[] data, int off, int length) {
        if (data == null || off < 0 || length < 0) {
            return null;
        }
        try {
            boolean[] arrays = new boolean[length];
            System.arraycopy(data, off, arrays, 0, length);
            return arrays;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "subArray", new Object[0]);
            return null;
        }
    }

    public static <T> String appendToString(T[] data) {
        int len;
        if (data != null && (len = data.length) != 0) {
            if (len == 1) {
                return "\"" + data[0] + "\"";
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < len - 1; ++i) {
                builder.append("\"").append(data[i]).append("\",");
            }
            builder.append("\"").append(data[len - 1]).append("\"");
            return builder.toString();
        }
        return "";
    }

    public static String appendToString(int[] data) {
        int len;
        if (data != null && (len = data.length) != 0) {
            if (len == 1) {
                return "\"" + data[0] + "\"";
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < len - 1; ++i) {
                builder.append("\"").append(data[i]).append("\",");
            }
            builder.append("\"").append(data[len - 1]).append("\"");
            return builder.toString();
        }
        return "";
    }

    public static String appendToString(byte[] data) {
        int len;
        if (data != null && (len = data.length) != 0) {
            if (len == 1) {
                return "\"" + data[0] + "\"";
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < len - 1; ++i) {
                builder.append("\"").append(data[i]).append("\",");
            }
            builder.append("\"").append(data[len - 1]).append("\"");
            return builder.toString();
        }
        return "";
    }

    public static String appendToString(char[] data) {
        int len;
        if (data != null && (len = data.length) != 0) {
            if (len == 1) {
                return "\"" + data[0] + "\"";
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < len - 1; ++i) {
                builder.append("\"").append(data[i]).append("\",");
            }
            builder.append("\"").append(data[len - 1]).append("\"");
            return builder.toString();
        }
        return "";
    }

    public static String appendToString(short[] data) {
        int len;
        if (data != null && (len = data.length) != 0) {
            if (len == 1) {
                return "\"" + data[0] + "\"";
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < len - 1; ++i) {
                builder.append("\"").append(data[i]).append("\",");
            }
            builder.append("\"").append(data[len - 1]).append("\"");
            return builder.toString();
        }
        return "";
    }

    public static String appendToString(long[] data) {
        int len;
        if (data != null && (len = data.length) != 0) {
            if (len == 1) {
                return "\"" + data[0] + "\"";
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < len - 1; ++i) {
                builder.append("\"").append(data[i]).append("\",");
            }
            builder.append("\"").append(data[len - 1]).append("\"");
            return builder.toString();
        }
        return "";
    }

    public static String appendToString(float[] data) {
        int len;
        if (data != null && (len = data.length) != 0) {
            if (len == 1) {
                return "\"" + data[0] + "\"";
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < len - 1; ++i) {
                builder.append("\"").append(data[i]).append("\",");
            }
            builder.append("\"").append(data[len - 1]).append("\"");
            return builder.toString();
        }
        return "";
    }

    public static String appendToString(double[] data) {
        int len;
        if (data != null && (len = data.length) != 0) {
            if (len == 1) {
                return "\"" + data[0] + "\"";
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < len - 1; ++i) {
                builder.append("\"").append(data[i]).append("\",");
            }
            builder.append("\"").append(data[len - 1]).append("\"");
            return builder.toString();
        }
        return "";
    }

    public static String appendToString(boolean[] data) {
        int len;
        if (data != null && (len = data.length) != 0) {
            if (len == 1) {
                return "\"" + data[0] + "\"";
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < len - 1; ++i) {
                builder.append("\"").append(data[i]).append("\",");
            }
            builder.append("\"").append(data[len - 1]).append("\"");
            return builder.toString();
        }
        return "";
    }

    public static int getMinimumIndex(int[] data) {
        int len;
        if (data != null && (len = data.length) > 0) {
            int index = 0;
            int temp = data[index];
            for (int i = 1; i < len; ++i) {
                int value = data[i];
                if (value >= temp) continue;
                index = i;
                temp = value;
            }
            return index;
        }
        return -1;
    }

    public static int getMinimumIndex(long[] data) {
        int len;
        if (data != null && (len = data.length) > 0) {
            int index = 0;
            long temp = data[index];
            for (int i = 1; i < len; ++i) {
                long value = data[i];
                if (value >= temp) continue;
                index = i;
                temp = value;
            }
            return index;
        }
        return -1;
    }

    public static int getMinimumIndex(float[] data) {
        int len;
        if (data != null && (len = data.length) > 0) {
            int index = 0;
            float temp = data[index];
            for (int i = 1; i < len; ++i) {
                float value = data[i];
                if (!(value < temp)) continue;
                index = i;
                temp = value;
            }
            return index;
        }
        return -1;
    }

    public static int getMinimumIndex(double[] data) {
        int len;
        if (data != null && (len = data.length) > 0) {
            int index = 0;
            double temp = data[index];
            for (int i = 1; i < len; ++i) {
                double value = data[i];
                if (!(value < temp)) continue;
                index = i;
                temp = value;
            }
            return index;
        }
        return -1;
    }

    public static int getMaximumIndex(int[] data) {
        int len;
        if (data != null && (len = data.length) > 0) {
            int index = 0;
            int temp = data[index];
            for (int i = 1; i < len; ++i) {
                int value = data[i];
                if (value <= temp) continue;
                index = i;
                temp = value;
            }
            return index;
        }
        return -1;
    }

    public static int getMaximumIndex(long[] data) {
        int len;
        if (data != null && (len = data.length) > 0) {
            int index = 0;
            long temp = data[index];
            for (int i = 1; i < len; ++i) {
                long value = data[i];
                if (value <= temp) continue;
                index = i;
                temp = value;
            }
            return index;
        }
        return -1;
    }

    public static int getMaximumIndex(float[] data) {
        int len;
        if (data != null && (len = data.length) > 0) {
            int index = 0;
            float temp = data[index];
            for (int i = 1; i < len; ++i) {
                float value = data[i];
                if (!(value > temp)) continue;
                index = i;
                temp = value;
            }
            return index;
        }
        return -1;
    }

    public static int getMaximumIndex(double[] data) {
        int len;
        if (data != null && (len = data.length) > 0) {
            int index = 0;
            double temp = data[index];
            for (int i = 1; i < len; ++i) {
                double value = data[i];
                if (!(value > temp)) continue;
                index = i;
                temp = value;
            }
            return index;
        }
        return -1;
    }

    public static int getMinimum(int[] data) {
        try {
            return data[ArrayUtils.getMinimumIndex(data)];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMinimum", new Object[0]);
            return 0;
        }
    }

    public static long getMinimum(long[] data) {
        try {
            return data[ArrayUtils.getMinimumIndex(data)];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMinimum", new Object[0]);
            return 0L;
        }
    }

    public static float getMinimum(float[] data) {
        try {
            return data[ArrayUtils.getMinimumIndex(data)];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMinimum", new Object[0]);
            return 0.0f;
        }
    }

    public static double getMinimum(double[] data) {
        try {
            return data[ArrayUtils.getMinimumIndex(data)];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMinimum", new Object[0]);
            return 0.0;
        }
    }

    public static int getMaximum(int[] data) {
        try {
            return data[ArrayUtils.getMaximumIndex(data)];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMaximum", new Object[0]);
            return 0;
        }
    }

    public static long getMaximum(long[] data) {
        try {
            return data[ArrayUtils.getMaximumIndex(data)];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMaximum", new Object[0]);
            return 0L;
        }
    }

    public static float getMaximum(float[] data) {
        try {
            return data[ArrayUtils.getMaximumIndex(data)];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMaximum", new Object[0]);
            return 0.0f;
        }
    }

    public static double getMaximum(double[] data) {
        try {
            return data[ArrayUtils.getMaximumIndex(data)];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMaximum", new Object[0]);
            return 0.0;
        }
    }

    public static int sumArray(int[] data) {
        return ArrayUtils.sumArray(data, 0, ArrayUtils.length(data), 0);
    }

    public static int sumArray(int[] data, int end) {
        return ArrayUtils.sumArray(data, 0, end, 0);
    }

    public static int sumArray(int[] data, int end, int extra) {
        return ArrayUtils.sumArray(data, 0, end, extra);
    }

    public static int sumArray(int[] data, int start, int end, int extra) {
        int total = 0;
        if (data != null) {
            for (int i = start; i < end; ++i) {
                try {
                    total += data[i] + extra;
                    continue;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "sumArray", new Object[0]);
                }
            }
        }
        return total;
    }

    public static long sumArray(long[] data) {
        return ArrayUtils.sumArray(data, 0, ArrayUtils.length(data), 0L);
    }

    public static long sumArray(long[] data, int end) {
        return ArrayUtils.sumArray(data, 0, end, 0L);
    }

    public static long sumArray(long[] data, int end, long extra) {
        return ArrayUtils.sumArray(data, 0, end, extra);
    }

    public static long sumArray(long[] data, int start, int end, long extra) {
        long total = 0L;
        if (data != null) {
            for (int i = start; i < end; ++i) {
                try {
                    total += data[i] + extra;
                    continue;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "sumArray", new Object[0]);
                }
            }
        }
        return total;
    }

    public static float sumArray(float[] data) {
        return ArrayUtils.sumArray(data, 0, ArrayUtils.length(data), 0.0f);
    }

    public static float sumArray(float[] data, int end) {
        return ArrayUtils.sumArray(data, 0, end, 0.0f);
    }

    public static float sumArray(float[] data, int end, float extra) {
        return ArrayUtils.sumArray(data, 0, end, extra);
    }

    public static float sumArray(float[] data, int start, int end, float extra) {
        float total = 0.0f;
        if (data != null) {
            for (int i = start; i < end; ++i) {
                try {
                    total += data[i] + extra;
                    continue;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "sumArray", new Object[0]);
                }
            }
        }
        return total;
    }

    public static double sumArray(double[] data) {
        return ArrayUtils.sumArray(data, 0, ArrayUtils.length(data), 0.0);
    }

    public static double sumArray(double[] data, int end) {
        return ArrayUtils.sumArray(data, 0, end, 0.0);
    }

    public static double sumArray(double[] data, int end, double extra) {
        return ArrayUtils.sumArray(data, 0, end, extra);
    }

    public static double sumArray(double[] data, int start, int end, double extra) {
        double total = 0.0;
        if (data != null) {
            for (int i = start; i < end; ++i) {
                try {
                    total += data[i] + extra;
                    continue;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "sumArray", new Object[0]);
                }
            }
        }
        return total;
    }
}

