/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.file;

import dev.utils.JCLogUtils;
import dev.utils.common.CloseUtils;
import dev.utils.common.FileUtils;
import dev.utils.common.file.FilePartAssist;
import dev.utils.common.file.FilePartItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public final class FilePartUtils {
    private static final String TAG = FilePartUtils.class.getSimpleName();
    public static final String PART_SUFFIX = "_part_";
    public static final int PART_COUNT = 10;
    public static final long MIN_LENGTH = 0x100000L;

    private FilePartUtils() {
    }

    public static String getPartName(FilePartItem item, String fileName) {
        return item != null ? item.getPartName(fileName) : null;
    }

    public static String getPartName(FilePartAssist assist, int partIndex) {
        return assist != null ? assist.getPartName(partIndex) : null;
    }

    public static String getPartName(String fileName, int partIndex) {
        return String.format("%s%s%s", fileName, PART_SUFFIX, partIndex);
    }

    public static FilePartAssist getFilePartAssist(String filePath) {
        return FilePartUtils.getFilePartAssist(FileUtils.getFile(filePath), 10, 0x100000L);
    }

    public static FilePartAssist getFilePartAssist(String filePath, int partCount, long minLength) {
        return FilePartUtils.getFilePartAssist(FileUtils.getFile(filePath), partCount, minLength);
    }

    public static FilePartAssist getFilePartAssist(File file) {
        return FilePartUtils.getFilePartAssist(file, 10, 0x100000L);
    }

    public static FilePartAssist getFilePartAssist(File file, int partCount, long minLength) {
        boolean filePart = FilePartUtils.isFilePart(file, partCount, minLength);
        return new FilePartAssist(file, filePart ? partCount : 1);
    }

    public static boolean isFilePart(String filePath) {
        return FilePartUtils.isFilePart(FileUtils.getFile(filePath), 10, 0x100000L);
    }

    public static boolean isFilePart(String filePath, int partCount, long minLength) {
        return FilePartUtils.isFilePart(FileUtils.getFile(filePath), partCount, minLength);
    }

    public static boolean isFilePart(File file) {
        return FilePartUtils.isFilePart(file, 10, 0x100000L);
    }

    public static boolean isFilePart(File file, int partCount, long minLength) {
        long fileByteLength = FileUtils.getFileLength(file);
        long partByteLength = fileByteLength / (long)partCount;
        return partByteLength >= minLength;
    }

    public static byte[] fileSplit(String filePath, long start, long end) {
        return FilePartUtils.fileSplit(FileUtils.getFile(filePath), start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileSplit(File file, long start, long end) {
        if (file != null && file.exists() && start >= 0L && end > start) {
            byte[] byArray;
            RandomAccessFile raf;
            block6: {
                raf = null;
                raf = new RandomAccessFile(file, "r");
                if (end <= raf.length()) break block6;
                byte[] byArray2 = null;
                CloseUtils.closeIOQuietly(raf);
                return byArray2;
            }
            try {
                raf.seek(start);
                byte[] bytes = new byte[(int)(end - start)];
                raf.read(bytes);
                byArray = bytes;
            }
            catch (Exception e) {
                try {
                    JCLogUtils.eTag(TAG, e, "fileSplit", new Object[0]);
                }
                catch (Throwable throwable) {
                    CloseUtils.closeIOQuietly(raf);
                    throw throwable;
                }
                CloseUtils.closeIOQuietly(raf);
            }
            CloseUtils.closeIOQuietly(raf);
            return byArray;
        }
        return null;
    }

    public static byte[] fileSplit(String filePath, FilePartItem item) {
        return FilePartUtils.fileSplit(FileUtils.getFile(filePath), item);
    }

    public static byte[] fileSplit(File file, FilePartItem item) {
        if (file == null || item == null) {
            return null;
        }
        return FilePartUtils.fileSplit(file, item.start, item.end);
    }

    public static byte[] fileSplit(String filePath, FilePartAssist assist, int partIndex) {
        return FilePartUtils.fileSplit(FileUtils.getFile(filePath), assist, partIndex);
    }

    public static byte[] fileSplit(File file, FilePartAssist assist, int partIndex) {
        if (file == null || assist == null) {
            return null;
        }
        return FilePartUtils.fileSplit(file, assist.getFilePartItem(partIndex));
    }

    public static boolean fileSplitSave(String filePath, long start, long end, String destFolderPath, String partName) {
        return FilePartUtils.fileSplitSave(FileUtils.getFile(filePath), start, end, destFolderPath, partName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileSplitSave(File file, long start, long end, String destFolderPath, String partName) {
        if (file != null && file.exists() && start >= 0L && end > start) {
            boolean bl;
            FileChannel outputChannel;
            FileOutputStream fos;
            FileChannel inputChannel;
            FileInputStream fis;
            block6: {
                fis = null;
                inputChannel = null;
                fos = null;
                outputChannel = null;
                fis = new FileInputStream(file);
                if (end <= file.length()) break block6;
                boolean bl2 = false;
                CloseUtils.closeIOQuietly(outputChannel, fos, inputChannel, fis);
                return bl2;
            }
            try {
                inputChannel = fis.getChannel();
                fos = new FileOutputStream(new File(destFolderPath, partName));
                outputChannel = fos.getChannel();
                inputChannel.transferTo(start, (int)(end - start), outputChannel);
                bl = true;
            }
            catch (Exception e) {
                try {
                    JCLogUtils.eTag(TAG, e, "fileSplitSave", new Object[0]);
                }
                catch (Throwable throwable) {
                    CloseUtils.closeIOQuietly(outputChannel, fos, inputChannel, fis);
                    throw throwable;
                }
                CloseUtils.closeIOQuietly(outputChannel, fos, inputChannel, fis);
            }
            CloseUtils.closeIOQuietly(outputChannel, fos, inputChannel, fis);
            return bl;
        }
        return false;
    }

    public static boolean fileSplitSave(String filePath, FilePartItem item, String destFolderPath) {
        return FilePartUtils.fileSplitSave(FileUtils.getFile(filePath), item, destFolderPath);
    }

    public static boolean fileSplitSave(File file, FilePartItem item, String destFolderPath) {
        if (file == null || item == null) {
            return false;
        }
        return FilePartUtils.fileSplitSave(file, item.start, item.end, destFolderPath, item.getPartName(FileUtils.getFileName(file)));
    }

    public static boolean fileSplitSave(String filePath, FilePartAssist assist, String destFolderPath, int partIndex) {
        return FilePartUtils.fileSplitSave(FileUtils.getFile(filePath), assist, destFolderPath, partIndex);
    }

    public static boolean fileSplitSave(File file, FilePartAssist assist, String destFolderPath, int partIndex) {
        if (file == null || assist == null) {
            return false;
        }
        return FilePartUtils.fileSplitSave(file, assist.getFilePartItem(partIndex), destFolderPath);
    }

    public static boolean fileSplitSaves(String filePath, String destFolderPath) {
        return FilePartUtils.fileSplitSaves(FileUtils.getFile(filePath), destFolderPath);
    }

    public static boolean fileSplitSaves(File file, String destFolderPath) {
        return FilePartUtils.fileSplitSaves(file, FilePartUtils.getFilePartAssist(file), destFolderPath);
    }

    public static boolean fileSplitSaves(String filePath, FilePartAssist assist, String destFolderPath) {
        return FilePartUtils.fileSplitSaves(FileUtils.getFile(filePath), assist, destFolderPath);
    }

    public static boolean fileSplitSaves(File file, FilePartAssist assist, String destFolderPath) {
        if (file == null || assist == null) {
            return false;
        }
        if (!assist.existsPart()) {
            return false;
        }
        String fileName = FileUtils.getFileName(file);
        if (fileName == null) {
            return false;
        }
        int len = assist.getPartCount();
        for (int i = 0; i < len; ++i) {
            FilePartItem item = assist.getFilePartItem(i);
            if (item != null) {
                boolean result = FilePartUtils.fileSplitSave(file, item.start, item.end, destFolderPath, item.getPartName(fileName));
                if (result) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean fileSplitDelete(String filePath, FilePartItem item, String destFolderPath) {
        return FilePartUtils.fileSplitDelete(FileUtils.getFile(filePath), item, destFolderPath);
    }

    public static boolean fileSplitDelete(File file, FilePartItem item, String destFolderPath) {
        if (file == null || item == null) {
            return false;
        }
        return FileUtils.deleteFile(FileUtils.getFile(destFolderPath, item.getPartName(FileUtils.getFileName(file))));
    }

    public static boolean fileSplitDelete(String filePath, FilePartAssist assist, String destFolderPath, int partIndex) {
        return FilePartUtils.fileSplitDelete(FileUtils.getFile(filePath), assist, destFolderPath, partIndex);
    }

    public static boolean fileSplitDelete(File file, FilePartAssist assist, String destFolderPath, int partIndex) {
        if (file == null || assist == null) {
            return false;
        }
        return FilePartUtils.fileSplitDelete(file, assist.getFilePartItem(partIndex), destFolderPath);
    }

    public static boolean fileSplitDeletes(String filePath, String destFolderPath) {
        return FilePartUtils.fileSplitDeletes(FileUtils.getFile(filePath), destFolderPath);
    }

    public static boolean fileSplitDeletes(File file, String destFolderPath) {
        return FilePartUtils.fileSplitDeletes(file, FilePartUtils.getFilePartAssist(file), destFolderPath);
    }

    public static boolean fileSplitDeletes(String filePath, FilePartAssist assist, String destFolderPath) {
        return FilePartUtils.fileSplitDeletes(FileUtils.getFile(filePath), assist, destFolderPath);
    }

    public static boolean fileSplitDeletes(File file, FilePartAssist assist, String destFolderPath) {
        if (file == null || assist == null) {
            return false;
        }
        if (!assist.existsPart()) {
            return false;
        }
        int len = assist.getPartCount();
        for (int i = 0; i < len; ++i) {
            FilePartUtils.fileSplitDelete(file, assist.getFilePartItem(i), destFolderPath);
        }
        return true;
    }

    public static boolean fileSplitMergePaths(String filePath, List<String> paths) {
        return FilePartUtils.fileSplitMergePaths(FileUtils.getFile(filePath), paths);
    }

    public static boolean fileSplitMergePaths(File file, List<String> paths) {
        if (file == null || paths == null) {
            return false;
        }
        return FilePartUtils.fileSplitMergeFiles(file, FileUtils.convertFiles(paths));
    }

    public static boolean fileSplitMergeFiles(String filePath, List<File> files) {
        return FilePartUtils.fileSplitMergeFiles(FileUtils.getFile(filePath), files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean fileSplitMergeFiles(File file, List<File> files) {
        int i;
        if (file == null || files == null) {
            return false;
        }
        if (files.isEmpty()) {
            return false;
        }
        FileUtils.deleteFile(file);
        RandomAccessFile raf = null;
        RandomAccessFile reader = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            int len = files.size();
            for (i = 0; i < len; ++i) {
                int readLen;
                reader = new RandomAccessFile(files.get(i), "r");
                byte[] buffer = new byte[1024];
                while ((readLen = reader.read(buffer)) != -1) {
                    raf.write(buffer, 0, readLen);
                }
                CloseUtils.closeIOQuietly(reader);
            }
            i = 1;
        }
        catch (Exception e) {
            try {
                JCLogUtils.eTag(TAG, e, "fileSplitMergeFiles", new Object[0]);
                FileUtils.deleteFile(file);
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(reader, raf);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(reader, raf);
            return false;
        }
        CloseUtils.closeIOQuietly(reader, raf);
        return i != 0;
    }

    public static boolean fileSplitMerge(String filePath, FilePartAssist assist, String destFolderPath, String fileName) {
        return FilePartUtils.fileSplitMerge(FileUtils.getFile(filePath), assist, destFolderPath, fileName);
    }

    public static boolean fileSplitMerge(File file, FilePartAssist assist, String destFolderPath, String fileName) {
        if (file == null || assist == null || destFolderPath == null || fileName == null) {
            return false;
        }
        if (!assist.existsPart()) {
            return false;
        }
        ArrayList<File> files = new ArrayList<File>();
        try {
            int len = assist.getPartCount();
            for (int i = 0; i < len; ++i) {
                FilePartItem item = assist.getFilePartItems().get(i);
                File partFile = new File(destFolderPath, item.getPartName(fileName));
                files.add(partFile);
            }
            return FilePartUtils.fileSplitMergeFiles(file, files);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "fileSplitMerge", new Object[0]);
            return false;
        }
    }
}

