/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.CloseUtils;
import dev.utils.common.FileUtils;
import dev.utils.common.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    private static final String TAG = ZipUtils.class.getSimpleName();
    private static final int BUFFER_LEN = 8192;

    private ZipUtils() {
    }

    public static boolean zipFiles(Collection<String> resFiles, String zipFilePath) throws Exception {
        return ZipUtils.zipFiles(resFiles, zipFilePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zipFiles(Collection<String> resFilePaths, String zipFilePath, String comment) throws Exception {
        block8: {
            block6: {
                block7: {
                    if (resFilePaths == null || zipFilePath == null) {
                        return false;
                    }
                    zos = null;
                    try {
                        zos = new ZipOutputStream(new FileOutputStream(zipFilePath));
                        for (String resFile : resFilePaths) {
                            if (ZipUtils.zipFile(FileUtils.getFileByPath(resFile), "", zos, comment)) continue;
                            var6_7 = false;
                            if (zos == null) break block6;
                            break block7;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var7_8) {
                        if (zos != null) {
                            zos.finish();
                            CloseUtils.closeIOQuietly(new Closeable[]{zos});
                        }
                        throw var7_8;
                    }
                }
                zos.finish();
                CloseUtils.closeIOQuietly(new Closeable[]{zos});
            }
            return var6_7;
lbl-1000:
            // 1 sources

            {
                var4_5 = true;
                if (zos == null) break block8;
            }
            zos.finish();
            CloseUtils.closeIOQuietly(new Closeable[]{zos});
        }
        return var4_5;
    }

    public static boolean zipFiles(Collection<File> resFiles, File zipFile) throws Exception {
        return ZipUtils.zipFiles(resFiles, zipFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zipFiles(Collection<File> resFiles, File zipFile, String comment) throws Exception {
        block8: {
            block6: {
                block7: {
                    if (resFiles == null || zipFile == null) {
                        return false;
                    }
                    zos = null;
                    try {
                        zos = new ZipOutputStream(new FileOutputStream(zipFile));
                        for (File resFile : resFiles) {
                            if (ZipUtils.zipFile(resFile, "", zos, comment)) continue;
                            var6_7 = false;
                            if (zos == null) break block6;
                            break block7;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var7_8) {
                        if (zos != null) {
                            zos.finish();
                            CloseUtils.closeIOQuietly(new Closeable[]{zos});
                        }
                        throw var7_8;
                    }
                }
                zos.finish();
                CloseUtils.closeIOQuietly(new Closeable[]{zos});
            }
            return var6_7;
lbl-1000:
            // 1 sources

            {
                var4_5 = true;
                if (zos == null) break block8;
            }
            zos.finish();
            CloseUtils.closeIOQuietly(new Closeable[]{zos});
        }
        return var4_5;
    }

    public static boolean zipFile(String resFilePath, String zipFilePath) throws Exception {
        return ZipUtils.zipFile(FileUtils.getFileByPath(resFilePath), FileUtils.getFileByPath(zipFilePath), null);
    }

    public static boolean zipFile(String resFilePath, String zipFilePath, String comment) throws Exception {
        return ZipUtils.zipFile(FileUtils.getFileByPath(resFilePath), FileUtils.getFileByPath(zipFilePath), comment);
    }

    public static boolean zipFile(File resFile, File zipFile) throws Exception {
        return ZipUtils.zipFile(resFile, zipFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipFile(File resFile, File zipFile, String comment) throws Exception {
        boolean bl;
        if (resFile == null || zipFile == null) {
            return false;
        }
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            bl = ZipUtils.zipFile(resFile, "", zos, comment);
        }
        catch (Throwable throwable) {
            CloseUtils.closeIOQuietly(zos);
            throw throwable;
        }
        CloseUtils.closeIOQuietly(zos);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean zipFile(File resFile, String rootPath, ZipOutputStream zos, String comment) throws Exception {
        String filePath = rootPath + (StringUtils.isEmpty((CharSequence)rootPath) ? "" : File.separator) + resFile.getName();
        if (resFile.isDirectory()) {
            File[] fileList = resFile.listFiles();
            if (fileList == null || fileList.length == 0) {
                ZipEntry entry = new ZipEntry(filePath + '/');
                entry.setComment(comment);
                zos.putNextEntry(entry);
                zos.closeEntry();
                return true;
            }
            File[] entry = fileList;
            int n = entry.length;
            int n2 = 0;
            while (n2 < n) {
                File file = entry[n2];
                if (!ZipUtils.zipFile(file, filePath, zos, comment)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        BufferedInputStream is = null;
        try {
            int len;
            is = new BufferedInputStream(new FileInputStream(resFile));
            ZipEntry entry = new ZipEntry(filePath);
            entry.setComment(comment);
            zos.putNextEntry(entry);
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)is).read(buffer)) != -1) {
                zos.write(buffer, 0, len);
            }
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            CloseUtils.closeIOQuietly(is);
            throw throwable;
        }
        CloseUtils.closeIOQuietly(is);
        return true;
    }

    public static List<File> unzipFile(String zipFilePath, String destDirPath) throws Exception {
        return ZipUtils.unzipFileByKeyword(zipFilePath, destDirPath, null);
    }

    public static List<File> unzipFile(File zipFile, File destDir) throws Exception {
        return ZipUtils.unzipFileByKeyword(zipFile, destDir, null);
    }

    public static List<File> unzipFileByKeyword(String zipFilePath, String destDirPath, String keyword) throws Exception {
        return ZipUtils.unzipFileByKeyword(FileUtils.getFileByPath(zipFilePath), FileUtils.getFileByPath(destDirPath), keyword);
    }

    public static List<File> unzipFileByKeyword(File zipFile, File destDir, String keyword) throws Exception {
        if (zipFile == null || destDir == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        if (StringUtils.isEmpty((CharSequence)keyword)) {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryName.contains("../")) {
                    JCLogUtils.dTag(TAG, "entryName: %s is dangerous!", entryName);
                    continue;
                }
                if (ZipUtils.unzipChildFile(destDir, files, zip, entry, entryName)) continue;
                return files;
            }
        } else {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryName.contains("../")) {
                    JCLogUtils.dTag(TAG, "entryName: %s is dangerous!", entryName);
                    continue;
                }
                if (!entryName.contains(keyword) || ZipUtils.unzipChildFile(destDir, files, zip, entry, entryName)) continue;
                return files;
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unzipChildFile(File destDir, List<File> files, ZipFile zf, ZipEntry entry, String entryName) throws Exception {
        File file = new File(destDir, entryName);
        files.add(file);
        if (entry.isDirectory()) {
            return FileUtils.createOrExistsDir(file);
        }
        if (!FileUtils.createOrExistsFile(file)) {
            return false;
        }
        BufferedInputStream is = null;
        BufferedOutputStream os = null;
        try {
            int len;
            is = new BufferedInputStream(zf.getInputStream(entry));
            os = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)is).read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            CloseUtils.closeIOQuietly(is, os);
            throw throwable;
        }
        CloseUtils.closeIOQuietly(is, os);
        return true;
    }

    public static List<String> getFilesPath(String zipFilePath) throws Exception {
        return ZipUtils.getFilesPath(FileUtils.getFileByPath(zipFilePath));
    }

    public static List<String> getFilesPath(File zipFile) throws Exception {
        if (zipFile == null) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = new ZipFile(zipFile).entries();
        while (entries.hasMoreElements()) {
            String entryName = entries.nextElement().getName();
            if (entryName.contains("../")) {
                JCLogUtils.dTag(TAG, "entryName: %s is dangerous!", entryName);
                paths.add(entryName);
                continue;
            }
            paths.add(entryName);
        }
        return paths;
    }

    public static List<String> getComments(String zipFilePath) throws Exception {
        return ZipUtils.getComments(FileUtils.getFileByPath(zipFilePath));
    }

    public static List<String> getComments(File zipFile) throws Exception {
        if (zipFile == null) {
            return null;
        }
        ArrayList<String> comments = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = new ZipFile(zipFile).entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            comments.add(entry.getComment());
        }
        return comments;
    }
}

