/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.assist.url;

import dev.utils.common.HttpParamsUtils;
import dev.utils.common.StringUtils;
import dev.utils.common.assist.url.UrlExtras;
import java.util.LinkedHashMap;
import java.util.Map;

public class DevJavaUrlParser
implements UrlExtras.Parser {
    private String mUrl;
    private String mUrlPrefix;
    private String mUrlParams;
    private Map<String, String> mUrlParamsMap;
    private Map<String, String> mUrlParamsDecodeMap;
    private boolean mConvertMap = true;

    @Override
    public UrlExtras.Parser reset(String url) {
        return new DevJavaUrlParser().setUrl(url);
    }

    @Override
    public UrlExtras.Parser setUrl(String url) {
        this.initialize(url);
        return this;
    }

    @Override
    public String getUrl() {
        return this.mUrl;
    }

    @Override
    public String getUrlByPrefix() {
        return this.mUrlPrefix;
    }

    @Override
    public String getUrlByParams() {
        return this.mUrlParams;
    }

    @Override
    public Map<String, String> getUrlParams() {
        return this.mUrlParamsMap;
    }

    @Override
    public Map<String, String> getUrlParamsDecode() {
        return this.mUrlParamsDecodeMap;
    }

    @Override
    public boolean isConvertMap() {
        return this.mConvertMap;
    }

    @Override
    public UrlExtras.Parser setConvertMap(boolean convertMap) {
        this.mConvertMap = convertMap;
        return this;
    }

    private void initialize(String url) {
        this.mUrl = StringUtils.clearSpaceTabLine(url);
        this.mUrlPrefix = null;
        this.mUrlParams = null;
        this.mUrlParamsMap = null;
        this.mUrlParamsDecodeMap = null;
        if (StringUtils.isNotEmpty(this.mUrl)) {
            String[] array = HttpParamsUtils.getUrlParamsArray(this.mUrl);
            this.mUrlPrefix = array[0];
            this.mUrlParams = array[1];
            if (this.mConvertMap && StringUtils.isNotEmpty(this.mUrlParams)) {
                this.mUrlParamsMap = HttpParamsUtils.splitParams(this.mUrlParams, false);
                this.mUrlParamsDecodeMap = new LinkedHashMap<String, String>();
                for (Map.Entry<String, String> entry : this.mUrlParamsMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    String decode = StringUtils.urlDecodeWhile(value, 10);
                    this.mUrlParamsDecodeMap.put(key, StringUtils.checkValue(value, decode));
                }
            }
        }
    }
}

