/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.pretty;

import io.github.andreyzebin.gitSql.pretty.TablePrinter;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TableStreamRow {
    private Map<String, Optional<String>> row;
    private Map<String, Integer> totals;
    private TablePrinter table;

    public Map<String, Optional<String>> getRowWithTotals() {
        return TablePrinter.combine(this.getRow(), this.getTotals().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ce -> Optional.ofNullable((Integer)ce.getValue()).map(Object::toString))));
    }

    public static TableStreamRowBuilder builder() {
        return new TableStreamRowBuilder();
    }

    public Map<String, Optional<String>> getRow() {
        return this.row;
    }

    public Map<String, Integer> getTotals() {
        return this.totals;
    }

    public TablePrinter getTable() {
        return this.table;
    }

    public void setRow(Map<String, Optional<String>> row) {
        this.row = row;
    }

    public void setTotals(Map<String, Integer> totals) {
        this.totals = totals;
    }

    public void setTable(TablePrinter table) {
        this.table = table;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableStreamRow)) {
            return false;
        }
        TableStreamRow other = (TableStreamRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Optional<String>> this$row = this.getRow();
        Map<String, Optional<String>> other$row = other.getRow();
        if (this$row == null ? other$row != null : !((Object)this$row).equals(other$row)) {
            return false;
        }
        Map<String, Integer> this$totals = this.getTotals();
        Map<String, Integer> other$totals = other.getTotals();
        if (this$totals == null ? other$totals != null : !((Object)this$totals).equals(other$totals)) {
            return false;
        }
        TablePrinter this$table = this.getTable();
        TablePrinter other$table = other.getTable();
        return !(this$table == null ? other$table != null : !this$table.equals(other$table));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableStreamRow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Optional<String>> $row = this.getRow();
        result = result * 59 + ($row == null ? 43 : ((Object)$row).hashCode());
        Map<String, Integer> $totals = this.getTotals();
        result = result * 59 + ($totals == null ? 43 : ((Object)$totals).hashCode());
        TablePrinter $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        return result;
    }

    public String toString() {
        return "TableStreamRow(row=" + this.getRow() + ", totals=" + this.getTotals() + ", table=" + this.getTable() + ")";
    }

    public TableStreamRow(Map<String, Optional<String>> row, Map<String, Integer> totals, TablePrinter table) {
        this.row = row;
        this.totals = totals;
        this.table = table;
    }

    public TableStreamRow() {
    }

    public static class TableStreamRowBuilder {
        private Map<String, Optional<String>> row;
        private Map<String, Integer> totals;
        private TablePrinter table;

        TableStreamRowBuilder() {
        }

        public TableStreamRowBuilder row(Map<String, Optional<String>> row) {
            this.row = row;
            return this;
        }

        public TableStreamRowBuilder totals(Map<String, Integer> totals) {
            this.totals = totals;
            return this;
        }

        public TableStreamRowBuilder table(TablePrinter table) {
            this.table = table;
            return this;
        }

        public TableStreamRow build() {
            return new TableStreamRow(this.row, this.totals, this.table);
        }

        public String toString() {
            return "TableStreamRow.TableStreamRowBuilder(row=" + this.row + ", totals=" + this.totals + ", table=" + this.table + ")";
        }
    }
}

