/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.git.VersionControl;
import io.github.andreyzebin.gitSql.git2.VersionedFiles;
import io.github.andreyzebin.gitSql.sql.CommitsIndex;
import io.github.andreyzebin.gitSql.sql.GitUtils;
import io.github.andreyzebin.gitSql.sql.JdbcView;
import io.github.andreyzebin.gitSql.sql.PersistedIndex;
import io.github.andreyzebin.gitSql.sql.SqlUtils;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeSeriesQuery
extends PersistedIndex {
    private static final Logger log = LoggerFactory.getLogger(TimeSeriesQuery.class);
    public static final String COLUMN_NAME_POINT = "ts_point";
    public static final String COLUMN_NAME_HASH = "ts_hash";
    public static final String COLUMN_NAME_ORIGIN = "ts_origin";
    private final Collection<VersionedFiles> dataSetVersions;
    private final Map<String, Map<VersionedFiles, JdbcView>> indexes;
    Map<String, String> queries;
    private final Map<String, Function<VersionedFiles, JdbcView>> indexers;
    private final Instant from;
    private final Instant to;
    private final Map<String, List<String>> resultAliases;
    private final Map<String, AtomicBoolean> schemaStatuses;

    public TimeSeriesQuery(String sql, VersionedFiles dataSetVersions, Instant from, Instant to, BiFunction<? super VersionedFiles, Path, ? extends JdbcView> indexer) {
        this(List.of(dataSetVersions), from, to, Map.of("result", git -> (JdbcView)indexer.apply((VersionedFiles)git, Path.of("run", "tsq_dataset", git.getRoot().toString()))), Map.of("result", sql));
    }

    public TimeSeriesQuery(Collection<VersionedFiles> dataSetVersions, Instant from, Instant to, Map<String, Function<VersionedFiles, JdbcView>> indexers, Map<String, String> queries) {
        super(Path.of("run", "tsq_result"));
        this.dataSetVersions = dataSetVersions;
        this.indexes = new HashMap<String, Map<VersionedFiles, JdbcView>>();
        this.indexers = indexers;
        this.queries = queries;
        this.from = from;
        this.to = to;
        this.schemaStatuses = new HashMap<String, AtomicBoolean>();
        this.resultAliases = new HashMap<String, List<String>>();
    }

    private JdbcView getView(VersionedFiles versionControl, String table) {
        return this.indexes.computeIfAbsent(table, f -> new HashMap()).computeIfAbsent(versionControl, f -> this.indexers.get(table).apply(versionControl));
    }

    private boolean getSchemaStatus(String table) {
        return this.schemaStatuses.computeIfAbsent(table, f -> new AtomicBoolean(false)).get();
    }

    private List<String> getAliases(String table) {
        return this.resultAliases.computeIfAbsent(table, t -> new ArrayList());
    }

    private boolean setSchemaStatus(String table, boolean status) {
        return this.schemaStatuses.computeIfAbsent(table, f -> new AtomicBoolean(false)).getAndSet(status);
    }

    @Override
    protected void createSchema() throws SQLException {
    }

    @Override
    protected void reindex() {
        Connection connection = this.getConnection();
        this.dataSetVersions.forEach(cDataSet -> GitUtils.getPoints(cDataSet, this.from, this.to).forEach(cPoint -> this.reindexCommit((VersionedFiles)cDataSet, (VersionControl.Commit)cPoint, connection)));
        try {
            super.createSchema();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void reindexCommit(VersionedFiles dataSet, VersionControl.Commit cCommitPrev, Connection indexConnection) {
        this.indexers.keySet().forEach(cTable -> {
            dataSet.getSource().seek(cCommitPrev.getHash());
            JdbcView dataSetIndex = this.getView(dataSet, (String)cTable).drop();
            SqlUtils.streamRows(rs -> this.prepareRow((String)cTable, dataSet.getSource().origin().orElse(dataSet.getRoot().toString()), cCommitPrev, (ResultSet)rs), SqlUtils.query(dataSetIndex.getConnection(), this.queries.get(cTable), new String[0])).forEach(cRow -> {
                this.createSchema2((String)cTable);
                SqlUtils.merge(indexConnection, cTable, (String[])cRow.toArray(String[]::new));
            });
        });
    }

    private LinkedList<String> prepareRow(String table, String origin, VersionControl.Commit cCommitPrev, ResultSet rs) {
        boolean needFillHeader = this.getAliases(table).isEmpty();
        if (needFillHeader) {
            this.getAliases(table).add(COLUMN_NAME_POINT);
            this.getAliases(table).add(COLUMN_NAME_HASH);
            this.getAliases(table).add(COLUMN_NAME_ORIGIN);
        }
        LinkedList<String> row = new LinkedList<String>();
        row.add(cCommitPrev.getTimestampInstant().toString());
        row.add(cCommitPrev.getHash());
        row.add(origin);
        SqlUtils.streamFields(rs).forEach(cColumn -> {
            if (needFillHeader) {
                this.getAliases(table).add((String)cColumn.getKey());
            }
            row.add((String)cColumn.getValue());
        });
        LinkedList<String> rov = new LinkedList<String>(this.getAliases(table));
        rov.addAll(row);
        return rov;
    }

    private void createSchema2(String tableName) {
        if (this.getSchemaStatus(tableName)) {
            return;
        }
        if (this.storeExists()) {
            try (Statement dml = this.getConnection().createStatement();){
                StringBuilder sql1 = SqlUtils.renderSchema(tableName, this.getAliases(tableName));
                log.debug(CommitsIndex.renderSqlLog(sql1.toString()));
                dml.execute(sql1.toString());
                this.setSchemaStatus(tableName, true);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public TimeSeriesQuery drop() {
        TimeSeriesQuery drop = (TimeSeriesQuery)super.drop();
        this.schemaStatuses.forEach((t, v) -> v.set(false));
        return drop;
    }
}

