/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.frontend;

import io.github.zebin.javabash.frontend.FunnyTerminal;
import io.github.zebin.javabash.frontend.TerminalPalette;
import io.github.zebin.javabash.frontend.TextBrush;
import io.github.zebin.javabash.frontend.TextShrink;
import java.util.function.Function;
import lombok.Generated;

public class FunnyTerminalConfigs {
    public static final FunnyTerminalConfigs DEFAULT = FunnyTerminalConfigs.getDefault();
    private Function<String, String> stderr;
    private Function<String, String> stdout;
    private Function<String, String> stdin;
    private Function<String, String> user;
    private Function<String, String> dir;
    private Function<String, String> id;
    private Function<String, String> cmd;

    public static FunnyTerminalConfigs getDefault() {
        FunnyTerminal.ColorPool defaults = FunnyTerminal.ColorPool.defaults();
        FunnyTerminal.ColorPool defaults2 = FunnyTerminal.ColorPool.defaults();
        return FunnyTerminalConfigs.builder().dir(s -> new TextBrush(TextShrink.getShrinkDir(s, 30)).fill((Object)defaults2.getColor(TextShrink.getShrinkDir(s, 30))).toString()).stderr(s -> FunnyTerminalConfigs.stdErrRender(new TextBrush((String)s)).toString()).stdout(s -> FunnyTerminalConfigs.stdRender(new TextBrush((String)s)).toString()).stdin(s -> s).id(s -> new TextBrush((String)s).fill((Object)defaults.getColor((String)s)).toString()).cmd(cmd1 -> FunnyTerminalConfigs.bashHighlights(new TextBrush((String)cmd1)).toString()).user(s -> new TextBrush((String)s).fill((Object)TerminalPalette.MAGENTA).toString()).build();
    }

    public static TextBrush bashHighlights(TextBrush bashTML) {
        for (String f : new String[]{"mkdir ", "pwd ", "rm ", "ssh-add ", "cd ", "ls ", "git clone ", "git checkout ", "git add ", "git push ", "git commit ", "git ", "if ", " fi", "then ", "else ", "echo ", "touch "}) {
            bashTML.paint(f, (Object)TerminalPalette.YELLOW_BOLD);
        }
        bashTML.fillSurrounding("\"", (Object)TerminalPalette.MAGENTA);
        for (String f : new String[]{"\""}) {
            bashTML.paint(f, (Object)TerminalPalette.RED_BRIGHT);
        }
        for (String f : new String[]{"false", "true"}) {
            bashTML.paint(f, (Object)TerminalPalette.GREEN_BRIGHT);
        }
        return bashTML;
    }

    public static TextBrush stdRender(TextBrush bashTML) {
        return bashTML.fill((Object)TerminalPalette.GREEN);
    }

    public static TextBrush stdErrRender(TextBrush textBrush) {
        return textBrush.fill((Object)TerminalPalette.RED).paint("ERROR", (Object)TerminalPalette.RED_BOLD_BRIGHT).paint("FAIL", (Object)TerminalPalette.RED_BOLD_BRIGHT);
    }

    @Generated
    private static Function<String, String> $default$stderr() {
        return s -> s;
    }

    @Generated
    private static Function<String, String> $default$stdout() {
        return s -> s;
    }

    @Generated
    private static Function<String, String> $default$stdin() {
        return s -> s;
    }

    @Generated
    private static Function<String, String> $default$user() {
        return s -> s;
    }

    @Generated
    private static Function<String, String> $default$dir() {
        return s -> s;
    }

    @Generated
    private static Function<String, String> $default$id() {
        return s -> s;
    }

    @Generated
    private static Function<String, String> $default$cmd() {
        return s -> s;
    }

    @Generated
    FunnyTerminalConfigs(Function<String, String> stderr, Function<String, String> stdout, Function<String, String> stdin, Function<String, String> user, Function<String, String> dir, Function<String, String> id, Function<String, String> cmd) {
        this.stderr = stderr;
        this.stdout = stdout;
        this.stdin = stdin;
        this.user = user;
        this.dir = dir;
        this.id = id;
        this.cmd = cmd;
    }

    @Generated
    public static FunnyTerminalConfigsBuilder builder() {
        return new FunnyTerminalConfigsBuilder();
    }

    @Generated
    public Function<String, String> getStderr() {
        return this.stderr;
    }

    @Generated
    public Function<String, String> getStdout() {
        return this.stdout;
    }

    @Generated
    public Function<String, String> getStdin() {
        return this.stdin;
    }

    @Generated
    public Function<String, String> getUser() {
        return this.user;
    }

    @Generated
    public Function<String, String> getDir() {
        return this.dir;
    }

    @Generated
    public Function<String, String> getId() {
        return this.id;
    }

    @Generated
    public Function<String, String> getCmd() {
        return this.cmd;
    }

    @Generated
    public void setStderr(Function<String, String> stderr) {
        this.stderr = stderr;
    }

    @Generated
    public void setStdout(Function<String, String> stdout) {
        this.stdout = stdout;
    }

    @Generated
    public void setStdin(Function<String, String> stdin) {
        this.stdin = stdin;
    }

    @Generated
    public void setUser(Function<String, String> user) {
        this.user = user;
    }

    @Generated
    public void setDir(Function<String, String> dir) {
        this.dir = dir;
    }

    @Generated
    public void setId(Function<String, String> id) {
        this.id = id;
    }

    @Generated
    public void setCmd(Function<String, String> cmd) {
        this.cmd = cmd;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunnyTerminalConfigs)) {
            return false;
        }
        FunnyTerminalConfigs other = (FunnyTerminalConfigs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Function<String, String> this$stderr = this.getStderr();
        Function<String, String> other$stderr = other.getStderr();
        if (this$stderr == null ? other$stderr != null : !this$stderr.equals(other$stderr)) {
            return false;
        }
        Function<String, String> this$stdout = this.getStdout();
        Function<String, String> other$stdout = other.getStdout();
        if (this$stdout == null ? other$stdout != null : !this$stdout.equals(other$stdout)) {
            return false;
        }
        Function<String, String> this$stdin = this.getStdin();
        Function<String, String> other$stdin = other.getStdin();
        if (this$stdin == null ? other$stdin != null : !this$stdin.equals(other$stdin)) {
            return false;
        }
        Function<String, String> this$user = this.getUser();
        Function<String, String> other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        Function<String, String> this$dir = this.getDir();
        Function<String, String> other$dir = other.getDir();
        if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
            return false;
        }
        Function<String, String> this$id = this.getId();
        Function<String, String> other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Function<String, String> this$cmd = this.getCmd();
        Function<String, String> other$cmd = other.getCmd();
        return !(this$cmd == null ? other$cmd != null : !this$cmd.equals(other$cmd));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FunnyTerminalConfigs;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Function<String, String> $stderr = this.getStderr();
        result = result * 59 + ($stderr == null ? 43 : $stderr.hashCode());
        Function<String, String> $stdout = this.getStdout();
        result = result * 59 + ($stdout == null ? 43 : $stdout.hashCode());
        Function<String, String> $stdin = this.getStdin();
        result = result * 59 + ($stdin == null ? 43 : $stdin.hashCode());
        Function<String, String> $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        Function<String, String> $dir = this.getDir();
        result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
        Function<String, String> $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Function<String, String> $cmd = this.getCmd();
        result = result * 59 + ($cmd == null ? 43 : $cmd.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FunnyTerminalConfigs(stderr=" + String.valueOf(this.getStderr()) + ", stdout=" + String.valueOf(this.getStdout()) + ", stdin=" + String.valueOf(this.getStdin()) + ", user=" + String.valueOf(this.getUser()) + ", dir=" + String.valueOf(this.getDir()) + ", id=" + String.valueOf(this.getId()) + ", cmd=" + String.valueOf(this.getCmd()) + ")";
    }

    @Generated
    public FunnyTerminalConfigs withStderr(Function<String, String> stderr) {
        return this.stderr == stderr ? this : new FunnyTerminalConfigs(stderr, this.stdout, this.stdin, this.user, this.dir, this.id, this.cmd);
    }

    @Generated
    public FunnyTerminalConfigs withStdout(Function<String, String> stdout) {
        return this.stdout == stdout ? this : new FunnyTerminalConfigs(this.stderr, stdout, this.stdin, this.user, this.dir, this.id, this.cmd);
    }

    @Generated
    public FunnyTerminalConfigs withStdin(Function<String, String> stdin) {
        return this.stdin == stdin ? this : new FunnyTerminalConfigs(this.stderr, this.stdout, stdin, this.user, this.dir, this.id, this.cmd);
    }

    @Generated
    public FunnyTerminalConfigs withUser(Function<String, String> user) {
        return this.user == user ? this : new FunnyTerminalConfigs(this.stderr, this.stdout, this.stdin, user, this.dir, this.id, this.cmd);
    }

    @Generated
    public FunnyTerminalConfigs withDir(Function<String, String> dir) {
        return this.dir == dir ? this : new FunnyTerminalConfigs(this.stderr, this.stdout, this.stdin, this.user, dir, this.id, this.cmd);
    }

    @Generated
    public FunnyTerminalConfigs withId(Function<String, String> id) {
        return this.id == id ? this : new FunnyTerminalConfigs(this.stderr, this.stdout, this.stdin, this.user, this.dir, id, this.cmd);
    }

    @Generated
    public FunnyTerminalConfigs withCmd(Function<String, String> cmd) {
        return this.cmd == cmd ? this : new FunnyTerminalConfigs(this.stderr, this.stdout, this.stdin, this.user, this.dir, this.id, cmd);
    }

    @Generated
    public static class FunnyTerminalConfigsBuilder {
        @Generated
        private boolean stderr$set;
        @Generated
        private Function<String, String> stderr$value;
        @Generated
        private boolean stdout$set;
        @Generated
        private Function<String, String> stdout$value;
        @Generated
        private boolean stdin$set;
        @Generated
        private Function<String, String> stdin$value;
        @Generated
        private boolean user$set;
        @Generated
        private Function<String, String> user$value;
        @Generated
        private boolean dir$set;
        @Generated
        private Function<String, String> dir$value;
        @Generated
        private boolean id$set;
        @Generated
        private Function<String, String> id$value;
        @Generated
        private boolean cmd$set;
        @Generated
        private Function<String, String> cmd$value;

        @Generated
        FunnyTerminalConfigsBuilder() {
        }

        @Generated
        public FunnyTerminalConfigsBuilder stderr(Function<String, String> stderr) {
            this.stderr$value = stderr;
            this.stderr$set = true;
            return this;
        }

        @Generated
        public FunnyTerminalConfigsBuilder stdout(Function<String, String> stdout) {
            this.stdout$value = stdout;
            this.stdout$set = true;
            return this;
        }

        @Generated
        public FunnyTerminalConfigsBuilder stdin(Function<String, String> stdin) {
            this.stdin$value = stdin;
            this.stdin$set = true;
            return this;
        }

        @Generated
        public FunnyTerminalConfigsBuilder user(Function<String, String> user) {
            this.user$value = user;
            this.user$set = true;
            return this;
        }

        @Generated
        public FunnyTerminalConfigsBuilder dir(Function<String, String> dir) {
            this.dir$value = dir;
            this.dir$set = true;
            return this;
        }

        @Generated
        public FunnyTerminalConfigsBuilder id(Function<String, String> id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        @Generated
        public FunnyTerminalConfigsBuilder cmd(Function<String, String> cmd) {
            this.cmd$value = cmd;
            this.cmd$set = true;
            return this;
        }

        @Generated
        public FunnyTerminalConfigs build() {
            Function<String, String> stderr$value = this.stderr$value;
            if (!this.stderr$set) {
                stderr$value = FunnyTerminalConfigs.$default$stderr();
            }
            Function<String, String> stdout$value = this.stdout$value;
            if (!this.stdout$set) {
                stdout$value = FunnyTerminalConfigs.$default$stdout();
            }
            Function<String, String> stdin$value = this.stdin$value;
            if (!this.stdin$set) {
                stdin$value = FunnyTerminalConfigs.$default$stdin();
            }
            Function<String, String> user$value = this.user$value;
            if (!this.user$set) {
                user$value = FunnyTerminalConfigs.$default$user();
            }
            Function<String, String> dir$value = this.dir$value;
            if (!this.dir$set) {
                dir$value = FunnyTerminalConfigs.$default$dir();
            }
            Function<String, String> id$value = this.id$value;
            if (!this.id$set) {
                id$value = FunnyTerminalConfigs.$default$id();
            }
            Function<String, String> cmd$value = this.cmd$value;
            if (!this.cmd$set) {
                cmd$value = FunnyTerminalConfigs.$default$cmd();
            }
            return new FunnyTerminalConfigs(stderr$value, stdout$value, stdin$value, user$value, dir$value, id$value, cmd$value);
        }

        @Generated
        public String toString() {
            return "FunnyTerminalConfigs.FunnyTerminalConfigsBuilder(stderr$value=" + String.valueOf(this.stderr$value) + ", stdout$value=" + String.valueOf(this.stdout$value) + ", stdin$value=" + String.valueOf(this.stdin$value) + ", user$value=" + String.valueOf(this.user$value) + ", dir$value=" + String.valueOf(this.dir$value) + ", id$value=" + String.valueOf(this.id$value) + ", cmd$value=" + String.valueOf(this.cmd$value) + ")";
        }
    }
}

