/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.frontend;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.MatchingFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.helpers.BasicMarkerFactory;

public class StdoutLimiterFilter
extends MatchingFilter {
    AtomicInteger counter = new AtomicInteger();
    String lastCmd;
    int limit = 3;
    String groupFilter;
    Marker bottom = new BasicMarkerFactory().getMarker("bottom");
    String groupingMDC;
    String bottomMsg = "...";

    public void setBottomMsg(String bottomMsg) {
        this.bottomMsg = bottomMsg;
    }

    public void setGroupingMDC(String groupingMDC) {
        this.groupingMDC = groupingMDC;
    }

    public void setGroupFilter(String groupFilter) {
        this.groupFilter = groupFilter;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if (this.bottom == marker) {
            return FilterReply.NEUTRAL;
        }
        String cmd = MDC.get((String)this.groupingMDC);
        if (level == Level.DEBUG && cmd != null && cmd.matches(this.groupFilter)) {
            if (cmd.equals(this.lastCmd)) {
                int i = this.counter.incrementAndGet();
                if (i == this.limit + 1) {
                    logger.debug(this.bottom, this.bottomMsg, params);
                }
                if (i > this.limit) {
                    return FilterReply.DENY;
                }
            } else {
                this.counter.set(0);
            }
        }
        this.lastCmd = cmd;
        return FilterReply.NEUTRAL;
    }

    public void start() {
        int errorCount = 0;
        if (this.groupFilter == null) {
            this.addError("'groupFilter' parameter is mandatory. Cannot start.");
            ++errorCount;
        }
        if (this.groupingMDC == null) {
            this.addError("'groupingMDC' parameter is mandatory. Cannot start.");
            ++errorCount;
        }
        if (errorCount == 0) {
            super.start();
        }
    }
}

