/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.sandbox;

import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.FileManager;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BashUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BashUtils.class);
    public static final String WIN_BASH_PATH = "C:\\Program Files\\Git\\bin\\bash.exe";

    public static Thread asyncRead(BufferedReader t, PrintWriter out) {
        Thread thread = new Thread(() -> {
            try {
                String line;
                while ((line = t.readLine()) != null) {
                    out.println(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        thread.start();
        return thread;
    }

    public static String cdAbs(Path jump) {
        return "cd " + BashUtils.escape(BashUtils.toAbsolutePosix(jump));
    }

    public static String cd(Path jump) {
        return "cd " + BashUtils.escape(BashUtils.toPosix(jump));
    }

    public static String escape(String posix) {
        return "\"" + posix.replace("\"", "\\\"") + "\"";
    }

    public static String escape(PosixPath posix) {
        return BashUtils.escape(posix.toString());
    }

    public static String decode(String value) {
        return BashUtils.removeSurrounding(BashUtils.removeSurrounding(value, "'"), "\"");
    }

    private static String removeSurrounding(String value, String prefix) {
        if (value.startsWith(prefix) && value.endsWith(prefix)) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static String toAbsolutePosix(Path p) {
        return BashUtils.toPosix("/" + String.valueOf(p.toAbsolutePath().normalize()), true);
    }

    private static String toPosix(String p, boolean isAbsolute) {
        Object replace = p.replace("\\", "/").replace(":", "");
        if (isAbsolute && !((String)replace).startsWith("/")) {
            replace = "/" + (String)replace;
        }
        return replace;
    }

    public static String toPosix(Path p) {
        return BashUtils.toPosix(p.toString(), p.isAbsolute());
    }

    public static String encode(Path p) {
        return BashUtils.escape(BashUtils.toPosix(p));
    }

    public static void append(StringBuffer buf, String line) {
        if (!buf.isEmpty()) {
            buf.append(System.lineSeparator());
        }
        buf.append(line);
    }

    public static Process runShell(Runtime runtime, String path) {
        Process terminal = null;
        try {
            terminal = runtime.exec(new String[]{path});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return terminal;
    }

    public static Process runShellForOs(Runtime r) {
        String osNameLowercased = System.getProperty("os.name").toLowerCase();
        log.debug("OS name = {}", (Object)osNameLowercased);
        boolean isWindows = osNameLowercased.startsWith("windows");
        if (isWindows) {
            log.debug("Windows OS is found");
            return BashUtils.runShell(r, WIN_BASH_PATH);
        }
        log.debug("Linux OS is found");
        return BashUtils.runShell(r, "bash");
    }

    private static void openSecret(TextTerminal bash, String key, String value) {
        bash.eval(String.format("%s=%s", key, value), String.format("%s=***", key));
    }

    private static void closeSecret(TextTerminal bash, String key) {
        bash.eval(String.format("%s=''", key), String.format("%s=''", key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withSecret(TextTerminal bash, String key, String value, Supplier<T> result) {
        try {
            BashUtils.openSecret(bash, key, value);
            T t = result.get();
            return t;
        }
        finally {
            BashUtils.closeSecret(bash, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T lockDir(TextTerminal bash, Supplier<T> result) {
        String pwd = bash.eval("pwd");
        try {
            T t = result.get();
            return t;
        }
        finally {
            bash.eval("cd " + pwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T lockDir(FileManager fm, Supplier<T> result) {
        PosixPath pwd = fm.getCurrent();
        try {
            T t = result.get();
            return t;
        }
        finally {
            fm.go(pwd);
        }
    }
}

