/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.sandbox;

import io.github.zebin.javabash.sandbox.DirectoryTree;
import io.github.zebin.javabash.sandbox.FileManager;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkingDirectory
implements DirectoryTree {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkingDirectory.class);
    private final FileManager delegate;
    private final Consumer<FileEvent> listener;
    private final PosixPath wd;

    public WorkingDirectory(FileManager delegate, PosixPath wd, Consumer<FileEvent> listener) {
        this.delegate = delegate;
        this.listener = listener;
        this.wd = wd;
    }

    @Override
    public Writer put(final PosixPath path) {
        return this.setupDir(this.delegate, () -> {
            this.validate(path);
            return new StringWriter(){

                @Override
                public void close() throws IOException {
                    WorkingDirectory.this.setupDir(WorkingDirectory.this.delegate, () -> {
                        WorkingDirectory.this.validate(path);
                        if (path.length() > 1) {
                            WorkingDirectory.this.delegate.makeDir(path.descend());
                        }
                        WorkingDirectory.this.fireChange(path);
                        Writer wr = WorkingDirectory.this.delegate.write(path);
                        try {
                            wr.write(this.toString());
                            wr.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return 0;
                    });
                }
            };
        });
    }

    private void fireChange(PosixPath path) {
        log.debug("File changed {}", (Object)path);
        this.listener.accept(FileEvent.builder().type(FileEvent.FileEventType.CHANGED).path(path).build());
    }

    @Override
    public boolean delete(PosixPath path) {
        return this.setupDir(this.delegate, () -> {
            this.validate(path);
            this.fireChange(path);
            return this.delegate.remove(path);
        });
    }

    @Override
    public Writer patch(final PosixPath path) {
        return this.setupDir(this.delegate, () -> {
            this.validate(path);
            return new StringWriter(){

                @Override
                public void close() throws IOException {
                    WorkingDirectory.this.setupDir(WorkingDirectory.this.delegate, () -> {
                        WorkingDirectory.this.validate(path);
                        if (path.length() > 1) {
                            WorkingDirectory.this.delegate.makeDir(path.descend());
                        }
                        WorkingDirectory.this.fireChange(path);
                        Writer wr = WorkingDirectory.this.delegate.append(path);
                        try {
                            wr.append(this.toString());
                            wr.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return 0;
                    });
                }
            };
        });
    }

    @Override
    public Reader get(PosixPath path) {
        return this.setupDir(this.delegate, () -> {
            this.validate(path);
            return new StringReader(this.delegate.read(path));
        });
    }

    @Override
    public boolean exists(PosixPath path) {
        return this.setupDir(this.delegate, () -> {
            this.validate(path);
            return this.delegate.exists(path);
        });
    }

    @Override
    public boolean isDir(PosixPath path) {
        return this.setupDir(this.delegate, () -> {
            this.validate(path);
            return this.delegate.dirExists(path);
        });
    }

    @Override
    public Stream<PosixPath> list(PosixPath path) {
        return this.setupDir(this.delegate, () -> {
            this.validate(path);
            return this.delegate.list(path).stream().filter(p -> !p.equals(PosixPath.CURRENT) && !p.equals(PosixPath.LEVEL_UP));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T setupDir(FileManager fm, Supplier<T> result) {
        PosixPath pwd = fm.getCurrent();
        log.debug("File manager state saved.");
        try {
            if (!pwd.equals(this.wd)) {
                fm.makeDir(this.wd);
                fm.go(this.wd);
            }
            T t = result.get();
            return t;
        }
        finally {
            if (!pwd.equals(this.wd)) {
                fm.go(pwd);
            }
            log.debug("File manager state recovered.");
        }
    }

    public static class FileEvent {
        private final FileEventType type;
        private final PosixPath path;

        @Generated
        FileEvent(FileEventType type, PosixPath path) {
            this.type = type;
            this.path = path;
        }

        @Generated
        public static FileEventBuilder builder() {
            return new FileEventBuilder();
        }

        @Generated
        public FileEventType getType() {
            return this.type;
        }

        @Generated
        public PosixPath getPath() {
            return this.path;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileEvent)) {
                return false;
            }
            FileEvent other = (FileEvent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FileEventType this$type = this.getType();
            FileEventType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            PosixPath this$path = this.getPath();
            PosixPath other$path = other.getPath();
            return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FileEvent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FileEventType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            PosixPath $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WorkingDirectory.FileEvent(type=" + String.valueOf((Object)this.getType()) + ", path=" + String.valueOf(this.getPath()) + ")";
        }

        public static enum FileEventType {
            CHANGED;

        }

        @Generated
        public static class FileEventBuilder {
            @Generated
            private FileEventType type;
            @Generated
            private PosixPath path;

            @Generated
            FileEventBuilder() {
            }

            @Generated
            public FileEventBuilder type(FileEventType type) {
                this.type = type;
                return this;
            }

            @Generated
            public FileEventBuilder path(PosixPath path) {
                this.path = path;
                return this;
            }

            @Generated
            public FileEvent build() {
                return new FileEvent(this.type, this.path);
            }

            @Generated
            public String toString() {
                return "WorkingDirectory.FileEvent.FileEventBuilder(type=" + String.valueOf((Object)this.type) + ", path=" + String.valueOf(this.path) + ")";
            }
        }
    }
}

