/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.git.VersionedFiles;
import io.github.andreyzebin.gitSql.sql.GitUtils;
import io.github.andreyzebin.gitSql.sql.SqlUtils;
import io.github.andreyzebin.gitSql.sql.TableSource;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeIndexMerger
implements TableSource {
    private static final Logger log = LoggerFactory.getLogger(RangeIndexMerger.class);
    private final Supplier<TableSource> delegate;
    private final Instant from;
    private final Instant to;
    private final VersionedFiles dataSet;
    private final TableSource cachedDelegate;

    public RangeIndexMerger(Supplier<TableSource> delegate, Instant from, Instant instant, VersionedFiles dataSet) {
        this.delegate = delegate;
        this.from = from;
        this.to = instant;
        this.dataSet = dataSet;
        this.cachedDelegate = delegate.get();
    }

    @Override
    public SqlUtils.SchemaBuilder createSchema() throws SQLException {
        return this.delegate.get().createSchema().withColumn("ts_point").withColumn("ts_hash").withColumn("ts_origin").withMerge("ts_point");
    }

    @Override
    public Stream<Map<String, String>> rows() {
        return GitUtils.getPoints(this.dataSet, this.from, this.to).flatMap(commit -> {
            this.dataSet.getSource().seek(commit.getHash());
            return this.delegate.get().rows().map(cRow -> {
                cRow = new HashMap<String, String>((Map<String, String>)cRow);
                cRow.put("ts_point", commit.getTimestamp());
                cRow.put("ts_hash", commit.getHash());
                cRow.put("ts_origin", this.dataSet.getSource().getOrigin().orElse(this.dataSet.getRoot().toString()));
                return cRow;
            });
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeIndexMerger that = (RangeIndexMerger)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.cachedDelegate, that.cachedDelegate);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.cachedDelegate, this.getClass().getName());
    }
}

