/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.config;

import io.github.zebin.javabash.sandbox.DirectoryTree;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;

public class ConfigTree {
    private final DirectoryTree dt;

    public ConfigTree(DirectoryTree delegate) {
        this.dt = delegate;
    }

    public Stream<PosixPath> getLeafs() {
        LinkedList propLeafs = new LinkedList();
        this.dt.traverse(PosixPath.ofPosix((String)""), d -> {
            if (d.length() <= 0 || !Set.of(".git", ".gradle", ".idea", "build").contains(d.getEnd())) {
                if (d.length() > 1 && Set.of(".git", ".gradle", ".idea", "build").contains(d.descend().getEnd())) {
                    return false;
                }
                boolean hasPropertyMarker = this.dt.list(d).anyMatch(f -> f.getEnd().equals("conf.properties") && !this.dt.isDir(f));
                if (hasPropertyMarker) {
                    propLeafs.add(d);
                }
            }
            return true;
        });
        return propLeafs.stream();
    }

    public Map<String, String> getProperties(PosixPath leaf) {
        HashMap<String, String> effProps = new HashMap<String, String>();
        this.fillProps(leaf, effProps);
        return effProps;
    }

    public Map<String, String> getEffectiveProperties(PosixPath leaf) {
        HashMap<String, String> effProps = new HashMap<String, String>();
        leaf.streamClimbing().forEach(pp -> this.fillProps((PosixPath)pp, (Map<String, String>)effProps));
        return effProps;
    }

    private void fillProps(PosixPath leaf, Map<String, String> effProps) {
        PosixPath currProp = leaf.climb(new String[]{"conf.properties"});
        if (this.dt.exists(currProp) && !this.dt.isDir(currProp)) {
            Properties prop = new Properties();
            try {
                prop.load(this.dt.get(currProp));
                prop.stringPropertyNames().forEach(pr -> effProps.put((String)pr, prop.getProperty((String)pr)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getEffectiveProperty(PosixPath leaf, String key) {
        return this.getEffectiveProperties(leaf).get(key);
    }

    public Optional<String> setProperty(PosixPath leaf, String key, String value) {
        return (Optional)this.getDirectory().setupDir(() -> {
            Optional<Object> ret;
            block18: {
                PosixPath currProp = leaf.climb(new String[]{"conf.properties"});
                boolean hasFile = this.dt.exists(currProp) && !this.dt.isDir(currProp);
                ret = Optional.empty();
                if (hasFile) {
                    Properties prop = new Properties();
                    try {
                        prop.load(this.dt.get(currProp));
                        if (prop.stringPropertyNames().contains(key)) {
                            ret = Optional.ofNullable(prop.getProperty(key));
                        }
                        prop.setProperty(key, value);
                        try (Writer upd = this.dt.put(currProp);){
                            prop.entrySet().stream().sorted(Comparator.comparing(ccc -> ccc.getKey().toString())).forEach(cc -> {
                                try {
                                    ConfigTree.writProp(cc.getKey().toString(), cc.getValue().toString(), upd);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            });
                            break block18;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                try (Writer patch = this.dt.put(currProp);){
                    ConfigTree.writProp(key, value, patch);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return ret;
        });
    }

    public Optional<String> deleteProperty(PosixPath leaf, String key) {
        PosixPath currProp = leaf.climb(new String[]{"conf.properties"});
        boolean hasFile = this.dt.exists(currProp) && !this.dt.isDir(currProp);
        Optional<String> ret = Optional.empty();
        if (hasFile) {
            Properties prop = new Properties();
            try {
                prop.load(this.dt.get(currProp));
                if (prop.stringPropertyNames().contains(key)) {
                    ret = Optional.ofNullable(prop.getProperty(key));
                }
                try (Writer upd = this.dt.put(currProp);){
                    prop.entrySet().stream().filter(cc -> !cc.getKey().toString().equals(key)).sorted(Comparator.comparing(ccc -> ccc.getKey().toString())).forEach(cc -> {
                        try {
                            ConfigTree.writProp(cc.getKey().toString(), cc.getValue().toString(), upd);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    public DirectoryTree getDirectory() {
        return this.dt;
    }

    private static void writProp(String key, String value, Writer patch) throws IOException {
        patch.write(String.format("%s=%s", key, value));
        patch.write(System.lineSeparator());
    }
}

