/*
 * Decompiled with CFR 0.152.
 */
package dev.koifysh.archipelago;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import dev.koifysh.archipelago.Client;
import dev.koifysh.archipelago.ItemManager;
import dev.koifysh.archipelago.Print.APPrint;
import dev.koifysh.archipelago.Print.APPrintJsonType;
import dev.koifysh.archipelago.Print.APPrintPart;
import dev.koifysh.archipelago.Print.APPrintType;
import dev.koifysh.archipelago.events.BouncedEvent;
import dev.koifysh.archipelago.events.CheckedLocationsEvent;
import dev.koifysh.archipelago.events.ConnectionAttemptEvent;
import dev.koifysh.archipelago.events.ConnectionResultEvent;
import dev.koifysh.archipelago.events.InvalidPacketEvent;
import dev.koifysh.archipelago.events.LocationInfoEvent;
import dev.koifysh.archipelago.events.PrintJSONEvent;
import dev.koifysh.archipelago.events.RetrievedEvent;
import dev.koifysh.archipelago.events.SetReplyEvent;
import dev.koifysh.archipelago.network.APPacket;
import dev.koifysh.archipelago.network.ConnectionResult;
import dev.koifysh.archipelago.network.client.ConnectPacket;
import dev.koifysh.archipelago.network.client.GetDataPackagePacket;
import dev.koifysh.archipelago.network.client.LocationScouts;
import dev.koifysh.archipelago.network.client.SayPacket;
import dev.koifysh.archipelago.network.server.BouncedPacket;
import dev.koifysh.archipelago.network.server.ConnectedPacket;
import dev.koifysh.archipelago.network.server.ConnectionRefusedPacket;
import dev.koifysh.archipelago.network.server.InvalidPacket;
import dev.koifysh.archipelago.network.server.LocationInfoPacket;
import dev.koifysh.archipelago.network.server.ReceivedItemsPacket;
import dev.koifysh.archipelago.network.server.RetrievedPacket;
import dev.koifysh.archipelago.network.server.RoomInfoPacket;
import dev.koifysh.archipelago.network.server.RoomUpdatePacket;
import dev.koifysh.archipelago.network.server.SetReplyPacket;
import dev.koifysh.archipelago.parts.DataPackage;
import dev.koifysh.archipelago.parts.NetworkItem;
import dev.koifysh.archipelago.parts.NetworkPlayer;
import dev.koifysh.archipelago.parts.NetworkSlot;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.apache.hc.core5.net.URIBuilder;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.extensions.IExtension;
import org.java_websocket.extensions.permessage_deflate.PerMessageDeflateExtension;
import org.java_websocket.handshake.ServerHandshake;

class WebSocket
extends WebSocketClient {
    private static final Logger LOGGER = Logger.getLogger(WebSocket.class.getName());
    private final Client client;
    private final Gson gson = new Gson();
    private boolean authenticated = false;
    private int reconnectAttempt = 0;
    private String seedName;
    private static Timer reconnectTimer;
    private boolean downgrade = false;
    private static final Draft perMessageDeflateDraft;

    public WebSocket(URI serverUri, Client client) {
        super(serverUri, perMessageDeflateDraft);
        this.client = client;
        if (reconnectTimer != null) {
            reconnectTimer.cancel();
        }
        reconnectTimer = new Timer();
    }

    public void onOpen(ServerHandshake handshakeData) {
    }

    public void onMessage(String message) {
        try {
            LOGGER.fine("Got Packet: " + message);
            JsonElement element = JsonParser.parseString((String)message);
            JsonArray cmdList = element.getAsJsonArray();
            block16: for (int commandNumber = 0; cmdList.size() > commandNumber; ++commandNumber) {
                JsonElement packet = cmdList.get(commandNumber);
                APPacket cmd = (APPacket)this.gson.fromJson(packet, APPacket.class);
                switch (cmd.getCmd()) {
                    case RoomInfo: {
                        RoomInfoPacket roomInfo = (RoomInfoPacket)this.gson.fromJson(packet, RoomInfoPacket.class);
                        this.client.setRoomInfo(roomInfo);
                        this.client.versions = roomInfo.datapackageChecksums;
                        this.client.games = roomInfo.games;
                        this.client.loadDataPackage();
                        this.checkDataPackage(roomInfo.datapackageChecksums, roomInfo.games);
                        this.seedName = roomInfo.seedName;
                        ConnectPacket connectPacket = new ConnectPacket();
                        connectPacket.version = Client.protocolVersion;
                        connectPacket.name = this.client.getMyName();
                        connectPacket.password = this.client.getPassword() == null ? "" : this.client.getPassword();
                        connectPacket.uuid = Client.getUUID();
                        connectPacket.game = this.client.getGame();
                        connectPacket.tags = this.client.getTags();
                        connectPacket.itemsHandling = this.client.getItemsHandlingFlags();
                        this.sendPacket(connectPacket);
                        this.client.setRoomInfo(roomInfo);
                        continue block16;
                    }
                    case Connected: {
                        ConnectedPacket connectedPacket = (ConnectedPacket)this.gson.fromJson(packet, ConnectedPacket.class);
                        this.client.setTeam(connectedPacket.team);
                        this.client.setSlot(connectedPacket.slot);
                        connectedPacket.slotInfo.put(0, new NetworkSlot("Archipelago", "Archipelago", 1));
                        this.client.setSlotInfo(connectedPacket.slotInfo);
                        this.client.getRoomInfo().networkPlayers.addAll(connectedPacket.players);
                        int teams = 1;
                        OptionalInt teamsOptional = this.client.getRoomInfo().networkPlayers.stream().mapToInt(player -> player.team).max();
                        if (teamsOptional.isPresent()) {
                            teams = teamsOptional.getAsInt() + 1;
                        }
                        for (int i = 0; i < teams; ++i) {
                            this.client.getRoomInfo().networkPlayers.add(new NetworkPlayer(i, 0, "Archipelago"));
                        }
                        this.client.setAlias(this.client.getRoomInfo().getPlayer((int)connectedPacket.team, (int)connectedPacket.slot).alias);
                        JsonElement slotData = packet.getAsJsonObject().get("slot_data");
                        ConnectionAttemptEvent attemptConnectionEvent = new ConnectionAttemptEvent(connectedPacket.team, connectedPacket.slot, this.seedName, slotData);
                        this.client.getEventManager().callEvent(attemptConnectionEvent);
                        if (!attemptConnectionEvent.isCanceled()) {
                            this.authenticated = true;
                            this.client.getLocationManager().addCheckedLocations(connectedPacket.checkedLocations);
                            this.client.getLocationManager().setMissingLocations(connectedPacket.missingLocations);
                            this.client.getLocationManager().sendIfChecked(connectedPacket.missingLocations);
                            ConnectionResultEvent connectionResultEvent = new ConnectionResultEvent(ConnectionResult.Success, connectedPacket.team, connectedPacket.slot, this.seedName, slotData);
                            this.client.getEventManager().callEvent(connectionResultEvent);
                            continue block16;
                        }
                        this.close();
                        continue block16;
                    }
                    case ConnectionRefused: {
                        ConnectionRefusedPacket error = (ConnectionRefusedPacket)this.gson.fromJson(cmdList.get(commandNumber), ConnectionRefusedPacket.class);
                        this.client.getEventManager().callEvent(new ConnectionResultEvent(error.errors[0]));
                        continue block16;
                    }
                    case DataPackage: {
                        JsonElement data = packet.getAsJsonObject().get("data");
                        DataPackage dataPackage = (DataPackage)this.gson.fromJson(data, DataPackage.class);
                        this.client.updateDataPackage(dataPackage);
                        this.client.saveDataPackage();
                        continue block16;
                    }
                    case PrintJSON: {
                        LOGGER.finest("PrintJSON packet");
                        APPrint print = (APPrint)this.gson.fromJson(packet, APPrint.class);
                        if (print.type == null) {
                            print.type = APPrintJsonType.Unknown;
                        }
                        for (int partNumber = 0; print.parts.length > partNumber; ++partNumber) {
                            APPrintPart part = print.parts[partNumber];
                            if (part.type == APPrintType.playerID) {
                                int playerID = Integer.parseInt(part.text);
                                NetworkPlayer player2 = this.client.getRoomInfo().getPlayer(this.client.getTeam(), playerID);
                                part.text = player2.alias;
                                continue;
                            }
                            if (part.type == APPrintType.itemID) {
                                long itemID = Long.parseLong(part.text);
                                part.text = this.client.getDataPackage().getItem(itemID, this.client.getSlotInfo().get((Object)Integer.valueOf((int)part.player)).game);
                                continue;
                            }
                            if (part.type != APPrintType.locationID) continue;
                            long locationID = Long.parseLong(part.text);
                            part.text = this.client.getDataPackage().getLocation(locationID, this.client.getSlotInfo().get((Object)Integer.valueOf((int)part.player)).game);
                        }
                        if (print.item != null) {
                            print.item.itemName = this.client.getDataPackage().getItem(print.item.itemID, this.client.getSlotInfo().get((Object)Integer.valueOf((int)print.item.playerID)).game);
                            print.item.locationName = this.client.getDataPackage().getLocation(print.item.locationID, this.client.getSlotInfo().get((Object)Integer.valueOf((int)print.item.playerID)).game);
                            print.item.playerName = this.client.getRoomInfo().getPlayer((int)this.client.getTeam(), (int)print.item.playerID).alias;
                        }
                        this.client.getEventManager().callEvent(new PrintJSONEvent(print, print.type, print.receiving, print.item));
                        continue block16;
                    }
                    case RoomUpdate: {
                        RoomUpdatePacket updatePacket = (RoomUpdatePacket)this.gson.fromJson(packet, RoomUpdatePacket.class);
                        this.updateRoom(updatePacket);
                        continue block16;
                    }
                    case ReceivedItems: {
                        ReceivedItemsPacket items = (ReceivedItemsPacket)this.gson.fromJson(packet, ReceivedItemsPacket.class);
                        ItemManager itemManager = this.client.getItemManager();
                        itemManager.receiveItems(items.items, items.index);
                        continue block16;
                    }
                    case Bounced: {
                        BouncedPacket bounced = (BouncedPacket)this.gson.fromJson(packet, BouncedPacket.class);
                        if (this.client.getBouncedManager().handle(bounced)) continue block16;
                        this.client.getEventManager().callEvent(new BouncedEvent(bounced.games, bounced.tags, bounced.slots, bounced.data));
                        continue block16;
                    }
                    case LocationInfo: {
                        LocationInfoPacket locations = (LocationInfoPacket)this.gson.fromJson(packet, LocationInfoPacket.class);
                        for (NetworkItem item : locations.locations) {
                            item.itemName = this.client.getDataPackage().getItem(item.itemID, this.client.getSlotInfo().get((Object)Integer.valueOf((int)item.playerID)).game);
                            item.locationName = this.client.getDataPackage().getLocation(item.locationID, this.client.getSlotInfo().get((Object)Integer.valueOf((int)this.client.getSlot())).game);
                            item.playerName = this.client.getRoomInfo().getPlayer((int)this.client.getTeam(), (int)item.playerID).alias;
                        }
                        this.client.getEventManager().callEvent(new LocationInfoEvent(locations.locations));
                        continue block16;
                    }
                    case Retrieved: {
                        RetrievedPacket retrievedPacket = (RetrievedPacket)this.gson.fromJson(packet, RetrievedPacket.class);
                        this.client.getEventManager().callEvent(new RetrievedEvent(retrievedPacket.keys, packet.getAsJsonObject().get("keys").getAsJsonObject(), retrievedPacket.requestID));
                        continue block16;
                    }
                    case SetReply: {
                        SetReplyPacket setReplyPacket = (SetReplyPacket)this.gson.fromJson(packet, SetReplyPacket.class);
                        this.client.getEventManager().callEvent(new SetReplyEvent(setReplyPacket.key, setReplyPacket.value, setReplyPacket.original_Value, packet.getAsJsonObject().get("value"), setReplyPacket.requestID));
                        continue block16;
                    }
                    case InvalidPacket: {
                        InvalidPacket invalidPacket = (InvalidPacket)this.gson.fromJson(packet, InvalidPacket.class);
                        this.client.getEventManager().callEvent(new InvalidPacketEvent(invalidPacket.type, invalidPacket.Original_cmd, invalidPacket.text));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error processing incoming packet: ", e);
        }
    }

    private void updateRoom(RoomUpdatePacket updateRoomPacket) {
        if (!updateRoomPacket.networkPlayers.isEmpty()) {
            this.client.getRoomInfo().networkPlayers = updateRoomPacket.networkPlayers;
        }
        this.client.setHintPoints(updateRoomPacket.hintPoints);
        this.client.setAlias(this.client.getRoomInfo().getPlayer((int)this.client.getTeam(), (int)this.client.getSlot()).alias);
        this.client.getEventManager().callEvent(new CheckedLocationsEvent(updateRoomPacket.checkedLocations));
    }

    private void checkDataPackage(HashMap<String, String> versions, List<String> games) {
        HashSet<String> gamesToUpdate = new HashSet<String>();
        Map<String, String> checksums = this.client.getDataPackage().getChecksums();
        for (Map.Entry<String, String> game : versions.entrySet()) {
            if (!games.contains(game.getKey())) continue;
            if (!checksums.containsKey(game.getKey())) {
                gamesToUpdate.add(game.getKey());
                continue;
            }
            if (checksums.get(game.getKey()).equals(game.getValue())) continue;
            gamesToUpdate.add(game.getKey());
        }
        if (!gamesToUpdate.isEmpty()) {
            this.fetchDataPackageFromAP(gamesToUpdate);
        }
    }

    private void fetchDataPackageFromAP(Set<String> games) {
        this.sendPacket(new GetDataPackagePacket(games));
    }

    public void sendPacket(APPacket packet) {
        this.sendManyPackets(new APPacket[]{packet});
    }

    private void sendManyPackets(APPacket[] packet) {
        if (!this.isOpen()) {
            return;
        }
        String json = this.gson.toJson((Object)packet);
        LOGGER.fine("Sent Packet: " + json);
        this.send(json);
    }

    public void onClose(int code, String wsReason, boolean remote) {
        String reason;
        LOGGER.fine(String.format("Connection closed by %s Code: %s Reason: %s", remote ? "remote peer" : "us", code, wsReason));
        String string = reason = wsReason.isEmpty() ? "Connection refused by the Archipelago server." : wsReason;
        if (code == -1) {
            reconnectTimer.cancel();
            if (this.uri.getScheme().equalsIgnoreCase("wss") && this.downgrade) {
                try {
                    this.client.connect(new URIBuilder(this.uri).setScheme("ws").build());
                }
                catch (URISyntaxException ignored) {
                    this.client.onClose("(AP-275) " + reason, 0);
                }
                return;
            }
            this.client.onClose("(AP-279) " + reason, 0);
            return;
        }
        if (code == 1000) {
            reconnectTimer.cancel();
            this.client.onClose("(AP-284) Disconnected.", 0);
        }
        if (code == 1006) {
            reason = "Lost connection to the Archipelago server.";
            if (this.reconnectAttempt <= 10) {
                int reconnectDelay = (int)(5000.0 * Math.pow(2.0, this.reconnectAttempt));
                ++this.reconnectAttempt;
                TimerTask reconnectTask = new TimerTask(){

                    @Override
                    public void run() {
                        WebSocket.this.client.reconnect();
                    }
                };
                reconnectTimer.cancel();
                reconnectTimer = new Timer();
                reconnectTimer.schedule(reconnectTask, reconnectDelay);
                this.client.onClose("(AP-302)  " + reason, reconnectDelay / 1000);
                return;
            }
        }
        reconnectTimer.cancel();
        this.client.onClose("(AP-308) " + reason, 0);
    }

    public void onError(Exception ex) {
        if (ex instanceof SSLException) {
            LOGGER.info(String.format("SSL Error: %s", ex.getMessage()));
            return;
        }
        this.client.onError(ex);
        LOGGER.log(Level.WARNING, "Error in websocket connection: " + ex.getMessage());
    }

    public void connect(boolean allowDowngrade) {
        super.connect();
        reconnectTimer.cancel();
        this.reconnectAttempt = 0;
        this.downgrade = allowDowngrade;
    }

    public void sendChat(String message) {
        SayPacket say = new SayPacket(message);
        this.sendPacket(say);
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void scoutLocation(ArrayList<Long> locationIDs) {
        LocationScouts packet = new LocationScouts(locationIDs);
        this.sendPacket(packet);
    }

    public void scoutlocations(ArrayList<Long> locationIDs, int createAsHint) {
        LocationScouts packet = new LocationScouts(locationIDs, createAsHint);
        this.sendPacket(packet);
    }

    static {
        perMessageDeflateDraft = new Draft_6455((IExtension)new PerMessageDeflateExtension());
    }
}

