/*
 * Decompiled with CFR 0.152.
 */
package dev.koifysh.archipelago.parts;

import com.google.gson.annotations.SerializedName;
import dev.koifysh.archipelago.parts.Game;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DataPackage
implements Serializable {
    @SerializedName(value="games")
    private final Map<String, Game> games = new HashMap<String, Game>();

    public String getItem(long itemID, String game) {
        if (!this.games.containsKey(game)) {
            return String.format("Unknown Item [%d] for [%s]", itemID, game);
        }
        if (!this.games.get((Object)game).itemNameToId.containsValue(itemID)) {
            return String.format("Unknown Item [%d] for [%s]", itemID, game);
        }
        return this.games.get(game).getItem(itemID);
    }

    public String getLocation(long locationID, String game) {
        if (!this.games.containsKey(game)) {
            return String.format("Unknown Location [%d] for [%s]", locationID, game);
        }
        if (!this.games.get((Object)game).locationNameToId.containsValue(locationID)) {
            return String.format("Unknown Location [%d] for [%s]", locationID, game);
        }
        return this.games.get(game).getLocation(locationID);
    }

    public Map<String, String> getChecksums() {
        HashMap<String, String> checksums = new HashMap<String, String>();
        this.games.forEach((key, value) -> checksums.put((String)key, value.checksum));
        return checksums;
    }

    public Map<String, Game> getGames() {
        return this.games;
    }

    public Game getGame(String game) {
        return this.games.get(game);
    }

    public void update(DataPackage newData) {
        this.games.putAll(newData.getGames());
    }

    public void update(String name, Game game) {
        this.games.put(name, game);
    }
}

