/*
 * Decompiled with CFR 0.152.
 */
package dev.koifysh.archipelago.bounce;

import dev.koifysh.archipelago.bounce.BouncedPacketHandler;
import dev.koifysh.archipelago.network.server.BouncedPacket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BouncedManager {
    private static final Logger LOGGER = Logger.getLogger(BouncedManager.class.getCanonicalName());
    private final List<BouncedPacketHandler> handlers = new CopyOnWriteArrayList<BouncedPacketHandler>();

    public void addHandler(BouncedPacketHandler handler) {
        this.handlers.add(handler);
    }

    public void removeHandler(BouncedPacketHandler handler) {
        this.handlers.remove(handler);
    }

    public boolean handle(BouncedPacket packet) {
        for (BouncedPacketHandler handler : this.handlers) {
            try {
                if (!handler.canHandle(packet)) continue;
                handler.handle(packet);
                return true;
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.WARNING, "Error while handling bounce packet", ex);
                return true;
            }
        }
        return false;
    }
}

