/*
 * Decompiled with CFR 0.152.
 */
package dev.koifysh.archipelago.bounce;

import dev.koifysh.archipelago.Client;
import dev.koifysh.archipelago.bounce.BouncedPacketHandler;
import dev.koifysh.archipelago.events.DeathLinkEvent;
import dev.koifysh.archipelago.network.client.BouncePacket;
import dev.koifysh.archipelago.network.server.BouncedPacket;
import dev.koifysh.archipelago.utils.AtomicDouble;
import java.util.HashMap;

public class DeathLinkHandler
implements BouncedPacketHandler {
    public static final String DEATHLINK_TAG = "DeathLink";
    private final Client client;
    private final AtomicDouble lastDeath = new AtomicDouble(0.0);

    public DeathLinkHandler(Client client) {
        this.client = client;
    }

    @Override
    public boolean canHandle(BouncedPacket packet) {
        return packet.tags.contains(DEATHLINK_TAG);
    }

    @Override
    public void handle(BouncedPacket packet) {
        HashMap<String, Object> data = packet.data;
        DeathLinkEvent event = new DeathLinkEvent((String)data.get("source"), (String)data.get("cause"), (Double)data.getOrDefault("time", 0.0));
        double recentDeath = this.lastDeath.getAndUpdate(d -> Math.max(d, event.time));
        if (Math.abs(recentDeath - event.time) <= 1.0E-6) {
            return;
        }
        this.client.getEventManager().callEvent(event);
    }

    public void sendDeathLink(String source, String cause) {
        this.lastDeath.set((double)System.currentTimeMillis() / 1000.0);
        BouncePacket deathLinkPacket = new BouncePacket();
        deathLinkPacket.tags = new String[]{DEATHLINK_TAG};
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cause", cause);
        data.put("time", this.lastDeath);
        data.put("source", source);
        deathLinkPacket.setData(data);
        this.client.sendBounce(deathLinkPacket);
    }
}

