/*
 * Decompiled with CFR 0.152.
 */
package dev.koifysh.archipelago.network.client;

import com.google.gson.annotations.SerializedName;
import dev.koifysh.archipelago.network.APPacket;
import dev.koifysh.archipelago.network.APPacketType;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class SetPacket
extends APPacket {
    private static final AtomicInteger requestIdGen = new AtomicInteger(1);
    @SerializedName(value="key")
    public String key;
    @SerializedName(value="default")
    public Object defaultValue;
    @SerializedName(value="want_reply")
    public boolean want_reply = false;
    @SerializedName(value="operations")
    public ArrayList<DataStorageOperation> operations = new ArrayList();
    @SerializedName(value="request_id")
    private final int requestID;

    public SetPacket(String key, Object defaultValue) {
        super(APPacketType.Set);
        this.key = key;
        this.defaultValue = defaultValue;
        this.requestID = requestIdGen.getAndIncrement();
    }

    public void addDataStorageOperation(Operation operation, Object value) {
        this.operations.add(new DataStorageOperation(operation, value));
    }

    public int getRequestID() {
        return this.requestID;
    }

    private static class DataStorageOperation {
        @SerializedName(value="operation")
        Operation operation;
        @SerializedName(value="value")
        Object value;

        DataStorageOperation(Operation operation, Object value) {
            this.operation = operation;
            this.value = value;
        }
    }

    public static enum Operation {
        REPLACE,
        DEFAULT,
        ADD,
        MULTIPLY,
        POWER,
        MODULO,
        MAX,
        MIN,
        AND,
        OR,
        XOR,
        LEFT_SHIFT,
        RIGHT_SHIFT,
        REMOVE,
        POP,
        UPDATE;

    }
}

