/*
 * Decompiled with CFR 0.152.
 */
package io.github.archipelagomw.events;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonReader;
import io.github.archipelagomw.events.Event;
import java.lang.reflect.Type;
import java.util.HashMap;

public class RetrievedEvent
implements Event {
    public HashMap<String, Object> data;
    private final int requestID;
    private final JsonObject jsonValue;

    public RetrievedEvent(HashMap<String, Object> keys, JsonObject jsonValue, int requestID) {
        this.data = keys;
        this.jsonValue = jsonValue;
        this.requestID = requestID;
    }

    public int getInt(String key) {
        return (Integer)this.data.get(key);
    }

    public float getFloat(String key) {
        return ((Float)this.data.get(key)).floatValue();
    }

    public double getDouble(String key) {
        return (Double)this.data.get(key);
    }

    public String getString(String key) {
        return (String)this.data.get(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.data.get(key);
    }

    public Object getObject(String key) {
        return this.data.get(key);
    }

    public boolean containsKey(String key) {
        return this.data.containsKey(key);
    }

    public <T> T getValueAsObject(String key, Class<T> classOfT) {
        Object value = new Gson().fromJson(this.jsonValue.get(key), classOfT);
        return Primitives.wrap(classOfT).cast(value);
    }

    public <T> T getValueAsObject(String key, Type typeOfT) {
        return (T)(this.jsonValue == null ? null : new Gson().fromJson((JsonReader)new JsonTreeReader(this.jsonValue.get(key)), typeOfT));
    }

    public int getRequestID() {
        return this.requestID;
    }
}

