/*
 * Decompiled with CFR 0.152.
 */
package io.github.archipelagomw.utils;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleUnaryOperator;

public class AtomicDouble {
    private final AtomicLong bits = new AtomicLong();

    public AtomicDouble(double initialValue) {
        this.bits.set(Double.doubleToLongBits(initialValue));
    }

    public double get() {
        return Double.longBitsToDouble(this.bits.get());
    }

    public void set(double value) {
        this.bits.set(Double.doubleToLongBits(value));
    }

    public double getAndUpdate(DoubleUnaryOperator func) {
        return Double.longBitsToDouble(this.bits.getAndUpdate((long l) -> Double.doubleToLongBits(func.applyAsDouble(Double.longBitsToDouble(l)))));
    }
}

