/*
 * Decompiled with CFR 0.152.
 */
package io.github.argcc.string_function;

import io.github.argcc.string_function.FuncName;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class StringFunctionHandler {
    private String prefix = "";
    private String argStart = "(";
    private String argEnd = ")";
    private Map<String, Map<String, AbstractMap.SimpleEntry<Method, Object>>> functionCache = new HashMap<String, Map<String, AbstractMap.SimpleEntry<Method, Object>>>();
    private List<Object> functions;

    public List<Object> getFunctions() {
        return this.functions;
    }

    public StringFunctionHandler setFunctions(List<Object> functions) {
        this.functions = functions != null ? functions.stream().filter(Objects::nonNull).collect(Collectors.toList()) : null;
        this.functionCache.clear();
        return this;
    }

    public StringFunctionHandler setFunctions(Object ... functions) {
        this.functions = functions != null ? Arrays.stream(functions).filter(Objects::nonNull).collect(Collectors.toList()) : null;
        this.functionCache.clear();
        return this;
    }

    public StringFunctionHandler setFunctions(Object functions) {
        if (functions != null) {
            this.functions = new ArrayList<Object>();
            this.functions.add(functions);
        } else {
            this.functions = null;
        }
        this.functionCache.clear();
        return this;
    }

    public StringFunctionHandler setTemplate(String template) {
        if (template == null || template.isEmpty()) {
            throw new RuntimeException("template should not be empty");
        }
        int name = template.indexOf("name");
        if (name < 0) {
            throw new RuntimeException("template should contain word 'name'");
        }
        int args = template.indexOf("args");
        if (args < 0) {
            throw new RuntimeException("template should contain word 'args'");
        }
        if (name > args) {
            throw new RuntimeException("word 'args' should be placed after word 'name'");
        }
        this.prefix = template.substring(0, name).trim();
        this.argStart = template.substring(name + 4, args).trim();
        if (this.argStart.isEmpty()) {
            throw new RuntimeException("arguments start symbols should not be empty");
        }
        if (this.argStart.startsWith(",")) {
            throw new RuntimeException("arguments start symbol should not be comma");
        }
        if (StringFunctionHandler.containsQuote(this.argStart)) {
            throw new RuntimeException("arguments start symbol should not be quote");
        }
        if (this.argStart.charAt(0) >= '0' && this.argStart.charAt(0) <= '\t') {
            throw new RuntimeException("arguments start symbol should not be digit");
        }
        this.argEnd = template.substring(args + 4).trim();
        if (this.argEnd.isEmpty()) {
            throw new RuntimeException("arguments end symbols should not be empty");
        }
        if (this.argEnd.startsWith(",")) {
            throw new RuntimeException("arguments end symbol should not be comma");
        }
        if (StringFunctionHandler.containsQuote(this.argEnd)) {
            throw new RuntimeException("arguments end symbol should not be quote");
        }
        if (this.argEnd.charAt(0) >= '0' && this.argEnd.charAt(0) <= '\t') {
            throw new RuntimeException("arguments end symbol should not be digit");
        }
        this.functionCache.clear();
        return this;
    }

    public String handle(String text) {
        if (text == null || text.isEmpty() || this.functions == null || this.functions.isEmpty()) {
            return text;
        }
        if (this.functionCache.isEmpty()) {
            this.obtainCache();
        }
        StringBuilder str = new StringBuilder(text.length() * 2).append(text);
        for (String funcName : this.functionCache.keySet()) {
            int start = str.indexOf(funcName);
            while (start >= 0) {
                start = this.handleFunc(str, start, funcName, this.functionCache.get(funcName));
                start = str.indexOf(funcName, start);
            }
        }
        return str.toString();
    }

    private void obtainCache() {
        this.functionCache.clear();
        if (this.functions != null) {
            StringBuilder strBuilder = new StringBuilder(68);
            for (Object obj : this.functions) {
                for (Class<?> cls = obj.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                    block2: for (Method method : cls.getDeclaredMethods()) {
                        if (method.getReturnType().equals(Void.TYPE) || !Modifier.isPublic(method.getModifiers())) continue;
                        strBuilder.delete(0, strBuilder.length());
                        for (Class<?> paramType : method.getParameterTypes()) {
                            if (!String.class.isAssignableFrom(paramType) && !Integer.class.isAssignableFrom(paramType) && !Long.class.isAssignableFrom(paramType) && !Double.class.isAssignableFrom(paramType) && !Float.class.isAssignableFrom(paramType)) continue block2;
                            strBuilder.append(paramType.getSimpleName().charAt(0));
                        }
                        String name = method.isAnnotationPresent(FuncName.class) ? method.getAnnotation(FuncName.class).value() : method.getName();
                        this.functionCache.computeIfAbsent(this.prefix + name + this.argStart, k1 -> new HashMap()).computeIfAbsent(strBuilder.toString(), k2 -> new AbstractMap.SimpleEntry<Method, Object>(method, obj));
                    }
                }
            }
        }
    }

    private int handleFunc(StringBuilder str, int start, String funcName, Map<String, AbstractMap.SimpleEntry<Method, Object>> variants) {
        int arg = start + funcName.length();
        ArgsParser parser = new ArgsParser(arg, str);
        parser.skipSpace();
        if (parser.isEnd()) {
            return start + 1;
        }
        if (variants.size() == 1 && variants.containsKey("S") && !parser.isQuote()) {
            int end = str.indexOf(this.argEnd, arg);
            if (end < 0) {
                return start + 1;
            }
            String literal = str.substring(arg, end);
            AbstractMap.SimpleEntry<Method, Object> v2 = variants.get("S");
            String result = this.call(v2.getKey(), v2.getValue(), literal);
            str.replace(start, end + this.argEnd.length(), result);
            return start + result.length();
        }
        List<Object> parameters = parser.parseParameters();
        if (parameters == null) {
            return start + 1;
        }
        ArrayList<String> filteredVariants = new ArrayList<String>(variants.keySet());
        filteredVariants.removeIf(v -> v.length() != parameters.size());
        for (int i = 0; i < parameters.size(); ++i) {
            Integer idx = i;
            if (parameters.get(i) instanceof String) {
                filteredVariants.removeIf(v -> v.charAt(idx) != 'S');
                continue;
            }
            filteredVariants.removeIf(v -> v.charAt(idx) == 'S');
        }
        if (filteredVariants.isEmpty()) {
            return start + 1;
        }
        if (filteredVariants.size() > 1) {
            filteredVariants.sort(new ArgWeightComparator(parameters));
        }
        String variant = (String)filteredVariants.get(0);
        StringFunctionHandler.adjustParameters(parameters, variant);
        AbstractMap.SimpleEntry<Method, Object> v3 = variants.get(variant);
        String result = this.call(v3.getKey(), v3.getValue(), parameters.toArray());
        str.replace(start, parser.getIndex(), result);
        return start + result.length();
    }

    private static void adjustParameters(List<Object> parameters, String args) {
        block6: for (int i = 0; i < parameters.size(); ++i) {
            Object obj = parameters.get(i);
            char ch = args.charAt(i);
            if (obj.getClass().getSimpleName().charAt(0) == ch || !(obj instanceof Number)) continue;
            Number num = (Number)obj;
            switch (ch) {
                case 'D': {
                    parameters.set(i, num.doubleValue());
                    continue block6;
                }
                case 'F': {
                    parameters.set(i, Float.valueOf(num.floatValue()));
                    continue block6;
                }
                case 'I': {
                    parameters.set(i, num.intValue());
                    continue block6;
                }
                case 'L': {
                    parameters.set(i, num.longValue());
                    continue block6;
                }
            }
        }
    }

    private String call(Method method, Object obj, Object ... args) {
        try {
            Object result = method.invoke(obj, args);
            if (result == null) {
                return "null";
            }
            if (result instanceof String) {
                return (String)result;
            }
            return result.toString();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isQuote(char ch) {
        return ch == '\"' || ch == '\'' || ch == '`';
    }

    private static boolean containsQuote(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!StringFunctionHandler.isQuote(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private class ArgsParser {
        int index;
        StringBuilder str;

        public ArgsParser(int index, StringBuilder str) {
            this.index = index;
            this.str = str;
        }

        public int getIndex() {
            return this.index;
        }

        public char get() {
            return this.str.charAt(this.index);
        }

        public void step() {
            ++this.index;
        }

        public boolean isEnd() {
            return this.index >= this.str.length();
        }

        public boolean isNoMoreArguments() {
            return this.str.indexOf(StringFunctionHandler.this.argEnd, this.index) == this.index;
        }

        public void skipSpace() {
            if (!this.isEnd()) {
                char ch = this.get();
                while (ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t' || ch == '\u00a0') {
                    this.step();
                    if (this.isEnd()) {
                        return;
                    }
                    ch = this.get();
                }
            }
        }

        public boolean isQuote() {
            return StringFunctionHandler.isQuote(this.get());
        }

        public String parseString() {
            this.skipSpace();
            if (this.isEnd()) {
                return null;
            }
            if (!this.isQuote()) {
                return null;
            }
            char quote = this.get();
            this.step();
            StringBuilder ret = new StringBuilder();
            while (!this.isEnd()) {
                char ch = this.get();
                if (ch == quote) {
                    this.step();
                    if (this.isEnd() || this.get() != quote) {
                        return ret.toString();
                    }
                }
                ret.append(ch);
                this.step();
            }
            return null;
        }

        public List<Object> parseParameters() {
            ArrayList<Object> ret = new ArrayList<Object>();
            this.skipSpace();
            if (this.isEnd()) {
                return null;
            }
            if (this.isNoMoreArguments()) {
                this.index += StringFunctionHandler.this.argEnd.length();
                return ret;
            }
            Object obj;
            while ((obj = this.parseParameter()) != null) {
                ret.add(obj);
                this.skipSpace();
                if (this.isEnd()) {
                    return null;
                }
                if (this.isNoMoreArguments()) {
                    this.index += StringFunctionHandler.this.argEnd.length();
                    return ret;
                }
                if (this.get() != ',') {
                    return null;
                }
                this.step();
            }
            return null;
        }

        private Object parseParameter() {
            this.skipSpace();
            if (this.isEnd()) {
                return null;
            }
            if (this.isQuote()) {
                return this.parseString();
            }
            int endComma = this.str.indexOf(",", this.index);
            int endArg = this.str.indexOf(StringFunctionHandler.this.argEnd, this.index);
            if (endComma == -1 && endArg == -1) {
                return null;
            }
            int end = endComma < 0 ? endArg : (endArg < 0 ? endComma : Math.min(endComma, endArg));
            String lit = this.str.substring(this.index, end).trim().toLowerCase();
            this.index = end;
            try {
                if (lit.contains("f")) {
                    return Float.valueOf(Float.parseFloat(lit));
                }
                if (lit.contains("d") || lit.contains("e") || lit.contains(".")) {
                    return Double.parseDouble(lit);
                }
                if (lit.contains("l")) {
                    return Long.parseLong(lit);
                }
                return Integer.parseInt(lit);
            }
            catch (NumberFormatException ignore) {
                return null;
            }
        }
    }

    private static class ArgWeightComparator
    implements Comparator<String> {
        private List<Object> parameters;

        public ArgWeightComparator(List<Object> parameters) {
            this.parameters = parameters;
        }

        public int getParamWeight(Object obj, char ch) {
            if (obj.getClass().getSimpleName().charAt(0) == ch) {
                return 3;
            }
            if (obj instanceof Float || obj instanceof Double) {
                switch (ch) {
                    case 'D': 
                    case 'F': {
                        return 2;
                    }
                    case 'I': 
                    case 'L': {
                        return 1;
                    }
                }
            }
            if (obj instanceof Long || obj instanceof Integer) {
                switch (ch) {
                    case 'I': 
                    case 'L': {
                        return 2;
                    }
                    case 'D': 
                    case 'F': {
                        return 1;
                    }
                }
            }
            return 0;
        }

        public int getWeight(String s) {
            int w = 0;
            for (int i = 0; i < this.parameters.size(); ++i) {
                w += this.getParamWeight(this.parameters.get(i), s.charAt(i));
            }
            return w;
        }

        @Override
        public int compare(String o1, String o2) {
            return this.getWeight(o2) - this.getWeight(o1);
        }
    }
}

