package com.plugins.junk;

import com.android.build.gradle.BaseExtension;
import com.plugins.junk.utils.LogUtil;

import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class CodePlugin implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        LogUtil.log("apply");
        CodeExtension.create(project);
        project.afterEvaluate(new Action<Project>() {
            @Override
            public void execute(Project project) {
                LogUtil.log("Gradle配置阶段结束");
                //这里要不要等待Gradle配置结束才执行流程？
            }
        });
        initConfig(project);
    }

    private void initConfig(Project project) {
        Object obj = project.getExtensions().findByName(CodeExtension.NAME);
        LogUtil.log("initConfig");
        if (null != obj) {
            CodeExtension extension = (CodeExtension) obj;
            LogUtil.log("registerTransform");
            //AppExtension对应build.gradle中android{...}
            try {
                BaseExtension android = project.getExtensions().getByType(BaseExtension.class);
                //注册一个Transform
                CodeTransform codeTransform = new CodeTransform(project, extension);
                android.registerTransform(codeTransform);
            } catch (Exception e) {
                LogUtil.error("registerTransform fail: ");
                e.printStackTrace();
            }
        }
    }
}
