package com.plugins.junk.junk.insert;

import com.plugins.junk.CodeInjectUtil;
import com.plugins.junk.RandomGenerator;
import com.plugins.junk.utils.LogUtil;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;

public class DateInsertCode implements InsertCode {
    @Override
    public boolean insert(ClassPool classPool, CtClass ctClass, CtMethod ctMethod) {
        try {
            String i1 = RandomGenerator.generateString();
            String calendar = RandomGenerator.generateString()+1;
            ctMethod.addLocalVariable(i1, CtClass.longType);
            ctMethod.addLocalVariable(calendar, classPool.get(java.util.Calendar.class.getName()));

            ctMethod.insertBefore(calendar+" = java.util.Calendar.getInstance();" +
                    calendar+".setTime(new java.util.Date());" +
                    calendar+".set(java.util.Calendar.DAY_OF_MONTH, " + CodeInjectUtil.getRandom().nextInt(12) + ");" +
                    i1+" = "+calendar+".getFirstDayOfWeek();"
            );

            ctMethod.insertAt(CodeInjectUtil.getRandomMethodLine(ctMethod), "if ("+i1+" > 8) {" +
                    "java.util.Calendar ix5khf = java.util.Calendar.getInstance();\n" +
                    "    ix5khf.setTime(new java.util.Date());\n" +
                    "    ix5khf.set(java.util.Calendar.HOUR_OF_DAY, " + CodeInjectUtil.getRandom().nextInt(12) + ");\n" +
                    "    ix5khf.set(java.util.Calendar.MINUTE, " + CodeInjectUtil.getRandom().nextInt(12) + ");\n" +
                    "    ix5khf.set(java.util.Calendar.SECOND, " + CodeInjectUtil.getRandom().nextInt(12) + ");\n" +
                    i1+" = ix5khf.getFirstDayOfWeek();" +
                    "}");

            ctMethod.insertAfter("if ("+i1+" > System.currentTimeMillis()) {" +
                    "long time = "+i1+" -System.currentTimeMillis();" +
                    "Math.sqrt(time / 100.0);" +
                    "}");

            return true;
        } catch (Exception e) {
            LogUtil.error("[failed]: %s - %s", ctMethod.getLongName(), e.getMessage());
        }
        return false;
    }
}
