package com.plugins.junk.junk.insert;

import com.plugins.junk.CodeInjectUtil;
import com.plugins.junk.RandomGenerator;
import com.plugins.junk.utils.LogUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;

public class SwitchInsertCode implements InsertCode {
    @Override
    public boolean insert(ClassPool classPool, CtClass ctClass, CtMethod ctMethod) {
        try {
            String name1 = RandomGenerator.generateString() + 1;
            String name2 = RandomGenerator.generateString() + 2;
            String name3 = RandomGenerator.generateString() + 3;
            ctMethod.addLocalVariable(name1, CtClass.intType);
            ctMethod.addLocalVariable(name2, CtClass.intType);
            ctMethod.addLocalVariable(name3, CtClass.intType);
            ctMethod.insertBefore(name1 + " = 0;\n" +
                    "                         "+name2+" = " + Math.abs(CodeInjectUtil.getRandom().nextInt()) + ";\n" +
                    "                         "+name3+" = " + Math.abs(CodeInjectUtil.getRandom().nextInt()) + ";\n" +
                    "                        if (System.currentTimeMillis() > "+name2+") {\n" +
                    "                            "+name1+" = 0;\n" +
                    "                        } else if ("+name3+" < "+name2+") {\n" +
                    "                            "+name1+" = 1;\n" +
                    "                        } else {\n" +
                    "                            "+name1+" = 2;\n" +
                    "                        }");
            int line = CodeInjectUtil.getRandomMethodLine(ctMethod);
            ctMethod.insertAt(line, "    int time = (int) (System.currentTimeMillis() / 10000);\n" +
                    "                        if ("+name1+" == 0) {\n" +
                    "                                "+name1+" = time;\n" +
                    "                          } else if ("+name1+" == 1) {\n" +
                    "                                "+name1+" = time - " + Math.abs(CodeInjectUtil.getRandom().nextInt()) + ";\n" +
                    "                          } else if ("+name1+" == 2) {\n" +
                    "                                "+name1+" = time - " + Math.abs(CodeInjectUtil.getRandom().nextInt(10000)) + ";\n" +
                    "                        }"
            );
            ctMethod.insertAfter("Math.max("+name1+", "+name2+");");
            return true;
        } catch (CannotCompileException e) {
            LogUtil.error("[failed]: %s - %s", ctMethod.getLongName(), e.getMessage());
        }
        return false;
    }
}
