/*
 * Decompiled with CFR 0.152.
 */
package com.plugins.junk;

import com.android.build.gradle.BaseExtension;
import com.plugins.junk.junk.facatory.BigDecimalJunkCodeFactory;
import com.plugins.junk.junk.facatory.CalculateJunkCodeFactory;
import com.plugins.junk.junk.facatory.DateJunkCodeFactory;
import com.plugins.junk.junk.facatory.EncoderJunkCodeFactory;
import com.plugins.junk.junk.facatory.JunkCodeFactory;
import com.plugins.junk.junk.facatory.MathJunkCodeFactory;
import com.plugins.junk.junk.facatory.StringBuilderJunkCodeFactory;
import com.plugins.junk.junk.facatory.StringJunkCodeFactory;
import com.plugins.junk.junk.facatory.SwitchJunkCodeFactory;
import com.plugins.junk.junk.facatory.TimeJunkCodeFactory;
import com.plugins.junk.junk.facatory.UUIDJunkCodeFactory;
import com.plugins.junk.junk.insert.InsertCode;
import com.plugins.junk.utils.LogUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Random;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LineNumberAttribute;
import javassist.bytecode.MethodInfo;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;

public class CodeInjectUtil {
    private static final ClassPool sClassPool = ClassPool.getDefault();
    private static int mMethodSuccessCount = 0;
    private static int mMethodCurIndex = 0;
    private static int mModifyRate = 0;
    private static final Random mRandom = new Random();

    public static void injectCode(File baseClassPath, Project project) throws NotFoundException, CannotCompileException {
        try {
            LogUtil.log("Class build path: " + baseClassPath.getPath(), new Object[0]);
            sClassPool.insertClassPath(baseClassPath.getPath());
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        BaseExtension android = (BaseExtension)project.getExtensions().getByType(BaseExtension.class);
        sClassPool.insertClassPath(((File)android.getBootClasspath().get(0)).toString());
        LogUtil.log("Android libraries: " + android.getBootClasspath(), new Object[0]);
        mMethodSuccessCount = 0;
        mMethodCurIndex = 0;
        mModifyRate = 2 + new Random().nextInt(4);
        CodeInjectUtil.traverseFile(baseClassPath);
        LogUtil.log("Total method modified: " + mMethodSuccessCount, new Object[0]);
    }

    private static void traverseFile(File baseClassFile) {
        File[] files;
        for (File file : files = baseClassFile.listFiles()) {
            if (file.isDirectory()) {
                if (file.getName().contains("META-INF")) {
                    LogUtil.log("\u6587\u4ef6\u5939 META-INF \u8df3\u8fc7  :" + file.getName(), new Object[0]);
                    continue;
                }
                CodeInjectUtil.traverseFile(file);
                continue;
            }
            if (!file.isFile() || !CodeInjectUtil.checkClassFile(file)) continue;
            CodeInjectUtil.inject(file.getPath());
        }
    }

    private static void inject(String classFilePath) {
        try {
            FileInputStream is = new FileInputStream(classFilePath);
            ClassFile classFile = new ClassFile(new DataInputStream(new BufferedInputStream(is)));
            CtClass ctClass = sClassPool.get(classFile.getName());
            if (ctClass.isFrozen()) {
                ctClass.defrost();
            }
            CodeInjectUtil.injectClassMethod(ctClass);
            byte[] classBytes = ctClass.toBytecode();
            FileUtils.writeByteArrayToFile((File)new File(classFilePath), (byte[])classBytes);
            ctClass.detach();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void injectClassMethod(CtClass ctClass) {
        CtMethod[] ctMethods = ctClass.getDeclaredMethods();
        if (ctMethods != null) {
            for (int i = 0; i < ctMethods.length; ++i) {
                boolean success;
                CtMethod ctMethod = ctMethods[i];
                if (CodeInjectUtil.isSkipMethod(ctMethod)) continue;
                if (mMethodCurIndex % mModifyRate != 0 && (success = CodeInjectUtil.modifyMethod(ctClass, ctMethod))) {
                    ++mMethodSuccessCount;
                }
                ++mMethodCurIndex;
            }
        }
    }

    private static boolean isSkipMethod(CtMethod ctMethod) {
        if ("invokeSuspend".equals(ctMethod.getName())) {
            return true;
        }
        try {
            for (CtClass parameterType : ctMethod.getParameterTypes()) {
                if (!"kotlin.coroutines.Continuation".equals(parameterType.getName())) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private static boolean modifyMethod(CtClass ctClass, CtMethod ctMethod) {
        JunkCodeFactory junkCodeFactory;
        switch (mRandom.nextInt(10)) {
            case 0: {
                junkCodeFactory = new CalculateJunkCodeFactory();
                break;
            }
            case 1: {
                junkCodeFactory = new StringJunkCodeFactory();
                break;
            }
            case 2: {
                junkCodeFactory = new UUIDJunkCodeFactory();
                break;
            }
            case 3: {
                junkCodeFactory = new SwitchJunkCodeFactory();
                break;
            }
            case 4: {
                junkCodeFactory = new MathJunkCodeFactory();
                break;
            }
            case 5: {
                junkCodeFactory = new EncoderJunkCodeFactory();
                break;
            }
            case 6: {
                junkCodeFactory = new DateJunkCodeFactory();
                break;
            }
            case 7: {
                junkCodeFactory = new BigDecimalJunkCodeFactory();
                break;
            }
            case 8: {
                junkCodeFactory = new StringBuilderJunkCodeFactory();
                break;
            }
            default: {
                junkCodeFactory = new TimeJunkCodeFactory();
            }
        }
        InsertCode insertCode = junkCodeFactory.getInsertCode();
        return insertCode.insert(sClassPool, ctClass, ctMethod);
    }

    public static Random getRandom() {
        return mRandom;
    }

    public static int getRandomMethodLine(CtMethod ctMethod) {
        MethodInfo methodInfo = ctMethod.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        int codeLines = methodInfo.getLineNumber(0);
        try {
            LineNumberAttribute lineNumberAttribute = (LineNumberAttribute)codeAttribute.getAttribute("LineNumberTable");
            if (lineNumberAttribute != null && lineNumberAttribute.tableLength() > 1) {
                return codeLines + mRandom.nextInt(lineNumberAttribute.tableLength() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return codeLines;
    }

    private static String generateBody(CtClass ctClass, CtMethod ctMethod, String newName) throws NotFoundException {
        String returnType = ctMethod.getReturnType().getName();
        System.out.println(returnType);
        Object methodResult = "${newName}($$);";
        if (!"void".equals(returnType)) {
            methodResult = "${returnType} result = " + (String)methodResult;
        }
        System.out.println((String)methodResult);
        return "{long costStartTime = System.currentTimeMillis();" + (String)methodResult + "android.util.Log.e(\"METHOD_COST\", \"${ctClass.name}.${ctMethod.name}() \u8017\u65f6\uff1a\" + (System.currentTimeMillis() - costStartTime) + \"ms\");" + ("void".equals(returnType) ? "}" : "return result;}");
    }

    private static boolean checkClassFile(File file) {
        if (file.getName().contains("META-INF")) {
            LogUtil.log("META-INF\u8df3\u8fc7   :" + file.getName(), new Object[0]);
            return false;
        }
        if (file.isDirectory()) {
            LogUtil.log("\u6587\u4ef6\u5939\u8df3\u8fc7   :" + file.getName(), new Object[0]);
            return false;
        }
        String filePath = file.getPath();
        return !filePath.contains("R$") && !filePath.contains("R.class") && !filePath.contains("BuildConfig.class");
    }
}

