/*
 * Decompiled with CFR 0.152.
 */
package com.plugins.junk;

import com.android.build.gradle.BaseExtension;
import com.plugins.junk.CodeExtension;
import com.plugins.junk.create.MethodBean;
import com.plugins.junk.create.MethodCodeFactory;
import com.plugins.junk.insert.JunkCodeFactory;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.LinkedList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;

public class CodeInjectUtil {
    private static final ClassPool sClassPool = ClassPool.getDefault();
    private static int mMethodSuccessCount = 0;
    private static int mMethodCurIndex = 0;
    private static int mCodeInjectPercentage;
    private static float mCodeInjectMethodRatio;

    public static void injectCode(File baseClassPath, Project project, CodeExtension extension) throws NotFoundException, CannotCompileException {
        try {
            LogUtil.log("Class build path: " + baseClassPath.getPath(), new Object[0]);
            sClassPool.insertClassPath(baseClassPath.getPath());
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        BaseExtension android = (BaseExtension)project.getExtensions().getByType(BaseExtension.class);
        sClassPool.insertClassPath(((File)android.getBootClasspath().get(0)).toString());
        LogUtil.log("Android libraries: " + android.getBootClasspath(), new Object[0]);
        mMethodSuccessCount = 0;
        mMethodCurIndex = 0;
        mCodeInjectPercentage = Math.round((float)extension.codeInjectPercentage / 10.0f);
        mCodeInjectMethodRatio = extension.codeInjectMethodRatio;
        CodeInjectUtil.traverseFile(baseClassPath);
        LogUtil.log("Total method modified: " + mMethodSuccessCount, new Object[0]);
    }

    private static void traverseFile(File baseClassFile) {
        File[] files;
        for (File file : files = baseClassFile.listFiles()) {
            if (file.isDirectory()) {
                if (file.getName().contains("META-INF")) {
                    LogUtil.log("\u6587\u4ef6\u5939 META-INF \u8df3\u8fc7  :" + file.getName(), new Object[0]);
                    continue;
                }
                CodeInjectUtil.traverseFile(file);
                continue;
            }
            if (!file.isFile() || !CodeInjectUtil.checkClassFile(file)) continue;
            CodeInjectUtil.inject(file.getPath());
        }
    }

    private static void inject(String classFilePath) {
        try {
            FileInputStream is = new FileInputStream(classFilePath);
            ClassFile classFile = new ClassFile(new DataInputStream(new BufferedInputStream(is)));
            CtClass ctClass = sClassPool.get(classFile.getName());
            if (ctClass.isFrozen()) {
                ctClass.defrost();
            }
            CtMethod[] ctMethods = ctClass.getDeclaredMethods();
            if (mCodeInjectMethodRatio > 0.0f) {
                CodeInjectUtil.createClassMethod(ctClass, ctMethods);
            }
            if (mCodeInjectPercentage > 0) {
                CodeInjectUtil.injectClassMethod(ctClass, ctMethods);
            }
            byte[] classBytes = ctClass.toBytecode();
            FileUtils.writeByteArrayToFile((File)new File(classFilePath), (byte[])classBytes);
            ctClass.detach();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createClassMethod(CtClass ctClass, CtMethod[] ctMethods) {
        int count;
        LinkedList<MethodBean> methods = new LinkedList<MethodBean>();
        if (ctMethods != null && (count = (int)((float)ctMethods.length * mCodeInjectMethodRatio)) > 0) {
            boolean isStatic = CodeInjectUtil.getClassMethodStaticPercentage(ctMethods) >= 60;
            for (int i = 0; i < count; ++i) {
                MethodBean methodBean = MethodCodeFactory.getMethodCode(sClassPool, ctClass, isStatic);
                if (methodBean == null) continue;
                try {
                    ctClass.addMethod(methodBean.getMethod());
                    methods.add(methodBean);
                    continue;
                }
                catch (CannotCompileException e) {
                    LogUtil.error("[add method failed]: %s - %s", methodBean.getMethod().getLongName(), e.getMessage());
                }
            }
            CodeInjectUtil.insertCreateMethod(ctMethods, methods);
        }
    }

    private static void insertCreateMethod(CtMethod[] ctMethods, List<MethodBean> methods) {
        if (methods.isEmpty()) {
            return;
        }
        int index = 0;
        int size = methods.size();
        for (int i = 0; i < size; ++i) {
            CtMethod ctMethod = ctMethods[i % ctMethods.length];
            try {
                ctMethod.insertAt(RandomUtil.getRandomMethodLine(ctMethod), methods.get(index).getCallMethod());
                if (++index < methods.size()) continue;
                index = 0;
                continue;
            }
            catch (CannotCompileException e) {
                if (size < methods.size() * 2) {
                    ++size;
                }
                LogUtil.error("[insert create method failed]: %s - %s", ctMethod.getLongName(), e.getMessage());
            }
        }
    }

    private static void injectClassMethod(CtClass ctClass, CtMethod[] ctMethods) {
        if (ctMethods != null) {
            for (CtMethod ctMethod : ctMethods) {
                if (CodeInjectUtil.isSkipMethod(ctMethod)) continue;
                boolean success = true;
                if (mCodeInjectPercentage > mMethodCurIndex && (success = JunkCodeFactory.insert(sClassPool, ctClass, ctMethod))) {
                    ++mMethodSuccessCount;
                }
                if (!success || ++mMethodCurIndex != 10) continue;
                mMethodCurIndex = 0;
            }
        }
    }

    private static boolean isSkipMethod(CtMethod ctMethod) {
        if ("invokeSuspend".equals(ctMethod.getName())) {
            return true;
        }
        try {
            for (CtClass parameterType : ctMethod.getParameterTypes()) {
                if (!"kotlin.coroutines.Continuation".equals(parameterType.getName())) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private static String generateBody(CtClass ctClass, CtMethod ctMethod, String newName) throws NotFoundException {
        String returnType = ctMethod.getReturnType().getName();
        System.out.println(returnType);
        Object methodResult = "${newName}($$);";
        if (!"void".equals(returnType)) {
            methodResult = "${returnType} result = " + (String)methodResult;
        }
        System.out.println((String)methodResult);
        return "{long costStartTime = System.currentTimeMillis();" + (String)methodResult + "android.util.Log.e(\"METHOD_COST\", \"${ctClass.name}.${ctMethod.name}() \u8017\u65f6\uff1a\" + (System.currentTimeMillis() - costStartTime) + \"ms\");" + ("void".equals(returnType) ? "}" : "return result;}");
    }

    private static boolean checkClassFile(File file) {
        if (file.getName().contains("META-INF")) {
            LogUtil.log("META-INF\u8df3\u8fc7   :" + file.getName(), new Object[0]);
            return false;
        }
        if (file.isDirectory()) {
            LogUtil.log("\u6587\u4ef6\u5939\u8df3\u8fc7   :" + file.getName(), new Object[0]);
            return false;
        }
        String filePath = file.getPath();
        return !filePath.contains("R$") && !filePath.contains("R.class") && !filePath.contains("BuildConfig.class");
    }

    private static int getClassMethodStaticPercentage(CtMethod[] ctMethods) {
        float staticCount = 0.0f;
        for (CtMethod ctMethod : ctMethods) {
            if (!Modifier.isStatic((int)ctMethod.getModifiers())) continue;
            staticCount += 1.0f;
        }
        return (int)(staticCount / (float)ctMethods.length * 100.0f);
    }
}

