/*
 * Decompiled with CFR 0.152.
 */
package com.plugins.junk;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.plugins.junk.CodeExtension;
import com.plugins.junk.CodeInjectUtil;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.MD5Util;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;

public class CodeTransform
extends Transform {
    private Project mProject;
    private CodeExtension mExtension;

    public CodeTransform(Project project, CodeExtension extension) {
        this.mProject = project;
        this.mExtension = extension;
    }

    public String getName() {
        return CodeTransform.class.getSimpleName();
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.PROJECT_ONLY;
    }

    public boolean isIncremental() {
        return false;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        super.transform(transformInvocation);
        LogUtil.log("---- code transform start ----", new Object[0]);
        LogUtil.log("code inject enable\uff1a" + this.mExtension.codeInjectEnable, new Object[0]);
        for (TransformInput input : transformInvocation.getInputs()) {
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                if (this.mExtension.codeInjectEnable) {
                    try {
                        CodeInjectUtil.injectCode(directoryInput.getFile(), this.mProject, this.mExtension);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                File contentLocation = transformInvocation.getOutputProvider().getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
                LogUtil.log("Class\u6587\u4ef6\u8f93\u5165\u8def\u5f84 = " + directoryInput.getFile().getAbsolutePath(), new Object[0]);
                LogUtil.log("Class\u6587\u4ef6\u8f93\u51fa\u8def\u5f84 = " + contentLocation.getAbsolutePath(), new Object[0]);
                FileUtils.copyDirectory((File)directoryInput.getFile(), (File)contentLocation);
            }
            for (JarInput jarInput : input.getJarInputs()) {
                String jarName = jarInput.getName();
                String md5Name = MD5Util.encrypt(jarInput.getFile().getAbsolutePath());
                if (jarName.endsWith(".jar")) {
                    jarName = jarName.substring(0, jarName.length() - 4);
                }
                File dest = transformInvocation.getOutputProvider().getContentLocation(jarName + md5Name, jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                FileUtils.copyFile((File)jarInput.getFile(), (File)dest);
            }
        }
        LogUtil.log("---- code transform end ----", new Object[0]);
    }
}

