/*
 * Decompiled with CFR 0.152.
 */
package com.plugins.junk.utils;

import java.util.Random;
import javassist.CtMethod;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LineNumberAttribute;
import javassist.bytecode.MethodInfo;

public class RandomUtil {
    private static final char[] abcNumber = "abcdefghijklmnopqrstuvwxyz1234567890".toCharArray();
    private static final char[] abc = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] specialSymbols = ",!@#$%&*;|][".toCharArray();
    private static final String[] mModifiers = new String[]{"public", "protected", ""};
    private static final String[] mModifiers2 = new String[]{"", " final"};
    private static final String[] mCalculationSymbols = new String[]{"-", "+", "*"};
    private static final String[] mJudgeSymbols = new String[]{"==", ">", "<", ">=", "<=", "!="};
    private static final Random mRandom = new Random();

    public static Random getRandom() {
        return mRandom;
    }

    public static String generateString() {
        return RandomUtil.generateString(RandomUtil.getRandom().nextInt(8) + 5);
    }

    public static String generateString(int lenth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lenth; ++i) {
            if (i != 0) {
                sb.append(abcNumber[RandomUtil.getRandom().nextInt(abcNumber.length)]);
                continue;
            }
            sb.append(abc[RandomUtil.getRandom().nextInt(abc.length)]);
        }
        return sb.toString();
    }

    public static int getRandomMethodLine(CtMethod ctMethod) {
        MethodInfo methodInfo = ctMethod.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        int codeLines = methodInfo.getLineNumber(0);
        try {
            LineNumberAttribute lineNumberAttribute = (LineNumberAttribute)codeAttribute.getAttribute("LineNumberTable");
            if (lineNumberAttribute != null && lineNumberAttribute.tableLength() > 1) {
                return codeLines + RandomUtil.getRandom().nextInt(lineNumberAttribute.tableLength() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return codeLines;
    }

    public static String getRandomModifier(boolean isStatic) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(mModifiers[RandomUtil.getRandom().nextInt(mModifiers.length)]);
        stringBuilder.append(mModifiers2[RandomUtil.getRandom().nextInt(mModifiers2.length)]);
        if (isStatic) {
            stringBuilder.append(" static");
        }
        return stringBuilder.toString();
    }

    public static String getCalculationSymbols() {
        return mCalculationSymbols[RandomUtil.getRandom().nextInt(mCalculationSymbols.length)];
    }

    public static String getJudgeSymbols() {
        return mJudgeSymbols[RandomUtil.getRandom().nextInt(mJudgeSymbols.length)];
    }

    public static String getRandomAbcNumber() {
        return String.valueOf(abcNumber[RandomUtil.getRandom().nextInt(abcNumber.length)]);
    }

    public static String getSpecialSymbols() {
        return String.valueOf(specialSymbols[RandomUtil.getRandom().nextInt(specialSymbols.length)]);
    }

    public static String getStringArray(String name) {
        return RandomUtil.getStringArray(name, RandomUtil.getRandom().nextInt(6) + 5);
    }

    public static String getStringArray(String name, int length) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("String[] ").append(name).append(" = {");
        for (int i = 0; i < length; ++i) {
            stringBuilder.append("\"").append(RandomUtil.generateString()).append(RandomUtil.generateString()).append("\"");
            if (i == length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("};\n");
        return stringBuilder.toString();
    }
}

