/*
 * Decompiled with CFR 0.152.
 */
package com.plugins.junk;

import com.android.build.gradle.BaseExtension;
import com.plugins.junk.CodeExtension;
import com.plugins.junk.create.MethodBean;
import com.plugins.junk.create.MethodCodeFactory;
import com.plugins.junk.insert.JunkCodeFactory;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;

public class CodeInjectUtil {
    private final ClassPool sClassPool = new ClassPool(true);
    private int mMethodSuccessCount = 0;
    private int mMethodCurIndex = 0;
    private int mCodeInjectPercentage;
    private float mCodeInjectMethodRatio;

    public void injectCode(File baseClassPath, Project project, CodeExtension extension) throws NotFoundException, CannotCompileException {
        ClassPath classPath = null;
        try {
            LogUtil.log("Class build path: " + baseClassPath.getPath(), new Object[0]);
            classPath = this.sClassPool.insertClassPath(baseClassPath.getPath());
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        File jarFile = new File(project.getGradle().getGradleUserHomeDir(), "caches/modules-2/files-2.1/");
        this.addJarFile(jarFile);
        BaseExtension android = (BaseExtension)project.getExtensions().getByType(BaseExtension.class);
        this.sClassPool.insertClassPath(((File)android.getBootClasspath().get(0)).toString());
        LogUtil.log("Android libraries: " + android.getBootClasspath(), new Object[0]);
        this.mMethodSuccessCount = 0;
        this.mMethodCurIndex = 0;
        this.mCodeInjectPercentage = Math.round((float)extension.codeInjectPercentage / 10.0f);
        this.mCodeInjectMethodRatio = extension.codeInjectMethodRatio;
        this.traverseFile(baseClassPath);
        LogUtil.log("Total method modified: " + this.mMethodSuccessCount, new Object[0]);
    }

    private void addJarFile(File jarFile) {
        File[] files = jarFile.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String absolutePath;
            if (file.isDirectory()) {
                this.addJarFile(file);
                continue;
            }
            if (!file.isFile() || !(absolutePath = file.getAbsolutePath()).endsWith(".jar") && !absolutePath.endsWith(".aar")) continue;
            try {
                this.sClassPool.insertClassPath(absolutePath);
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void traverseFile(File baseClassFile) {
        File[] files;
        for (File file : files = baseClassFile.listFiles()) {
            if (file.isDirectory()) {
                if (file.getName().contains("META-INF")) {
                    LogUtil.log("\u6587\u4ef6\u5939 META-INF \u8df3\u8fc7  :" + file.getName(), new Object[0]);
                    continue;
                }
                this.traverseFile(file);
                continue;
            }
            if (!file.isFile() || !this.checkClassFile(file)) continue;
            this.inject(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inject(String classFilePath) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(classFilePath);
            ClassFile classFile = new ClassFile(new DataInputStream(new BufferedInputStream(is)));
            CtClass ctClass = this.sClassPool.get(classFile.getName());
            if (ctClass.isFrozen()) {
                ctClass.defrost();
            }
            CtMethod[] ctMethods = ctClass.getDeclaredMethods();
            boolean isInterface = Modifier.isInterface((int)ctClass.getModifiers());
            if (this.mCodeInjectMethodRatio > 0.0f) {
                this.createClassMethod(ctClass, ctMethods, isInterface);
            }
            if (this.mCodeInjectPercentage > 0 && !isInterface) {
                this.injectClassMethod(ctClass, ctMethods);
            }
            byte[] classBytes = ctClass.toBytecode();
            FileUtils.writeByteArrayToFile((File)new File(classFilePath), (byte[])classBytes);
            ctClass.detach();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void createClassMethod(CtClass ctClass, CtMethod[] ctMethods, boolean isInterface) {
        int count;
        if (ctMethods != null && (count = (int)((float)ctMethods.length * this.mCodeInjectMethodRatio)) > 0) {
            LinkedList<MethodBean> methods = new LinkedList<MethodBean>();
            LinkedList<MethodBean> staticMethods = new LinkedList<MethodBean>();
            int staticCount = (int)((float)this.getClassMethodStaticPercentage(ctMethods) * this.mCodeInjectMethodRatio);
            for (int i = 0; i < count; ++i) {
                boolean isStatic = staticCount > i;
                MethodBean methodBean = MethodCodeFactory.getMethodCode(this.sClassPool, ctClass, isStatic, isInterface);
                if (methodBean == null) continue;
                try {
                    ctClass.addMethod(methodBean.getMethod());
                    if (isStatic) {
                        staticMethods.add(methodBean);
                        continue;
                    }
                    methods.add(methodBean);
                    continue;
                }
                catch (CannotCompileException e) {
                    LogUtil.error("[add method failed]: %s - %s", methodBean.getMethod().getLongName(), e.getMessage());
                }
            }
            if (!isInterface) {
                this.insertCreateMethod(ctMethods, methods, staticMethods);
            }
        }
    }

    private void insertCreateMethod(CtMethod[] ctMethods, List<MethodBean> methods, List<MethodBean> staticMethods) {
        int allSize = methods.size() + staticMethods.size();
        int index = 0;
        int staticIndex = 0;
        int size = allSize;
        for (int i = 0; i < size; ++i) {
            CtMethod ctMethod = ctMethods[i % ctMethods.length];
            if (Modifier.isAbstract((int)ctMethod.getModifiers()) || Modifier.isNative((int)ctMethod.getModifiers())) continue;
            try {
                if (Modifier.isStatic((int)ctMethod.getModifiers())) {
                    ctMethod.insertAt(RandomUtil.getRandomMethodLine(ctMethod), staticMethods.get(staticIndex % staticMethods.size()).getCallMethod());
                    ++staticIndex;
                    continue;
                }
                ctMethod.insertAt(RandomUtil.getRandomMethodLine(ctMethod), methods.get(index % methods.size()).getCallMethod());
                ++index;
                continue;
            }
            catch (CannotCompileException e) {
                if (size < allSize * 2) {
                    ++size;
                }
                LogUtil.error("[insert create method failed]: %s - %s", ctMethod.getLongName(), e.getMessage());
            }
        }
    }

    private void injectClassMethod(CtClass ctClass, CtMethod[] ctMethods) {
        if (ctMethods != null) {
            for (CtMethod ctMethod : ctMethods) {
                if (this.isSkipMethod(ctMethod)) continue;
                boolean success = true;
                if (this.mCodeInjectPercentage > this.mMethodCurIndex && (success = JunkCodeFactory.insert(this.sClassPool, ctClass, ctMethod))) {
                    ++this.mMethodSuccessCount;
                }
                if (!success) continue;
                ++this.mMethodCurIndex;
                if (this.mMethodCurIndex != 10) continue;
                this.mMethodCurIndex = 0;
            }
        }
    }

    private boolean isSkipMethod(CtMethod ctMethod) {
        if (Modifier.isAbstract((int)ctMethod.getModifiers()) || Modifier.isNative((int)ctMethod.getModifiers())) {
            return true;
        }
        if ("invokeSuspend".equals(ctMethod.getName())) {
            return true;
        }
        try {
            for (CtClass parameterType : ctMethod.getParameterTypes()) {
                if (!"kotlin.coroutines.Continuation".equals(parameterType.getName())) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean checkClassFile(File file) {
        if (file.getName().contains("META-INF")) {
            LogUtil.log("META-INF\u8df3\u8fc7   :" + file.getName(), new Object[0]);
            return false;
        }
        if (file.isDirectory()) {
            LogUtil.log("\u6587\u4ef6\u5939\u8df3\u8fc7   :" + file.getName(), new Object[0]);
            return false;
        }
        String filePath = file.getPath();
        return !filePath.contains("R$") && !filePath.contains("R.class") && !filePath.contains("BuildConfig.class");
    }

    private int getClassMethodStaticPercentage(CtMethod[] ctMethods) {
        int staticCount = 0;
        for (CtMethod ctMethod : ctMethods) {
            if (!Modifier.isStatic((int)ctMethod.getModifiers())) continue;
            ++staticCount;
        }
        return staticCount;
    }
}

