/*
 * Decompiled with CFR 0.152.
 */
package com.plugins.junk;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class MethodTemplate {
    public static String createGmtOffsetString(boolean includeGmt, boolean includeMinuteSeparator, int offsetMillis) {
        int offsetMinutes = offsetMillis / 60000;
        char sign = '+';
        if (offsetMinutes < 0) {
            sign = '-';
            offsetMinutes = -offsetMinutes;
        }
        StringBuilder builder = new StringBuilder(9);
        if (includeGmt) {
            builder.append("GMT");
        }
        builder.append(sign);
        MethodTemplate.appendNumber(builder, 2, offsetMinutes / 60);
        if (includeMinuteSeparator) {
            builder.append(':');
        }
        MethodTemplate.appendNumber(builder, 2, offsetMinutes % 60);
        return builder.toString();
    }

    private static void appendNumber(StringBuilder builder, int count, int value) {
        String string = Integer.toString(value);
        for (int i = 0; i < count - string.length(); ++i) {
            builder.append('0');
        }
        builder.append(string);
    }

    public static int getRatioSize(int bitWidth, int bitHeight) {
        int imageHeight = 1280;
        int imageWidth = 960;
        int ratio = 1;
        if (bitWidth > bitHeight && bitWidth > imageWidth) {
            ratio = bitWidth / imageWidth;
        } else if (bitWidth < bitHeight && bitHeight > imageHeight) {
            ratio = bitHeight / imageHeight;
        }
        if (ratio <= 0) {
            ratio = 1;
        }
        return ratio;
    }

    public static boolean getSysIsToday(String sDate) {
        boolean falg = false;
        try {
            String timeDate;
            String nowDate;
            SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = null;
            date = dateFormater.parse(sDate);
            Date today = new Date();
            if (date != null && (nowDate = dateFormater.format(today)).equals(timeDate = dateFormater.format(date))) {
                falg = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return falg;
    }

    public static String cutString(String str, int length, String dot) {
        char[] ch;
        int temp = 0;
        StringBuffer sb = new StringBuffer(length);
        for (char c : ch = str.toCharArray()) {
            sb.append(c);
            temp = c > '\u0100' ? (temp += 2) : ++temp;
            if (temp < length) continue;
            if (dot == null) break;
            sb.append(dot);
            break;
        }
        return sb.toString();
    }

    public static boolean isContinuousNum(String str) {
        int len = str.length();
        for (int i = 0; i < len - 1; ++i) {
            char nextChar;
            char curChar = str.charAt(i);
            char verifyChar = (char)(curChar + '\u0001');
            if (curChar == '9') {
                verifyChar = '0';
            }
            if ((nextChar = str.charAt(i + 1)) == verifyChar) continue;
            return false;
        }
        return true;
    }

    public static boolean isRealDate(String date, int yearlen) {
        int len = 4 + yearlen;
        if (date == null || date.length() != len) {
            return false;
        }
        if (!date.matches("[0-9]+")) {
            return false;
        }
        int year = Integer.parseInt(date.substring(0, yearlen));
        int month = Integer.parseInt(date.substring(yearlen, yearlen + 2));
        int day = Integer.parseInt(date.substring(yearlen + 2, yearlen + 4));
        if (year <= 0) {
            return false;
        }
        if (month <= 0 || month > 12) {
            return false;
        }
        if (day <= 0 || day > 31) {
            return false;
        }
        switch (month) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return day <= 30;
            }
            case 2: {
                if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                    return day <= 29;
                }
                return day <= 28;
            }
        }
        return true;
    }

    public static char getBankCardCheckCode(String nonCheckCodeCardId) {
        if (nonCheckCodeCardId == null || nonCheckCodeCardId.trim().length() == 0 || !nonCheckCodeCardId.matches("\\d+")) {
            return 'N';
        }
        char[] chs = nonCheckCodeCardId.trim().toCharArray();
        int luhmSum = 0;
        int i = chs.length - 1;
        int j = 0;
        while (i >= 0) {
            int k = chs[i] - 48;
            if (j % 2 == 0) {
                k *= 2;
                k = k / 10 + k % 10;
            }
            luhmSum += k;
            --i;
            ++j;
        }
        return luhmSum % 10 == 0 ? (char)'0' : (char)(10 - luhmSum % 10 + 48);
    }

    public static String keywordMadeRed(String sourceString, String keyword) {
        String result = "";
        if (sourceString != null && !"".equals(sourceString.trim())) {
            result = keyword != null && !"".equals(keyword.trim()) ? sourceString.replaceAll(keyword, "<font color=\"red\">" + keyword + "</font>") : sourceString;
        }
        return result;
    }

    public static String getCheckCode18(int iSum) {
        String sCode = "";
        switch (iSum % 11) {
            case 10: {
                sCode = "2";
                break;
            }
            case 9: {
                sCode = "3";
                break;
            }
            case 8: {
                sCode = "4";
                break;
            }
            case 7: {
                sCode = "5";
                break;
            }
            case 6: {
                sCode = "6";
                break;
            }
            case 5: {
                sCode = "7";
                break;
            }
            case 4: {
                sCode = "8";
                break;
            }
            case 3: {
                sCode = "9";
                break;
            }
            case 2: {
                sCode = "x";
                break;
            }
            case 1: {
                sCode = "0";
                break;
            }
            case 0: {
                sCode = "1";
            }
        }
        return sCode;
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 instanceof long[]) {
            return Arrays.equals((long[])array1, (long[])array2);
        }
        if (array1 instanceof int[]) {
            return Arrays.equals((int[])array1, (int[])array2);
        }
        if (array1 instanceof short[]) {
            return Arrays.equals((short[])array1, (short[])array2);
        }
        if (array1 instanceof char[]) {
            return Arrays.equals((char[])array1, (char[])array2);
        }
        if (array1 instanceof byte[]) {
            return Arrays.equals((byte[])array1, (byte[])array2);
        }
        if (array1 instanceof double[]) {
            return Arrays.equals((double[])array1, (double[])array2);
        }
        if (array1 instanceof float[]) {
            return Arrays.equals((float[])array1, (float[])array2);
        }
        if (array1 instanceof boolean[]) {
            return Arrays.equals((boolean[])array1, (boolean[])array2);
        }
        return Arrays.deepEquals((Object[])array1, (Object[])array2);
    }

    public int[] range1(int includedStart, int excludedEnd, int step) {
        if (includedStart > excludedEnd) {
            int tmp = includedStart;
            includedStart = excludedEnd;
            excludedEnd = tmp;
        }
        if (step <= 0) {
            step = 1;
        }
        int deviation = excludedEnd - includedStart;
        int length = deviation / step;
        if (deviation % step != 0) {
            ++length;
        }
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = includedStart;
            includedStart += step;
        }
        return range;
    }

    public static byte[][] split(byte[] array, int len) {
        int amount = array.length / len;
        int remainder = array.length % len;
        if (remainder != 0) {
            ++amount;
        }
        byte[][] arrays = new byte[amount][];
        for (int i = 0; i < amount; ++i) {
            byte[] arr;
            if (i == amount - 1 && remainder != 0) {
                arr = new byte[remainder];
                System.arraycopy(array, i * len, arr, 0, remainder);
            } else {
                arr = new byte[len];
                System.arraycopy(array, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }

    public static int[] rainbow(int pageNo, int totalPage, int displayCount) {
        boolean isEven = (displayCount & 1) == 0;
        int left = displayCount >> 1;
        int right = displayCount >> 1;
        int length = displayCount;
        if (isEven) {
            ++right;
        }
        if (totalPage < displayCount) {
            length = totalPage;
        }
        int[] result = new int[length];
        if (totalPage >= displayCount) {
            if (pageNo <= left) {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i + 1;
                }
            } else if (pageNo > totalPage - right) {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i + totalPage - displayCount + 1;
                }
            } else {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i + pageNo - left + (isEven ? 1 : 0);
                }
            }
        } else {
            for (int i = 0; i < result.length; ++i) {
                result[i] = i + 1;
            }
        }
        return result;
    }

    public static int getTimeDistance(Date beginDate, Date endDate) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(beginDate);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);
        long beginTime = beginCalendar.getTime().getTime();
        long endTime = endCalendar.getTime().getTime();
        int betweenDays = (int)((endTime - beginTime) / 86400000L);
        endCalendar.add(5, -betweenDays);
        endCalendar.add(5, -1);
        if (beginCalendar.get(5) == endCalendar.get(5)) {
            return betweenDays + 1;
        }
        return betweenDays;
    }
}

