/*
 * Decompiled with CFR 0.152.
 */
package com.plugins.junk;

import com.android.build.gradle.BaseExtension;
import com.plugins.junk.CallCode;
import com.plugins.junk.CodeExtension;
import com.plugins.junk.field.FieldBean;
import com.plugins.junk.field.FieldCodeFactory;
import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.MethodCodeFactory;
import com.plugins.junk.method.insert.JunkCodeFactory;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;

public class CodeInjectUtil {
    private final ClassPool sClassPool = new ClassPool(true);
    private int mMethodSuccessCount = 0;
    private int mMethodCurIndex = 0;
    private int mCodeInjectPercentage;
    private float mCodeInjectMethodRatio;
    private float mCodeInjectFieldRatio;
    private String[] mCodeInjectWhiteList;

    public void injectCode(File baseClassPath, Project project, CodeExtension extension, Map<String, String> map) throws NotFoundException, CannotCompileException {
        try {
            LogUtil.log("Class build path: " + baseClassPath.getPath(), new Object[0]);
            this.sClassPool.insertClassPath(baseClassPath.getPath());
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        this.addJarFile(map);
        BaseExtension android = (BaseExtension)project.getExtensions().getByType(BaseExtension.class);
        this.sClassPool.insertClassPath(((File)android.getBootClasspath().get(0)).toString());
        LogUtil.log("Android libraries: " + android.getBootClasspath(), new Object[0]);
        this.mMethodSuccessCount = 0;
        this.mMethodCurIndex = 0;
        this.mCodeInjectPercentage = Math.round((float)extension.codeInjectPercentage / 10.0f);
        this.mCodeInjectMethodRatio = extension.codeInjectMethodRatio;
        this.mCodeInjectWhiteList = extension.codeInjectWhiteList;
        this.traverseFile(baseClassPath);
        LogUtil.log("Total method modified: " + this.mMethodSuccessCount, new Object[0]);
    }

    private void addJarFile(Map<String, String> map) {
        LogUtil.log("library  size:" + map.size(), new Object[0]);
        map.forEach((s, s2) -> {
            try {
                LogUtil.log("library  name:%s , path: %s", s, s2);
                this.sClassPool.insertClassPath(s2);
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
        });
    }

    private void traverseFile(File baseClassFile) {
        File[] files;
        for (File file : files = baseClassFile.listFiles()) {
            if (file.isDirectory()) {
                if (file.getName().contains("META-INF")) {
                    LogUtil.log("\u6587\u4ef6\u5939 META-INF \u8df3\u8fc7  :" + file.getName(), new Object[0]);
                    continue;
                }
                this.traverseFile(file);
                continue;
            }
            if (!file.isFile() || !this.checkClassFile(file)) continue;
            this.inject(file.getPath());
        }
    }

    private void inject(String classFilePath) {
        try (FileInputStream is = new FileInputStream(classFilePath);){
            ClassFile classFile = new ClassFile(new DataInputStream(new BufferedInputStream(is)));
            CtClass ctClass = this.sClassPool.get(classFile.getName());
            if (ctClass.isFrozen()) {
                ctClass.defrost();
            }
            if (!this.checkWhiteList(ctClass)) {
                CtMethod[] ctMethods = ctClass.getDeclaredMethods();
                boolean isInterface = Modifier.isInterface((int)ctClass.getModifiers());
                if (this.mCodeInjectMethodRatio > 0.0f) {
                    this.createClassMethod(ctClass, ctMethods, isInterface);
                }
                if (this.mCodeInjectPercentage > 0 && !isInterface) {
                    this.injectClassMethod(ctClass, ctMethods);
                }
            }
            byte[] classBytes = ctClass.toBytecode();
            FileUtils.writeByteArrayToFile((File)new File(classFilePath), (byte[])classBytes);
            ctClass.detach();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createClassField(CtClass ctClass, CtMethod[] ctMethods) {
        if (ctMethods == null) {
            return;
        }
        int count = (int)((float)ctMethods.length * this.mCodeInjectFieldRatio);
        if (count > 0) {
            LinkedList<CallCode> fields = new LinkedList<CallCode>();
            LinkedList<CallCode> staticFields = new LinkedList<CallCode>();
            int staticCount = (int)((float)this.getClassMethodStaticPercentage(ctMethods) * this.mCodeInjectFieldRatio);
            for (int i = 0; i < count; ++i) {
                boolean isStatic = staticCount > i;
                FieldBean fieldBean = FieldCodeFactory.getFieldCode(this.sClassPool, ctClass, isStatic);
                if (fieldBean == null) continue;
                try {
                    ctClass.addField(fieldBean.getCtField());
                    if (isStatic) {
                        staticFields.add(fieldBean);
                        continue;
                    }
                    fields.add(fieldBean);
                    continue;
                }
                catch (CannotCompileException e) {
                    LogUtil.error("[add field failed]: %s - %s", fieldBean.getCtField().getName(), e.getMessage());
                }
            }
            this.insertCreateCode(ctMethods, fields, staticFields, false);
            this.insertCreateCode(ctMethods, fields, staticFields, true);
        }
    }

    private void createClassMethod(CtClass ctClass, CtMethod[] ctMethods, boolean isInterface) {
        int count;
        if (ctMethods != null && (count = (int)((float)ctMethods.length * this.mCodeInjectMethodRatio)) > 0) {
            LinkedList<CallCode> methods = new LinkedList<CallCode>();
            LinkedList<CallCode> staticMethods = new LinkedList<CallCode>();
            int staticCount = (int)((float)this.getClassMethodStaticPercentage(ctMethods) * this.mCodeInjectMethodRatio);
            for (int i = 0; i < count; ++i) {
                boolean isStatic = staticCount > i;
                MethodBean methodBean = MethodCodeFactory.getMethodCode(this.sClassPool, ctClass, isStatic, isInterface);
                if (methodBean == null) continue;
                try {
                    ctClass.addMethod(methodBean.getMethod());
                    if (isStatic) {
                        staticMethods.add(methodBean);
                        continue;
                    }
                    methods.add(methodBean);
                    continue;
                }
                catch (CannotCompileException e) {
                    LogUtil.error("[add method failed]: %s - %s", methodBean.getMethod().getLongName(), e.getMessage());
                }
            }
            if (!isInterface) {
                this.insertCreateCode(ctMethods, methods, staticMethods, false);
                this.insertCreateCode(ctMethods, methods, staticMethods, true);
            }
        }
    }

    private void insertCreateCode(CtMethod[] ctMethods, List<CallCode> methods, List<CallCode> staticMethods, boolean isRandom) {
        int allSize = methods.size() + staticMethods.size();
        int index = 0;
        int staticIndex = 0;
        int size = allSize;
        if (isRandom) {
            Collections.shuffle(Arrays.asList(ctMethods));
        }
        for (int i = 0; i < size; ++i) {
            CtMethod ctMethod = ctMethods[i % ctMethods.length];
            if (this.isSkipMethod(ctMethod)) continue;
            try {
                if (Modifier.isStatic((int)ctMethod.getModifiers())) {
                    JavassistUtils.insertAt(ctMethod, staticMethods.get(staticIndex % staticMethods.size()).call());
                    ++staticIndex;
                    continue;
                }
                JavassistUtils.insertAt(ctMethod, methods.get(index % methods.size()).call());
                ++index;
                continue;
            }
            catch (CannotCompileException e) {
                if (size < allSize * 2) {
                    ++size;
                }
                LogUtil.error("[insert create code failed]: %s - %s", ctMethod.getLongName(), e.getMessage());
            }
        }
    }

    private void injectClassMethod(CtClass ctClass, CtMethod[] ctMethods) {
        if (ctMethods != null) {
            for (CtMethod ctMethod : ctMethods) {
                if (this.isSkipMethod(ctMethod)) continue;
                boolean success = true;
                if (this.mCodeInjectPercentage > this.mMethodCurIndex && (success = JunkCodeFactory.insert(this.sClassPool, ctClass, ctMethod))) {
                    ++this.mMethodSuccessCount;
                }
                if (!success) continue;
                ++this.mMethodCurIndex;
                if (this.mMethodCurIndex != 10) continue;
                this.mMethodCurIndex = 0;
            }
        }
    }

    private boolean isSkipMethod(CtMethod ctMethod) {
        if (Modifier.isAbstract((int)ctMethod.getModifiers()) || Modifier.isNative((int)ctMethod.getModifiers())) {
            return true;
        }
        if ("invokeSuspend".equals(ctMethod.getName())) {
            return true;
        }
        try {
            for (CtClass parameterType : ctMethod.getParameterTypes()) {
                if (!"kotlin.coroutines.Continuation".equals(parameterType.getName())) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean checkWhiteList(CtClass ctMethod) {
        if (this.mCodeInjectWhiteList != null && this.mCodeInjectWhiteList.length > 0) {
            String name = ctMethod.getSimpleName();
            for (String s : this.mCodeInjectWhiteList) {
                if (!name.equals(s) && !name.startsWith(s + "$")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkClassFile(File file) {
        if (file.getName().contains("META-INF")) {
            LogUtil.log("META-INF\u8df3\u8fc7   :" + file.getName(), new Object[0]);
            return false;
        }
        if (file.isDirectory()) {
            LogUtil.log("\u6587\u4ef6\u5939\u8df3\u8fc7   :" + file.getName(), new Object[0]);
            return false;
        }
        if (file.getName().endsWith(".json")) {
            LogUtil.log("json\u6587\u4ef6\u8df3\u8fc7   :" + file.getName(), new Object[0]);
            return false;
        }
        String filePath = file.getPath();
        return !filePath.contains("R$") && !filePath.contains("R.class") && !filePath.contains("BuildConfig.class");
    }

    private int getClassMethodStaticPercentage(CtMethod[] ctMethods) {
        int staticCount = 0;
        for (CtMethod ctMethod : ctMethods) {
            if (!Modifier.isStatic((int)ctMethod.getModifiers())) continue;
            ++staticCount;
        }
        return staticCount;
    }
}

