/*
 * Decompiled with CFR 0.152.
 */
package com.plugins.junk;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.plugins.junk.CodeExtension;
import com.plugins.junk.CodeTransform;
import com.plugins.junk.utils.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;

public class CodePlugin
implements Plugin<Project> {
    private final Map<String, String> mMap = new HashMap<String, String>();

    public void apply(Project project) {
        CodeExtension.create(project);
        this.deleteCache(project);
        this.executeJarTask(project);
        this.initConfig(project);
    }

    private void executeJarTask(final Project project) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project p) {
                LogUtil.log("Gradle\u914d\u7f6e\u9636\u6bb5\u7ed3\u675f", new Object[0]);
                if (project.getPlugins().hasPlugin("com.android.application")) {
                    AppExtension app = (AppExtension)project.getExtensions().getByType(AppExtension.class);
                    app.getApplicationVariants().all(applicationVariant -> CodePlugin.this.getJarPath(applicationVariant.getName(), project));
                } else {
                    LibraryExtension library = (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
                    library.getLibraryVariants().all(libraryVariant -> CodePlugin.this.getJarPath(libraryVariant.getName(), project));
                }
            }
        });
    }

    private void initConfig(Project project) {
        Object obj = project.getExtensions().findByName("code");
        LogUtil.log("initConfig", new Object[0]);
        if (null != obj) {
            CodeExtension extension = (CodeExtension)obj;
            LogUtil.log("registerTransform", new Object[0]);
            try {
                BaseExtension android = (BaseExtension)project.getExtensions().getByType(BaseExtension.class);
                CodeTransform codeTransform = new CodeTransform(project, extension, this.mMap);
                android.registerTransform((Transform)codeTransform, new Object[0]);
            }
            catch (Exception e) {
                LogUtil.error("registerTransform fail: ", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    private void deleteCache(Project project) {
        try {
            FileUtils.deleteDirectory((File)new File(project.getBuildDir(), "/intermediates/transforms/"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void getJarPath(String name, Project project) {
        if (!this.mMap.isEmpty()) {
            return;
        }
        try {
            Configuration runtimeClasspath = project.getConfigurations().getByName(name + "RuntimeClasspath");
            for (File r : runtimeClasspath.getFiles()) {
                this.mMap.put(r.getName(), r.getAbsolutePath());
            }
        }
        catch (Exception e) {
            this.getImplementation(project);
        }
    }

    private void getImplementation(Project project) {
        File jarFile = new File(project.getGradle().getGradleUserHomeDir(), "caches" + File.separator + "modules-2" + File.separator + "files-2.1" + File.separator);
        try {
            Configuration implementation = project.getConfigurations().getByName("implementation");
            for (Dependency r : implementation.getAllDependencies()) {
                String version = r.getVersion();
                if (version == null || "unspecified".equals(version)) continue;
                File file = new File(jarFile, r.getGroup() + File.separator + r.getName() + File.separator + version + File.separator);
                this.findJar(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void findJar(File files) {
        try {
            File[] listed = files.listFiles();
            if (listed == null) {
                return;
            }
            for (File listFile : listed) {
                String absolutePath;
                if (listFile.isDirectory()) {
                    this.findJar(listFile);
                    continue;
                }
                if (!listFile.isFile() || !(absolutePath = listFile.getAbsolutePath()).endsWith(".jar") && !absolutePath.endsWith(".aar")) continue;
                this.mMap.put(listFile.getName(), listFile.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

