/*
 * Decompiled with CFR 0.152.
 */
package io.github.cafeteru.validator_lib.impl;

import io.github.cafeteru.validator_lib.Validator;
import java.util.Objects;

public class ValidatorDni
implements Validator {
    private static final String LETTERS = "TRWAGMYFPDXBNJZSQVHLCKET";
    private static final int SIZE = 9;
    private String dni;

    @Override
    public boolean isValid() {
        if (Objects.isNull(this.dni)) {
            return true;
        }
        try {
            if (this.dni.length() == 9 && Character.isLetter(this.dni.charAt(this.dni.length() - 1))) {
                String myNumber = this.dni.substring(0, 8);
                int numberConverted = Integer.parseInt(myNumber) % 23;
                String letterDni = this.dni.substring(8).toUpperCase();
                return letterDni.equals(LETTERS.substring(numberConverted, numberConverted + 1));
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public ValidatorDni(String dni) {
        this.dni = dni;
    }
}

