/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya;

import io.github.daichangya.model.ChangeObject;
import io.github.daichangya.model.DiffOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class Diff<T> {
    public List<ChangeObject<String>> diff(String oldValue, String newValue) {
        return this.diff(oldValue, newValue, new DiffOptions());
    }

    public List<ChangeObject<String>> diff(String oldValue, String newValue, DiffOptions options) {
        String oldString = this.castInput(oldValue, options);
        String newString = this.castInput(newValue, options);
        List<T> oldTokens = this.removeEmpty(this.tokenize(oldString, options));
        List<T> newTokens = this.removeEmpty(this.tokenize(newString, options));
        return this.diffWithOptions(oldTokens, newTokens, options);
    }

    private List<ChangeObject<String>> diffWithOptions(List<T> oldTokens, List<T> newTokens, DiffOptions options) {
        int newLen = newTokens.size();
        int oldLen = oldTokens.size();
        int editLength = 1;
        int maxEditLength = newLen + oldLen;
        if (options.getMaxEditLength() != null) {
            maxEditLength = Math.min(maxEditLength, options.getMaxEditLength());
        }
        long abortAfterTimestamp = options.getTimeout() != null ? System.currentTimeMillis() + options.getTimeout() : Long.MAX_VALUE;
        HashMap<Integer, Path> bestPath = new HashMap<Integer, Path>();
        bestPath.put(0, new Path(-1, null));
        int newPos = this.extractCommon((Path)bestPath.get(0), newTokens, oldTokens, 0, options);
        if (((Path)bestPath.get((Object)Integer.valueOf((int)0))).oldPos + 1 >= oldLen && newPos + 1 >= newLen) {
            return this.postProcess(this.buildValues(((Path)bestPath.get((Object)Integer.valueOf((int)0))).lastComponent, newTokens, oldTokens), options);
        }
        int minDiagonalToConsider = Integer.MIN_VALUE;
        int maxDiagonalToConsider = Integer.MAX_VALUE;
        while (editLength <= maxEditLength && System.currentTimeMillis() <= abortAfterTimestamp) {
            for (int diagonalPath = Math.max(minDiagonalToConsider, -editLength); diagonalPath <= Math.min(maxDiagonalToConsider, editLength); diagonalPath += 2) {
                boolean canRemove;
                Path removePath = (Path)bestPath.get(diagonalPath - 1);
                Path addPath = (Path)bestPath.get(diagonalPath + 1);
                if (removePath != null) {
                    bestPath.remove(diagonalPath - 1);
                }
                boolean canAdd = false;
                if (addPath != null) {
                    int addPathNewPos = addPath.oldPos - diagonalPath;
                    canAdd = addPathNewPos >= 0 && addPathNewPos < newLen;
                }
                boolean bl = canRemove = removePath != null && removePath.oldPos + 1 < oldLen;
                if (!canAdd && !canRemove) {
                    bestPath.remove(diagonalPath);
                    continue;
                }
                Path basePath = !canRemove || canAdd && removePath.oldPos < addPath.oldPos ? this.addToPath(addPath, true, false, 0, options) : this.addToPath(removePath, false, true, 1, options);
                newPos = this.extractCommon(basePath, newTokens, oldTokens, diagonalPath, options);
                if (basePath.oldPos + 1 >= oldLen && newPos + 1 >= newLen) {
                    return this.postProcess(this.buildValues(basePath.lastComponent, newTokens, oldTokens), options);
                }
                bestPath.put(diagonalPath, basePath);
                if (basePath.oldPos + 1 >= oldLen) {
                    maxDiagonalToConsider = Math.min(maxDiagonalToConsider, diagonalPath - 1);
                }
                if (newPos + 1 < newLen) continue;
                minDiagonalToConsider = Math.max(minDiagonalToConsider, diagonalPath + 1);
            }
            ++editLength;
        }
        return null;
    }

    private Path addToPath(Path path, boolean added, boolean removed, int oldPosInc, DiffOptions options) {
        DraftChangeObject last = path.lastComponent;
        if (last != null && !options.isOneChangePerToken() && last.added == added && last.removed == removed) {
            return new Path(path.oldPos + oldPosInc, new DraftChangeObject(last.count + 1, added, removed, last.previousComponent));
        }
        return new Path(path.oldPos + oldPosInc, new DraftChangeObject(1, added, removed, last));
    }

    private int extractCommon(Path basePath, List<T> newTokens, List<T> oldTokens, int diagonalPath, DiffOptions options) {
        int newLen = newTokens.size();
        int oldLen = oldTokens.size();
        int oldPos = basePath.oldPos;
        int newPos = oldPos - diagonalPath;
        int commonCount = 0;
        while (newPos + 1 < newLen && oldPos + 1 < oldLen && this.equals(oldTokens.get(oldPos + 1), newTokens.get(newPos + 1), options)) {
            ++newPos;
            ++oldPos;
            ++commonCount;
            if (!options.isOneChangePerToken()) continue;
            basePath.lastComponent = new DraftChangeObject(1, basePath.lastComponent, false, false);
        }
        if (commonCount > 0 && !options.isOneChangePerToken()) {
            basePath.lastComponent = new DraftChangeObject(commonCount, basePath.lastComponent, false, false);
        }
        basePath.oldPos = oldPos;
        return newPos;
    }

    protected boolean equals(T left, T right, DiffOptions options) {
        if (options.getComparator() != null) {
            return options.getComparator().compare(left, right) == 0;
        }
        if (left == null) {
            return right == null;
        }
        if (options.isIgnoreCase() && left instanceof String && right instanceof String) {
            return ((String)left).equalsIgnoreCase((String)right);
        }
        return left.equals(right);
    }

    protected List<T> removeEmpty(List<T> array) {
        ArrayList<T> ret = new ArrayList<T>();
        for (T item : array) {
            if (item == null || item instanceof String && ((String)item).isEmpty()) continue;
            ret.add(item);
        }
        return ret;
    }

    protected String castInput(String value, DiffOptions options) {
        return value;
    }

    protected abstract List<T> tokenize(String var1, DiffOptions var2);

    protected String join(List<T> tokens) {
        StringBuilder sb = new StringBuilder();
        for (T token : tokens) {
            sb.append(token);
        }
        return sb.toString();
    }

    protected List<ChangeObject<String>> postProcess(List<ChangeObject<String>> changeObjects, DiffOptions options) {
        return changeObjects;
    }

    protected boolean useLongestToken() {
        return false;
    }

    private List<ChangeObject<String>> buildValues(DraftChangeObject lastComponent, List<T> newTokens, List<T> oldTokens) {
        ArrayList<DraftChangeObject> components = new ArrayList<DraftChangeObject>();
        while (lastComponent != null) {
            components.add(lastComponent);
            DraftChangeObject nextComponent = lastComponent.previousComponent;
            lastComponent.previousComponent = null;
            lastComponent = nextComponent;
        }
        Collections.reverse(components);
        int componentLen = components.size();
        int newPos = 0;
        int oldPos = 0;
        for (int componentPos = 0; componentPos < componentLen; ++componentPos) {
            DraftChangeObject component = (DraftChangeObject)components.get(componentPos);
            if (!component.removed) {
                if (!component.added && this.useLongestToken()) {
                    ArrayList<T> value = new ArrayList<T>();
                    for (int i = 0; i < component.count; ++i) {
                        T newToken = newTokens.get(newPos + i);
                        T oldToken = oldTokens.get(oldPos + i);
                        if (oldToken.toString().length() > newToken.toString().length()) {
                            value.add(oldToken);
                            continue;
                        }
                        value.add(newToken);
                    }
                    component.value = this.join(value);
                } else {
                    component.value = this.join(newTokens.subList(newPos, newPos + component.count));
                }
                newPos += component.count;
                if (component.added) continue;
                oldPos += component.count;
                continue;
            }
            component.value = this.join(oldTokens.subList(oldPos, oldPos + component.count));
            oldPos += component.count;
        }
        ArrayList<ChangeObject<String>> result = new ArrayList<ChangeObject<String>>();
        for (DraftChangeObject component : components) {
            result.add(new ChangeObject<String>(component.value, component.added, component.removed, component.count));
        }
        return result;
    }

    private static class DraftChangeObject {
        boolean added;
        boolean removed;
        int count;
        DraftChangeObject previousComponent;
        String value;

        DraftChangeObject(int count, boolean added, boolean removed, DraftChangeObject previousComponent) {
            this.count = count;
            this.added = added;
            this.removed = removed;
            this.previousComponent = previousComponent;
        }

        DraftChangeObject(int count, DraftChangeObject previousComponent, boolean added, boolean removed) {
            this.count = count;
            this.previousComponent = previousComponent;
            this.added = added;
            this.removed = removed;
        }
    }

    private static class Path {
        int oldPos;
        DraftChangeObject lastComponent;

        Path(int oldPos, DraftChangeObject lastComponent) {
            this.oldPos = oldPos;
            this.lastComponent = lastComponent;
        }
    }
}

