/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.convert;

import io.github.daichangya.model.ChangeObject;
import java.util.ArrayList;
import java.util.List;

public class DmpConverter {
    public static <T> List<DmpOperation<T>> convertChangesToDMP(List<ChangeObject<T>> changes) {
        ArrayList<DmpOperation<T>> result = new ArrayList<DmpOperation<T>>();
        for (ChangeObject<T> change : changes) {
            int operation = change.isAdded() ? 1 : (change.isRemoved() ? -1 : 0);
            result.add(new DmpOperation<T>(operation, change.getValue()));
        }
        return result;
    }

    public static class DmpOperation<T> {
        private final int operation;
        private final T value;

        public DmpOperation(int operation, T value) {
            this.operation = operation;
            this.value = value;
        }

        public int getOperation() {
            return this.operation;
        }

        public T getValue() {
            return this.value;
        }

        public String toString() {
            return "[" + this.operation + ", \"" + this.value + "\"]";
        }
    }
}

