/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.convert;

import io.github.daichangya.model.ChangeObject;
import java.util.List;

public class XmlConverter {
    public static String convertChangesToXML(List<ChangeObject<String>> changes) {
        StringBuilder result = new StringBuilder();
        for (ChangeObject<String> change : changes) {
            if (change.isAdded()) {
                result.append("<ins>");
            } else if (change.isRemoved()) {
                result.append("<del>");
            }
            result.append(XmlConverter.escapeHTML(change.getValue()));
            if (change.isAdded()) {
                result.append("</ins>");
                continue;
            }
            if (!change.isRemoved()) continue;
            result.append("</del>");
        }
        return result.toString();
    }

    private static String escapeHTML(String s) {
        String result = s;
        result = result.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        result = result.replace("\"", "&quot;");
        return result;
    }
}

