/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.diff;

import io.github.daichangya.Diff;
import io.github.daichangya.model.ChangeObject;
import io.github.daichangya.model.DiffOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayDiff<T>
extends Diff<T> {
    private List<T> oldListCache;
    private List<T> newListCache;

    public static <T> List<ChangeObject<String>> diffArrays(T[] oldArr, T[] newArr) {
        return ArrayDiff.diffArrays(Arrays.asList(oldArr), Arrays.asList(newArr));
    }

    public static <T> List<ChangeObject<String>> diffArrays(List<T> oldList, List<T> newList) {
        return ArrayDiff.diffArrays(oldList, newList, new DiffOptions());
    }

    public static <T> List<ChangeObject<String>> diffArrays(List<T> oldList, List<T> newList, DiffOptions options) {
        ArrayDiff<T> arrayDiff = new ArrayDiff<T>();
        String oldStr = ArrayDiff.serializeList(oldList);
        String newStr = ArrayDiff.serializeList(newList);
        arrayDiff.oldListCache = oldList;
        arrayDiff.newListCache = newList;
        return arrayDiff.diff(oldStr, newStr, options);
    }

    private static <T> String serializeList(List<T> list) {
        return "__LIST__:" + list.size();
    }

    @Override
    protected List<T> tokenize(String value, DiffOptions options) {
        if (value.startsWith("__LIST__:")) {
            List<T> sourceList;
            int size = Integer.parseInt(value.substring(9));
            ArrayList<T> result = new ArrayList<T>(size);
            List<T> list = sourceList = this.oldListCache != null && this.oldListCache.size() == size ? this.oldListCache : this.newListCache;
            if (sourceList != null) {
                result.addAll(sourceList);
            }
            return result;
        }
        return new ArrayList();
    }

    @Override
    protected String join(List<T> tokens) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(tokens.get(i));
        }
        return sb.toString();
    }

    @Override
    protected List<T> removeEmpty(List<T> array) {
        return array;
    }
}

