/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.diff;

import io.github.daichangya.Diff;
import io.github.daichangya.model.ChangeObject;
import io.github.daichangya.model.DiffOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CssDiff
extends Diff<String> {
    private static final CssDiff INSTANCE = new CssDiff();
    private static final Pattern CSS_TOKEN_PATTERN = Pattern.compile("([{}:;,]|\\s+)");

    public static CssDiff getInstance() {
        return INSTANCE;
    }

    public static List<ChangeObject<String>> diffCss(String oldStr, String newStr) {
        return INSTANCE.diff(oldStr, newStr);
    }

    public static List<ChangeObject<String>> diffCss(String oldStr, String newStr, DiffOptions options) {
        return INSTANCE.diff(oldStr, newStr, options);
    }

    @Override
    protected List<String> tokenize(String value, DiffOptions options) {
        String[] parts = CSS_TOKEN_PATTERN.split(value, -1);
        ArrayList<String> tokens = new ArrayList<String>();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            tokens.add(part);
        }
        return tokens;
    }
}

