/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.diff;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.github.daichangya.Diff;
import io.github.daichangya.diff.LineDiff;
import io.github.daichangya.model.ChangeObject;
import io.github.daichangya.model.DiffOptions;
import java.util.List;

public class JsonDiff
extends Diff<String> {
    private static final JsonDiff INSTANCE = new JsonDiff();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static JsonDiff getInstance() {
        return INSTANCE;
    }

    public static List<ChangeObject<String>> diffJson(Object oldObj, Object newObj) {
        return INSTANCE.diffObjects(oldObj, newObj);
    }

    public static List<ChangeObject<String>> diffJson(Object oldObj, Object newObj, DiffOptions options) {
        return INSTANCE.diffObjects(oldObj, newObj, options);
    }

    public List<ChangeObject<String>> diffObjects(Object oldObj, Object newObj) {
        return this.diffObjects(oldObj, newObj, new DiffOptions());
    }

    public List<ChangeObject<String>> diffObjects(Object oldObj, Object newObj, DiffOptions options) {
        String oldStr = this.serialize(oldObj);
        String newStr = this.serialize(newObj);
        return this.diff(oldStr, newStr, options);
    }

    @Override
    protected boolean useLongestToken() {
        return true;
    }

    @Override
    protected String castInput(String value, DiffOptions options) {
        return value;
    }

    @Override
    protected boolean equals(String left, String right, DiffOptions options) {
        left = left.replaceAll(",([\r\n])", "$1");
        right = right.replaceAll(",([\r\n])", "$1");
        return super.equals(left, right, options);
    }

    @Override
    protected List<String> tokenize(String value, DiffOptions options) {
        return LineDiff.getInstance().tokenize(value, options);
    }

    private String serialize(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize object to JSON", e);
        }
    }

    static {
        OBJECT_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        OBJECT_MAPPER.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }
}

