/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.diff;

import io.github.daichangya.Diff;
import io.github.daichangya.model.ChangeObject;
import io.github.daichangya.model.DiffOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LineDiff
extends Diff<String> {
    private static final LineDiff INSTANCE = new LineDiff();
    private static final Pattern LINE_SPLIT_PATTERN = Pattern.compile("(\n|\r\n)");
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\n|\r\n");

    public static LineDiff getInstance() {
        return INSTANCE;
    }

    public static List<ChangeObject<String>> diffLines(String oldStr, String newStr) {
        return INSTANCE.diff(oldStr, newStr);
    }

    public static List<ChangeObject<String>> diffLines(String oldStr, String newStr, DiffOptions options) {
        return INSTANCE.diff(oldStr, newStr, options);
    }

    public static List<ChangeObject<String>> diffTrimmedLines(String oldStr, String newStr) {
        DiffOptions options = new DiffOptions();
        options.setIgnoreWhitespace(true);
        return INSTANCE.diff(oldStr, newStr, options);
    }

    @Override
    protected boolean equals(String left, String right, DiffOptions options) {
        if (options.isIgnoreWhitespace()) {
            if (!options.isNewlineIsToken() || !left.contains("\n")) {
                left = left.trim();
            }
            if (!options.isNewlineIsToken() || !right.contains("\n")) {
                right = right.trim();
            }
        } else if (options.isIgnoreNewlineAtEof() && !options.isNewlineIsToken()) {
            if (left.endsWith("\n")) {
                left = left.substring(0, left.length() - 1);
            }
            if (right.endsWith("\n")) {
                right = right.substring(0, right.length() - 1);
            }
        }
        return super.equals(left, right, options);
    }

    @Override
    protected List<String> tokenize(String value, DiffOptions options) {
        if (options.isStripTrailingCr()) {
            value = value.replace("\r\n", "\n");
        }
        ArrayList<String> linesAndNewlines = new ArrayList<String>();
        int start = 0;
        Matcher matcher = NEWLINE_PATTERN.matcher(value);
        while (matcher.find()) {
            linesAndNewlines.add(value.substring(start, matcher.start()));
            linesAndNewlines.add(matcher.group());
            start = matcher.end();
        }
        linesAndNewlines.add(value.substring(start));
        int size = linesAndNewlines.size();
        if (size > 0 && ((String)linesAndNewlines.get(size - 1)).isEmpty()) {
            linesAndNewlines.remove(size - 1);
        }
        ArrayList<String> retLines = new ArrayList<String>();
        for (int i = 0; i < linesAndNewlines.size(); ++i) {
            String line = (String)linesAndNewlines.get(i);
            if (i % 2 == 1 && !options.isNewlineIsToken()) {
                if (retLines.isEmpty()) continue;
                int lastIndex = retLines.size() - 1;
                retLines.set(lastIndex, (String)retLines.get(lastIndex) + line);
                continue;
            }
            retLines.add(line);
        }
        return retLines;
    }
}

