/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.diff;

import io.github.daichangya.Diff;
import io.github.daichangya.model.ChangeObject;
import io.github.daichangya.model.DiffOptions;
import java.util.ArrayList;
import java.util.List;

public class SentenceDiff
extends Diff<String> {
    private static final SentenceDiff INSTANCE = new SentenceDiff();

    public static SentenceDiff getInstance() {
        return INSTANCE;
    }

    public static List<ChangeObject<String>> diffSentences(String oldStr, String newStr) {
        return INSTANCE.diff(oldStr, newStr);
    }

    public static List<ChangeObject<String>> diffSentences(String oldStr, String newStr, DiffOptions options) {
        return INSTANCE.diff(oldStr, newStr, options);
    }

    private boolean isSentenceEndPunct(char c) {
        return c == '.' || c == '!' || c == '?';
    }

    @Override
    protected List<String> tokenize(String value, DiffOptions options) {
        ArrayList<String> result = new ArrayList<String>();
        int tokenStartI = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (i == value.length() - 1) {
                result.add(value.substring(tokenStartI));
                break;
            }
            if (!this.isSentenceEndPunct(value.charAt(i)) || i + 1 >= value.length() || !Character.isWhitespace(value.charAt(i + 1))) continue;
            result.add(value.substring(tokenStartI, i + 1));
            tokenStartI = i + 1;
            while (i + 1 < value.length() && Character.isWhitespace(value.charAt(i + 1))) {
                ++i;
            }
            result.add(value.substring(tokenStartI, i + 1));
            tokenStartI = i + 1;
        }
        return result;
    }
}

