/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.diff;

import io.github.daichangya.Diff;
import io.github.daichangya.model.ChangeObject;
import io.github.daichangya.model.DiffOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WordDiff
extends Diff<String> {
    private static final WordDiff INSTANCE = new WordDiff();
    private static final String EXTENDED_WORD_CHARS = "a-zA-Z0-9_\\u00C0-\\u00FF\\u00D8-\\u00F6\\u00F8-\\u02C6\\u02C8-\\u02D7\\u02DE-\\u02FF\\u1E00-\\u1EFF";
    private static final Pattern TOKENIZE_PATTERN = Pattern.compile("[a-zA-Z0-9_\\u00C0-\\u00FF\\u00D8-\\u00F6\\u00F8-\\u02C6\\u02C8-\\u02D7\\u02DE-\\u02FF\\u1E00-\\u1EFF]+|\\s+|[^a-zA-Z0-9_\\u00C0-\\u00FF\\u00D8-\\u00F6\\u00F8-\\u02C6\\u02C8-\\u02D7\\u02DE-\\u02FF\\u1E00-\\u1EFF]");

    public static WordDiff getInstance() {
        return INSTANCE;
    }

    public static List<ChangeObject<String>> diffWords(String oldStr, String newStr) {
        return INSTANCE.diff(oldStr, newStr);
    }

    public static List<ChangeObject<String>> diffWords(String oldStr, String newStr, DiffOptions options) {
        return INSTANCE.diff(oldStr, newStr, options);
    }

    @Override
    protected boolean equals(String left, String right, DiffOptions options) {
        if (options.isIgnoreCase()) {
            left = left.toLowerCase();
            right = right.toLowerCase();
        }
        return left.trim().equals(right.trim());
    }

    @Override
    protected List<String> tokenize(String value, DiffOptions options) {
        Matcher matcher = TOKENIZE_PATTERN.matcher(value);
        ArrayList<String> parts = new ArrayList<String>();
        while (matcher.find()) {
            parts.add(matcher.group());
        }
        ArrayList<String> tokens = new ArrayList<String>();
        String prevPart = null;
        for (String part : parts) {
            int lastIndex;
            if (part.trim().isEmpty()) {
                if (prevPart == null) {
                    tokens.add(part);
                } else {
                    lastIndex = tokens.size() - 1;
                    tokens.set(lastIndex, (String)tokens.get(lastIndex) + part);
                }
            } else if (prevPart != null && prevPart.trim().isEmpty()) {
                if (!tokens.isEmpty() && ((String)tokens.get(tokens.size() - 1)).equals(prevPart)) {
                    lastIndex = tokens.size() - 1;
                    tokens.set(lastIndex, (String)tokens.get(lastIndex) + part);
                } else {
                    tokens.add(prevPart + part);
                }
            } else {
                tokens.add(part);
            }
            prevPart = part;
        }
        return tokens;
    }

    @Override
    protected String join(List<String> tokens) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (i == 0) {
                sb.append(token);
                continue;
            }
            sb.append(token.replaceFirst("^\\s+", ""));
        }
        return sb.toString();
    }
}

