/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.patch;

import io.github.daichangya.model.PatchHunk;
import io.github.daichangya.model.StructuredPatch;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LineEndingsHandler {
    public static StructuredPatch unixToWin(StructuredPatch patch) {
        StructuredPatch result = LineEndingsHandler.copyPatch(patch);
        ArrayList<PatchHunk> newHunks = new ArrayList<PatchHunk>();
        for (PatchHunk hunk : result.getHunks()) {
            PatchHunk newHunk = new PatchHunk();
            newHunk.setOldStart(hunk.getOldStart());
            newHunk.setOldLines(hunk.getOldLines());
            newHunk.setNewStart(hunk.getNewStart());
            newHunk.setNewLines(hunk.getNewLines());
            ArrayList<String> newLines = new ArrayList<String>();
            for (int i = 0; i < hunk.getLines().size(); ++i) {
                String nextLine;
                String line = hunk.getLines().get(i);
                String string = nextLine = i + 1 < hunk.getLines().size() ? hunk.getLines().get(i + 1) : null;
                if (line.startsWith("\\") || line.endsWith("\r") || nextLine != null && nextLine.startsWith("\\")) {
                    newLines.add(line);
                    continue;
                }
                newLines.add(line + "\r");
            }
            newHunk.setLines(newLines);
            newHunks.add(newHunk);
        }
        result.setHunks(newHunks);
        return result;
    }

    public static StructuredPatch winToUnix(StructuredPatch patch) {
        StructuredPatch result = LineEndingsHandler.copyPatch(patch);
        ArrayList<PatchHunk> newHunks = new ArrayList<PatchHunk>();
        for (PatchHunk hunk : result.getHunks()) {
            PatchHunk newHunk = new PatchHunk();
            newHunk.setOldStart(hunk.getOldStart());
            newHunk.setOldLines(hunk.getOldLines());
            newHunk.setNewStart(hunk.getNewStart());
            newHunk.setNewLines(hunk.getNewLines());
            List<String> newLines = hunk.getLines().stream().map(line -> line.endsWith("\r") ? line.substring(0, line.length() - 1) : line).collect(Collectors.toList());
            newHunk.setLines(newLines);
            newHunks.add(newHunk);
        }
        result.setHunks(newHunks);
        return result;
    }

    public static boolean isUnix(StructuredPatch patch) {
        for (PatchHunk hunk : patch.getHunks()) {
            for (String line : hunk.getLines()) {
                if (line.startsWith("\\") || !line.endsWith("\r")) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isWin(StructuredPatch patch) {
        boolean hasWinEnding = false;
        block0: for (PatchHunk hunk : patch.getHunks()) {
            for (String line : hunk.getLines()) {
                if (!line.endsWith("\r")) continue;
                hasWinEnding = true;
                continue block0;
            }
        }
        if (!hasWinEnding) {
            return false;
        }
        for (PatchHunk hunk : patch.getHunks()) {
            List<String> lines = hunk.getLines();
            for (int i = 0; i < lines.size(); ++i) {
                String nextLine;
                String line = lines.get(i);
                String string = nextLine = i + 1 < lines.size() ? lines.get(i + 1) : null;
                if (line.startsWith("\\") || line.endsWith("\r") || nextLine != null && nextLine.startsWith("\\")) continue;
                return false;
            }
        }
        return true;
    }

    private static StructuredPatch copyPatch(StructuredPatch patch) {
        StructuredPatch copy = new StructuredPatch();
        copy.setOldFileName(patch.getOldFileName());
        copy.setNewFileName(patch.getNewFileName());
        copy.setOldHeader(patch.getOldHeader());
        copy.setNewHeader(patch.getNewHeader());
        copy.setIndex(patch.getIndex());
        copy.setHunks(new ArrayList<PatchHunk>(patch.getHunks()));
        return copy;
    }
}

