/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.patch;

import io.github.daichangya.model.PatchHunk;
import io.github.daichangya.model.StructuredPatch;
import io.github.daichangya.patch.LineEndingsHandler;
import io.github.daichangya.patch.PatchParser;
import io.github.daichangya.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PatchApplier {
    public static String applyPatch(String source, String patch) {
        List<StructuredPatch> patches = PatchParser.parsePatch(patch);
        if (patches.size() != 1) {
            throw new IllegalArgumentException("applyPatch only works with a single input.");
        }
        return PatchApplier.applyPatch(source, patches.get(0), new ApplyPatchOptions());
    }

    public static String applyPatch(String source, StructuredPatch patch) {
        return PatchApplier.applyPatch(source, patch, new ApplyPatchOptions());
    }

    public static String applyPatch(String source, StructuredPatch patch, ApplyPatchOptions options) {
        if (options.isAutoConvertLineEndings()) {
            if (StringUtil.hasOnlyWinLineEndings(source) && LineEndingsHandler.isUnix(patch)) {
                patch = LineEndingsHandler.unixToWin(patch);
            } else if (StringUtil.hasOnlyUnixLineEndings(source) && LineEndingsHandler.isWin(patch)) {
                patch = LineEndingsHandler.winToUnix(patch);
            }
        }
        List<String> lines = new ArrayList<String>(Arrays.asList(source.split("\n", -1)));
        List<PatchHunk> hunks = patch.getHunks();
        if (hunks.isEmpty()) {
            return source;
        }
        int fuzzFactor = options.getFuzzFactor();
        if (fuzzFactor < 0) {
            throw new IllegalArgumentException("fuzzFactor must be a non-negative integer");
        }
        int offset = 0;
        for (PatchHunk hunk : hunks) {
            int toPos;
            ApplyHunkResult result = PatchApplier.applyHunk(lines, hunk, toPos = hunk.getOldStart() - 1 + offset, fuzzFactor);
            if (result == null) {
                return null;
            }
            lines = result.lines;
            offset += result.offset;
        }
        return String.join((CharSequence)"\n", lines);
    }

    private static ApplyHunkResult applyHunk(List<String> lines, PatchHunk hunk, int toPos, int fuzzFactor) {
        List<String> hunkLines = hunk.getLines();
        ArrayList<String> oldLines = new ArrayList<String>();
        ArrayList<String> newLines = new ArrayList<String>();
        for (String line : hunkLines) {
            if (line.startsWith("-")) {
                oldLines.add(line.substring(1));
                continue;
            }
            if (line.startsWith("+")) {
                newLines.add(line.substring(1));
                continue;
            }
            if (!line.startsWith(" ")) continue;
            oldLines.add(line.substring(1));
            newLines.add(line.substring(1));
        }
        if (toPos < 0 || toPos > lines.size()) {
            return null;
        }
        int matchCount = 0;
        for (int i = 0; i < oldLines.size() && toPos + i < lines.size(); ++i) {
            if (!lines.get(toPos + i).equals(oldLines.get(i))) continue;
            ++matchCount;
        }
        if (matchCount < oldLines.size() - fuzzFactor) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(lines.subList(0, toPos));
        result.addAll(newLines);
        if (toPos + oldLines.size() < lines.size()) {
            result.addAll(lines.subList(toPos + oldLines.size(), lines.size()));
        }
        int offset = newLines.size() - oldLines.size();
        return new ApplyHunkResult(result, offset);
    }

    private static class ApplyHunkResult {
        List<String> lines;
        int offset;

        ApplyHunkResult(List<String> lines, int offset) {
            this.lines = lines;
            this.offset = offset;
        }
    }

    public static class ApplyPatchOptions {
        private int fuzzFactor = 0;
        private boolean autoConvertLineEndings = true;

        public int getFuzzFactor() {
            return this.fuzzFactor;
        }

        public void setFuzzFactor(int fuzzFactor) {
            this.fuzzFactor = fuzzFactor;
        }

        public boolean isAutoConvertLineEndings() {
            return this.autoConvertLineEndings;
        }

        public void setAutoConvertLineEndings(boolean autoConvertLineEndings) {
            this.autoConvertLineEndings = autoConvertLineEndings;
        }
    }
}

