/*
 * Decompiled with CFR 0.152.
 */
package io.github.daichangya.patch;

import io.github.daichangya.diff.LineDiff;
import io.github.daichangya.model.ChangeObject;
import io.github.daichangya.model.DiffOptions;
import io.github.daichangya.model.PatchHunk;
import io.github.daichangya.model.StructuredPatch;
import java.util.ArrayList;
import java.util.List;

public class PatchCreator {
    public static StructuredPatch structuredPatch(String oldFileName, String newFileName, String oldStr, String newStr) {
        return PatchCreator.structuredPatch(oldFileName, newFileName, oldStr, newStr, null, null, 4);
    }

    public static StructuredPatch structuredPatch(String oldFileName, String newFileName, String oldStr, String newStr, String oldHeader, String newHeader, int context) {
        DiffOptions options = new DiffOptions();
        List<ChangeObject<String>> diff = LineDiff.diffLines(oldStr, newStr, options);
        return PatchCreator.diffToPatch(oldFileName, newFileName, diff, oldHeader, newHeader, context);
    }

    public static String createTwoFilesPatch(String oldFileName, String newFileName, String oldStr, String newStr) {
        return PatchCreator.createTwoFilesPatch(oldFileName, newFileName, oldStr, newStr, null, null, 4);
    }

    public static String createTwoFilesPatch(String oldFileName, String newFileName, String oldStr, String newStr, String oldHeader, String newHeader, int context) {
        StructuredPatch patch = PatchCreator.structuredPatch(oldFileName, newFileName, oldStr, newStr, oldHeader, newHeader, context);
        return PatchCreator.formatPatch(patch);
    }

    public static String createPatch(String fileName, String oldStr, String newStr) {
        return PatchCreator.createTwoFilesPatch(fileName, fileName, oldStr, newStr);
    }

    public static String formatPatch(StructuredPatch patch) {
        StringBuilder result = new StringBuilder();
        if (patch.getOldFileName().equals(patch.getNewFileName())) {
            result.append("Index: ").append(patch.getOldFileName()).append("\n");
            result.append("===================================================================\n");
        }
        result.append("--- ").append(patch.getOldFileName());
        if (patch.getOldHeader() != null) {
            result.append("\t").append(patch.getOldHeader());
        }
        result.append("\n");
        result.append("+++ ").append(patch.getNewFileName());
        if (patch.getNewHeader() != null) {
            result.append("\t").append(patch.getNewHeader());
        }
        result.append("\n");
        for (PatchHunk hunk : patch.getHunks()) {
            result.append("@@ -").append(hunk.getOldStart()).append(",").append(hunk.getOldLines()).append(" +").append(hunk.getNewStart()).append(",").append(hunk.getNewLines()).append(" @@\n");
            for (String line : hunk.getLines()) {
                result.append(line);
                if (line.endsWith("\n")) continue;
                result.append("\n");
            }
        }
        return result.toString();
    }

    private static StructuredPatch diffToPatch(String oldFileName, String newFileName, List<ChangeObject<String>> diff, String oldHeader, String newHeader, int context) {
        StructuredPatch patch = new StructuredPatch(oldFileName, newFileName);
        patch.setOldHeader(oldHeader);
        patch.setNewHeader(newHeader);
        ArrayList<PatchHunk> hunks = new ArrayList<PatchHunk>();
        int oldLine = 1;
        int newLine = 1;
        ArrayList<String> curRange = new ArrayList<String>();
        int oldRangeStart = 0;
        int newRangeStart = 0;
        ArrayList<ChangeObject<String>> extendedDiff = new ArrayList<ChangeObject<String>>(diff);
        extendedDiff.add(new ChangeObject<String>("", false, false, 0));
        for (int i = 0; i < extendedDiff.size(); ++i) {
            ChangeObject current = (ChangeObject)extendedDiff.get(i);
            String[] lines = PatchCreator.splitLines((String)current.getValue());
            if (current.isAdded() || current.isRemoved()) {
                if (oldRangeStart == 0) {
                    oldRangeStart = oldLine;
                    newRangeStart = newLine;
                    if (i > 0) {
                        int startContext;
                        ChangeObject prev = (ChangeObject)extendedDiff.get(i - 1);
                        String[] prevLines = PatchCreator.splitLines((String)prev.getValue());
                        for (int j = startContext = Math.max(0, prevLines.length - context); j < prevLines.length; ++j) {
                            curRange.add(" " + prevLines[j]);
                        }
                        oldRangeStart -= prevLines.length - startContext;
                        newRangeStart -= prevLines.length - startContext;
                    }
                }
                for (String line : lines) {
                    curRange.add((current.isAdded() ? "+" : "-") + line);
                }
                if (current.isAdded()) {
                    newLine += lines.length;
                    continue;
                }
                oldLine += lines.length;
                continue;
            }
            if (oldRangeStart != 0) {
                for (int j = 0; j < Math.min(context, lines.length); ++j) {
                    curRange.add(" " + lines[j]);
                }
                PatchHunk hunk = new PatchHunk();
                hunk.setOldStart(oldRangeStart);
                hunk.setNewStart(newRangeStart);
                hunk.setOldLines((int)curRange.stream().filter(l -> l.startsWith(" ") || l.startsWith("-")).count());
                hunk.setNewLines((int)curRange.stream().filter(l -> l.startsWith(" ") || l.startsWith("+")).count());
                hunk.setLines(new ArrayList<String>(curRange));
                hunks.add(hunk);
                oldRangeStart = 0;
                newRangeStart = 0;
                curRange.clear();
            }
            oldLine += lines.length;
            newLine += lines.length;
        }
        patch.setHunks(hunks);
        return patch;
    }

    private static String[] splitLines(String value) {
        if (value == null || value.isEmpty()) {
            return new String[0];
        }
        if (value.endsWith("\n")) {
            value = value.substring(0, value.length() - 1);
            String[] lines = value.split("\n", -1);
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = lines[i] + "\n";
            }
            return lines;
        }
        return value.split("\n", -1);
    }
}

